VERSION 5.00
Begin VB.Form frmApproveWord 
   Caption         =   "Approve Word"
   ClientHeight    =   7785
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8790
   Icon            =   "frmApproveWord.frx":0000
   LinkTopic       =   "Form2"
   ScaleHeight     =   7785
   ScaleWidth      =   8790
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdGoBack 
      Caption         =   "Go back one"
      Height          =   375
      Left            =   2400
      TabIndex        =   13
      Top             =   5400
      Width           =   2415
   End
   Begin VB.CommandButton cmd2131 
      Caption         =   "2131"
      Height          =   255
      Left            =   5400
      TabIndex        =   11
      Top             =   5880
      Width           =   2175
   End
   Begin VB.CommandButton cmd1311 
      Caption         =   "1311"
      Height          =   255
      Left            =   5400
      TabIndex        =   10
      Top             =   5400
      Width           =   2175
   End
   Begin VB.CommandButton cmdGuessStress 
      Caption         =   "guess stress from string"
      Height          =   315
      Left            =   5400
      TabIndex        =   9
      Top             =   3480
      Width           =   2175
   End
   Begin VB.CommandButton cmd1 
      Caption         =   "1"
      Height          =   255
      Left            =   5400
      TabIndex        =   8
      Top             =   3960
      Width           =   2175
   End
   Begin VB.CommandButton cmd131 
      Caption         =   "131"
      Height          =   255
      Left            =   5400
      TabIndex        =   7
      Top             =   4920
      Width           =   2175
   End
   Begin VB.CommandButton cmd13 
      Caption         =   "13"
      Height          =   255
      Left            =   5400
      TabIndex        =   6
      Top             =   4440
      Width           =   2175
   End
   Begin VB.CommandButton cmdQuit 
      Caption         =   "Quit"
      Height          =   375
      Left            =   2400
      TabIndex        =   5
      Top             =   6480
      Width           =   2415
   End
   Begin VB.CommandButton cmdOk 
      Caption         =   "ok"
      Height          =   735
      Left            =   2040
      TabIndex        =   2
      Top             =   3960
      Width           =   3015
   End
   Begin VB.TextBox txtStressPattern 
      Alignment       =   2  'Center
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   735
      Left            =   2040
      TabIndex        =   1
      Top             =   2880
      Width           =   3015
   End
   Begin VB.TextBox txtSyllables 
      Alignment       =   2  'Center
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   735
      Left            =   2040
      TabIndex        =   0
      Top             =   1680
      Width           =   3015
   End
   Begin VB.Label lblProgress 
      Alignment       =   1  'Right Justify
      Caption         =   "Label1"
      Height          =   255
      Left            =   5880
      TabIndex        =   12
      Top             =   7440
      Width           =   2415
   End
   Begin VB.Label lblWord 
      Alignment       =   2  'Center
      Caption         =   "Label2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   600
      TabIndex        =   4
      Top             =   1080
      Width           =   5535
   End
   Begin VB.Label lblLine 
      Alignment       =   2  'Center
      Caption         =   "Label1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   3
      Top             =   360
      Width           =   6495
   End
End
Attribute VB_Name = "frmApproveWord"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Let the user edit or approve a syllabification and stress pattern


Private Sub Form_Load()

    'Center this form on the user's screen.
        Let Me.Top = (Screen.Height - Me.Height) / 2
        Let Me.Left = (Screen.Width - Me.Width) / 2

End Sub

Public Function GuessStress(MyString As String) As String

    'Guess a stress pattern, assuming a content word with initial stress.
        
        Dim i As Long
        Dim PostHyphenFlag As Boolean
        Dim Post2Flag As Boolean
        Dim Buffer As String
        
    'We need different rules for compounds vs. simplex words.
    '   Compounds can be detected if there is a hyphen.
        If s.NumberContainedIn(txtSyllables.Text, "-") > 0 Then
            'Assume initial main stress.
                Let Buffer = "3"
            'Assign stress to the rest of the compound, assuming its elements are all
            '   initially stressed.
                For i = 1 To Len(txtSyllables.Text)
                    Select Case Mid(txtSyllables.Text, i, 1)
                        Case "-"
                            Let PostHyphenFlag = True
                        Case " "
                            If PostHyphenFlag = True Then
                                If Post2Flag = True Then
                                    'This part of the compound already has gotten its stress.
                                        Let Buffer = Buffer + "1"
                                Else
                                    'Initial 2 stress for non-initial compound members.
                                        Let Buffer = Buffer + "2"
                                    'Other syllables will receive 1.
                                        Let Post2Flag = True
                                End If
                            Else
                                Let Buffer = Buffer + "1"
                            End If
                        End Select
                Next i
        
        Else
            'Simplex words are assumed to have initial stress.  Add a "1" to "3" for each
            '   blank space to compute this.
                Let Buffer = "3"
                For i = 1 To Len(txtSyllables.Text)
                    If Mid(txtSyllables.Text, i, 1) = " " Then
                        Let Buffer = Buffer + "1"
                    End If
                Next i
        End If
        
        Let GuessStress = Buffer

End Function


Private Sub cmdGuessStress_Click()

    Let txtStressPattern = GuessStress(txtSyllables)

End Sub


Private Sub cmdOk_Click()

    'See if the stress pattern is a good one.
    '   If not, force user to fix it and click again.
        If VetEntries = False Then Exit Sub
    
    'It's ok, so store the results in the dictionary.
        Let gNumberOfDictionaryEntries = gNumberOfDictionaryEntries + 1
        
        ReDim Preserve gStoredWords(gNumberOfDictionaryEntries)
        ReDim Preserve gStoredStressPatterns(gNumberOfDictionaryEntries)
        ReDim Preserve gStoredSyllabifications(gNumberOfDictionaryEntries)
                
        Let gStoredWords(gNumberOfDictionaryEntries) = lblWord.Caption
        Let gStoredStressPatterns(gNumberOfDictionaryEntries) = txtStressPattern.Text
        Let gStoredSyllabifications(gNumberOfDictionaryEntries) = txtSyllables.Text
        
    'Report the result back to the main routine.
        Let Form1.mSyllabificationBuffer = txtSyllables.Text
        Let Form1.mStressBuffer = txtStressPattern.Text
    
    Unload Me

End Sub

Function VetEntries() As Boolean

    Dim NumberOf1 As Long
    Dim NumberOf2 As Long
    Dim NumberOf3 As Long
    Dim NumberOfHyphens As Long
    Dim NumberOfSpaces As Long
        
    Dim i As Long
    
    'Count the stresses of various kinds.
        Let NumberOf1 = s.NumberContainedIn(txtStressPattern.Text, "1")
        Let NumberOf2 = s.NumberContainedIn(txtStressPattern.Text, "2")
        Let NumberOf3 = s.NumberContainedIn(txtStressPattern.Text, "3")
        Let NumberOfHyphens = s.NumberContainedIn(txtSyllables.Text, "-")
        Let NumberOfSpaces = s.NumberContainedIn(txtSyllables.Text, " ")
    
    'Check that the stress pattern has only 1, 2, or 3.
        For i = 1 To Len(txtStressPattern.Text)
            Select Case Mid(txtStressPattern.Text, i, 1)
                Case "1", "2", "3"
                    'do nothing
                Case Else
                    MsgBox "Your stress pattern has a bad symbol:  " + Mid(txtStressPattern.Text, i, 1)
                    Let VetEntries = False
            End Select
        Next i
        
    'Impose various consistency checks.
    
        If NumberOf3 > 1 Then
            MsgBox "No word can have two [3stress] syllables."
            Let VetEntries = False
            Exit Function
        End If
        
        If Len(txtStressPattern.Text) > 1 And NumberOf1 = Len(txtStressPattern.Text) Then
            MsgBox "Every polysyllabic word must have at least one 3 or 2 stress."
            Let VetEntries = False
            Exit Function
        End If
        
        If txtStressPattern.Text = "2" Then
            MsgBox "In the system used here, only polysyllabic function words may bear [2stress]."
            Let VetEntries = False
            Exit Function
        End If
        
        If txtStressPattern.Text = "1" Then
            If MsgBox("Are you sure you want to enter this?  Only function words are possible.", vbYesNo) = vbNo Then
                Let VetEntries = False
                Exit Function
            Else
                Let VetEntries = True
                Exit Function
            End If
        End If
        
        If NumberOf3 = 0 Then
            If MsgBox("Are you sure you want to enter this?  Most words have one [3stress].", vbYesNo) = vbNo Then
                Let VetEntries = False 'B
                Exit Function
            End If
        End If
        
        If NumberOfHyphens > 0 And NumberOf2 <> NumberOfHyphens Then
            If MsgBox("Are you sure you want to enter this?  Usually the number of hyphens is the same as the number of stresses (due to compound stress).", vbYesNo) = vbNo Then
                Let VetEntries = False
                Exit Function
            End If
        End If
        
        If NumberOfSpaces <> Len(txtStressPattern.Text) - 1 Then
            MsgBox "The number of spaces in text in the syllabification window must be one less than the number of characters in the stress pattern.  Please fix your entry."
            Let VetEntries = False
            Exit Function
        End If
        
    

    Let VetEntries = True
   
    
End Function

Function NumberOfSpaces(MyString As String) As Long

    Dim i As Long
    
    For i = 1 To Len(MyString)
        If Mid(MyString, i, 1) = " " Then
            Let NumberOfSpaces = NumberOfSpaces + 1
        End If
    Next i
        
End Function


Private Sub cmdQuit_Click()

    Let gExitFlag = True
    Unload Me

End Sub

'Buttons for quickly assigning stress

Private Sub cmd1_Click()
    Let txtStressPattern.Text = "1"
    Call cmdOk_Click
End Sub
Private Sub cmd13_Click()
    Let txtStressPattern.Text = "13"
    Call cmdOk_Click
End Sub
Private Sub cmd131_Click()
    Let txtStressPattern.Text = "131"
    Call cmdOk_Click
End Sub

Private Sub cmd1311_Click()
    Let txtStressPattern.Text = "1311"
    Call cmdOk_Click
End Sub

Private Sub cmd2131_Click()
    Let txtStressPattern.Text = "2131"
    Call cmdOk_Click
End Sub


Private Sub cmdGoBack_Click()

    Let gNumberOfDictionaryEntries = gNumberOfDictionaryEntries - 1
    'Record a flag that indicates that the line is no good.
        Let Form1.mSyllabificationBuffer = "Oh god, you've made a terrible mistake."
    Unload Me

End Sub

