VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Syllabify lines"
   ClientHeight    =   3855
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   Icon            =   "Syllabify.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3855
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame2 
      Caption         =   "Last line done"
      Height          =   855
      Left            =   480
      TabIndex        =   3
      Top             =   2520
      Width           =   3855
      Begin VB.TextBox txtLastLineDone 
         Alignment       =   2  'Center
         Height          =   405
         Left            =   120
         TabIndex        =   4
         Text            =   "Text1"
         Top             =   240
         Width           =   3615
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "File to work with"
      Height          =   735
      Left            =   480
      TabIndex        =   1
      Top             =   1560
      Width           =   3855
      Begin VB.TextBox txtFileName 
         Alignment       =   2  'Center
         Height          =   375
         Left            =   120
         TabIndex        =   2
         Text            =   "Text1"
         Top             =   240
         Width           =   3615
      End
   End
   Begin VB.CommandButton Command1 
      Caption         =   "&Go"
      Height          =   735
      Left            =   480
      TabIndex        =   0
      Top             =   480
      Width           =   3855
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Input poetic lines and output a rough syllable-by-syllable version, with word boundaries.
'Current version has user approve each word, gradually expanding a dictionary.

Option Explicit

    Dim mFileName As String
    Dim mTotalNumberOfLines As Long
    Public mNumberOfLines As Long
    Dim mLastLineDone As Long
   
    Dim mLines() As String
   
    Public mSyllabificationBuffer As String     'To get information back from the user-vetting window.
    Public mStressBuffer  As String             'To get information back from the user-vetting window.
    Public mJunctureBuffer  As String           'To get information back from the user-vetting window.
    Public mNewEntryMade As Boolean
   
   Const mMinimumLineLength As Long = 10
  
   
Private Sub Form_Load()

    'Center the form
        Let Me.Top = (Screen.Height - Me.Height) / 2
        Let Me.Left = (Screen.Width - Me.Width) / 2
        
    'Place old information on the form.
        Call ReadTheMemoryFile
        Let txtFileName.Text = mFileName
        Let txtLastLineDone.Text = Trim(Str(mLastLineDone))

End Sub



Private Sub Command1_Click()

   Dim i As Long, PositionIndex As Long
   Dim MyLine As String
   Dim MyPunctuation As String
   Dim WordBuffer As String
   Dim LocalLineBuffer As String        'These keep, in this routine, the processed material you already have.
   Dim LocalStressBuffer As String
   Dim LocalJunctureBuffer As String
   Dim NewlyAdded As String
   
   Dim LineIndex As Long
   
   Dim MySymbol As String
   Dim WordFinal As Boolean
   
   Dim MemoryFile As Long
   
    'Grab the crucial information off the interface if the user has changed it.
        Let mFileName = txtFileName.Text
        Let mLastLineDone = Val(txtLastLineDone.Text)
    
    Call ReadTheDictionary
    Call ReadThePoetry
    
    'Write to the memory file, since user has committed to a file name.
        Let MemoryFile = FreeFile
        Open App.Path + "/RememberInformation.txt" For Output As #MemoryFile
        Print #MemoryFile, "File name:"
        Print #MemoryFile, Trim(mFileName)
        Print #MemoryFile, "Last line done:"
        Print #MemoryFile, Trim(Str(mLastLineDone))
        Close #MemoryFile
    
    'Open the output file.
        Call OpenOutputFile
        
    'Main loop:  go through all the lines.
    
    For LineIndex = 1 To mTotalNumberOfLines
        
ErrorRestartPoint:
        'Initialize variables, to start the new line.
            Let mStressBuffer = ""
            Let mJunctureBuffer = ""
            Let WordBuffer = ""
            Let MyPunctuation = ""
            Let mNewEntryMade = False
            
            Let MyLine = mLines(LineIndex)
            
        'Debug
            'If Replace(MyLine, "private Greeks", "xxx") <> MyLine Then
            '    MsgBox "This box is just for debugging; click Ok to continue normally."
            'End If
            
        
        'Short lines are poem names, usually.  Also, avoid blanks.
            If Len(MyLine) < mMinimumLineLength Then GoTo WholeLineEscapePoint
        
        'Do some preprocessing (adjust punctuation, etc.)
            Let MyLine = WholeLineCleanup(MyLine)
        
        'Parse this line into words, each of which will be processed separately.
            For i = Len(MyLine) To 1 Step -1
                Let MySymbol = Mid(MyLine, i, 1)
                Select Case MySymbol
                    Case "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"
                        'A letter can simply be added to the word in progress.
                            Let WordBuffer = MySymbol + WordBuffer
                    Case "", "", "", "", "", "", "", "", "", ""
                        'Ditto for accented letters.
                            Let WordBuffer = MySymbol + WordBuffer
                    Case "'", "-"
                        'Apostrophes and hyphens have special behavior for silent e (see later), but
                        '  otherwise are like letters.
                            Let WordBuffer = MySymbol + WordBuffer
                    Case ".", ",", ";", ":", "?", "!", "%", "(", "!", ")"
                        'Punctuation is part of a line, but not part of a word.  Remember it, in order
                        '   to make a juncture profile.
                        'Note that " (" has been turned into punctuation on the ''preceding'' word, as
                        '   is appropriate for a prosodic break-maker.
                        'However, ) is still present, line finally.  This was the source of a bug.
                            Let LocalLineBuffer = MySymbol + LocalLineBuffer
                            Let MyPunctuation = MySymbol
                    Case Else
                        'Not a letter, not punctuation--time to syllabify the word and add it in.
                        'NewlyAdded is the buffer variable used here.
                            Let NewlyAdded = Syllabified(WordBuffer, MyLine)
                        'Allow user to start the line again.
                            If NewlyAdded = "Oh god, you've made a terrible mistake." Then
                                Let LineIndex = LineIndex - 1
                                GoTo ErrorRestartPoint
                            End If
                            
                            'Add the word, plus the symbol that cued us that it's a left word edge.
                                Let LocalLineBuffer = MySymbol + NewlyAdded + LocalLineBuffer
                            'The function Syllabified() called another form, in which the user might
                            '   have chosen to quit.
                                If gExitFlag = True Then GoTo QuittingPoint
                        'Add in other material computed by the Syllabified() function.
                            'Stress must first undergo the Nuclear Stress Rule, promoting some 3 to 4:
                                Let LocalStressBuffer = NuclearStressRule(mStressBuffer, LocalStressBuffer, MyPunctuation)
                            'Juncture is computed (partially) from word boundaries, clitic status, punctuation:
                                Let LocalJunctureBuffer = JunctureString(NewlyAdded, mStressBuffer, MyPunctuation) + LocalJunctureBuffer
                        'Initialize word-level variables for next word to be found.
                            Let WordBuffer = ""
                            Let MyPunctuation = ""
                End Select                          'What symbol did we just encounter?
            Next i                                  'Go through the whole line.
            
            'Once you've parsed the whole line, you need to deal with the first word, just like the others.
                Let NewlyAdded = Syllabified(WordBuffer, MyLine)
                If gExitFlag = True Then GoTo QuittingPoint
                Let LocalLineBuffer = NewlyAdded + LocalLineBuffer
                Let LocalStressBuffer = NuclearStressRule(mStressBuffer, LocalStressBuffer, MyPunctuation)
                Let LocalJunctureBuffer = JunctureString(NewlyAdded, mStressBuffer, MyPunctuation) + LocalJunctureBuffer
                Let WordBuffer = ""
                Let MyPunctuation = ""
    
    'Now finished with this line, so report progress:
        Let mNumberOfLines = mNumberOfLines + 1
        If Int(mNumberOfLines / 100) = mNumberOfLines / 100 Then
            Let Command1.Caption = "Completed " + Trim(Str(mNumberOfLines)) + " lines"
        End If
        
    'Let the user know about lines that needed no entries.
        If mNewEntryMade = False Then
            If mNumberOfLines >= mLastLineDone Then
                Call PostTheVacuousBox(MyLine)
                'Quit if, on seeing this box, the user asked.
                    If gExitFlag = True Then GoTo QuittingPoint
            End If
        End If
    
    'Print what you learned from this line to the structural file.
        Print #2, Trim(Str(mNumberOfLines)); Chr(9); "syllables"; Chr(9); MyLine; Chr(9);
        'The next bit seems to result in trouble, the old way I did it.  Let's try a more careful version.
            Let LocalLineBuffer = Trim(LocalLineBuffer)
            For PositionIndex = 1 To Len(LocalLineBuffer)
                Let MySymbol = Mid(LocalLineBuffer, PositionIndex, 1)
                If MySymbol = " " Then
                    Print #2, Chr(9);
                Else
                    Print #2, MySymbol;
                End If
            Next PositionIndex
            Print #2,
            'Old, apparently troublesome code:
                'Replace(LocalLineBuffer, " ", Chr(9))
        'Separate out the stresses by tabs:
            Print #2, Trim(Str(mNumberOfLines)); Chr(9); "stress"; Chr(9); MyLine;
            For i = 1 To Len(LocalStressBuffer)
                Print #2, Chr(9); Mid(LocalStressBuffer, i, 1);
            Next i
            Print #2,
        'Separate out the junctures by tabs:
            Print #2, Trim(Str(mNumberOfLines)); Chr(9); "juncture"; Chr(9); MyLine;
            For i = 1 To Len(LocalJunctureBuffer)
                Print #2, Chr(9); Mid(LocalJunctureBuffer, i, 1);
            Next i
            Print #2,
        'Print a blank comment line for use by future programs
            Print #2, Trim(Str(mNumberOfLines)); Chr(9); "comment"; Chr(9); MyLine
            
        
    'Initialize the buffers in preperation for the next line.
        Let LocalLineBuffer = ""
        Let LocalStressBuffer = ""
        Let LocalJunctureBuffer = ""
        Let mNewEntryMade = False
       
       
WholeLineEscapePoint:
    Next LineIndex          'Loop through all the lines.
    
QuittingPoint:

    If LineIndex > mLastLineDone Then
        Let mLastLineDone = LineIndex
    End If
    'Write to the memory file, since user has committed to a file name.
        Let MemoryFile = FreeFile
        Open App.Path + "/RememberInformation.txt" For Output As #MemoryFile
        Print #MemoryFile, "File name:"
        Print #MemoryFile, Trim(mFileName)
        Print #MemoryFile, "Last line done:"
        Print #MemoryFile, Trim(Str(mLastLineDone))
        Close #MemoryFile
    
    'Save dictionary if user wants.
        If MsgBox("Save changes to dictionary?", vbYesNo) = vbYes Then
            Call PrintOutputFiles
            MsgBox "Your output file is:  " + App.Path + "OutputFileFor" + mFileName
        End If
    
    'Finish.
        End
        
        
End Sub

Sub ReadTheDictionary()

    On Error GoTo ErrorPoint
    
    Dim MyLine As String
    
    Open App.Path + "/dictionary.txt" For Input As #1
    
    Do While Not EOF(1)
        Line Input #1, MyLine
        Let gNumberOfDictionaryEntries = gNumberOfDictionaryEntries + 1
        ReDim Preserve gStoredWords(gNumberOfDictionaryEntries)
        ReDim Preserve gStoredSyllabifications(gNumberOfDictionaryEntries)
        ReDim Preserve gStoredStressPatterns(gNumberOfDictionaryEntries)
        ReDim Preserve gStoredJuncturePatterns(gNumberOfDictionaryEntries)
        
        Let gStoredWords(gNumberOfDictionaryEntries) = s.Chomp(MyLine)
        Let gStoredSyllabifications(gNumberOfDictionaryEntries) = s.Chomp(s.Residue(MyLine))
        Let gStoredStressPatterns(gNumberOfDictionaryEntries) = s.Chomp(s.Residue(s.Residue(MyLine)))
        Let gStoredJuncturePatterns(gNumberOfDictionaryEntries) = s.Residue(s.Residue(s.Residue(MyLine)))
    Loop
    
    Close #1
    
        Exit Sub
        
ErrorPoint:

    MsgBox "Error occurred opening the dictionary file.  Error number is " + Str(Err.Number) + " and error description is " + Err.Description + "."

End Sub


Sub ReadThePoetry()
    
    'Count all the lines in the input file, to be able to report progress.
    
        Dim MyLine As String
    
        Open App.Path + "/" + mFileName For Input As #1
        Do While Not EOF(1)
            Line Input #1, MyLine
            'Short lines are poem names, usually.  Also, avoid blanks.
                If Len(MyLine) >= mMinimumLineLength Then
                    Let mTotalNumberOfLines = mTotalNumberOfLines + 1
                    'Quotation marks cause terrible trouble, so remove them.
                        Let MyLine = Replace(MyLine, Chr(34), "")
                    'Replace digraphs with their duplex equivalents.
                        Let MyLine = Replace(MyLine, "", "Ae")
                    ReDim Preserve mLines(mTotalNumberOfLines)
                    Let mLines(mTotalNumberOfLines) = Trim(MyLine)
                End If
        Loop
        Close #1

End Sub

Sub ReadTheMemoryFile()

    'Count all the lines in the input file, to be able to report progress.
    
        On Error GoTo ErrorPoint
        
        Dim MyLine As String
    
        Open App.Path + "/RememberInformation.txt" For Input As #1
        'Ignore caption:
            Line Input #1, MyLine
        'File name:
            Line Input #1, MyLine
            Let mFileName = Trim(MyLine)
        'Ignore caption:
            Line Input #1, MyLine
        'Last line done:
            Line Input #1, MyLine
            Let mLastLineDone = Val(Trim(MyLine))
        
        Close #1
        Exit Sub
        
ErrorPoint:
    
        'Probably the relevant file does not exist.
        '   So install some defaults.
            Close
            Let mFileName = "in.txt"
            Let mLastLineDone = 1
        

End Sub

Sub OpenOutputFile()

    On Error GoTo ErrorPoint
    Open App.Path + "/OutputFileFor" + mFileName For Output As #2
    Exit Sub
        
ErrorPoint:
    MsgBox "Error occurred opening the output file " + App.Path + "OutputFileFor" + mFileName + ".  Error number is " + Str(Err.Number) + " and error description is " + Err.Description + "."

End Sub
    

Sub PrintOutputFiles()

    'Print changes in the dictionary, as well as the memory file.
    
        Dim i As Long
        
        'Dictionary file.
            Close
            Open App.Path + "/Dictionary.txt" For Output As #2
            For i = 1 To gNumberOfDictionaryEntries
                Print #2, gStoredWords(i); Chr(9); gStoredSyllabifications(i); Chr(9); gStoredStressPatterns(i)
            Next i
            Close #2
        
            

End Sub

Function JunctureString(MyString As String, MyStress As String, MyPunctuation As String) As String

    'The juncture pattern can be deduced from a combination of the hyphens in its syllabification and
    '   the local punctuation.
    '   It is:  ...11113 unless there is punctuation, in which case it is ...11115.
    '   Medial hyphens induce a 2.
    '   4's (end of maximal projection) if any, must be added in by hand.
    
    Dim i As Long
    Dim Buffer As String
        
    'Default final juncture is 3.
        Let Buffer = "3"
        
    'But proclitics take 2.
        If Proclitic(MyString, MyStress) Then Let Buffer = "2"
        
        For i = Len(MyString) To 1 Step -1
            Select Case Mid(MyString, i, 1)
                Case " "
                    Let Buffer = "1" + Buffer
                Case "-"
                    'Previous juncture needs to be promoted to 2, since it's a compound.
                    Let Buffer = "2" + Mid(Buffer, 2)
            End Select
        Next i
        
    'Now alter according to punctuation.
        If MyPunctuation <> "" Then
            Let Buffer = Left(Buffer, Len(Buffer) - 1) + "5"
        End If
        
    Let JunctureString = Buffer
    
End Function

Function NuclearStressRule(WordStressBuffer As String, LineStressBuffer As String, MyPunctuation As String) As String

    'A very primitive implementation of the SPE Nuclear Stress rule:
    '   3 at the end of a line, or before punctuation, is promoted to 4.
        If LineStressBuffer = "" Or MyPunctuation <> "" Then
            Let WordStressBuffer = Replace(WordStressBuffer, "3", "4")
        End If
        Let NuclearStressRule = WordStressBuffer + LineStressBuffer

End Function

Function WholeLineCleanup(MyLine As String) As String

    Dim Buffer As String
    
    Let Buffer = MyLine
                
        'Microsoft apostrophes and hyphens to be replaced with regular ones.
            Let Buffer = Replace(Buffer, Chr(145), "'")     'left single quote
            Let Buffer = Replace(Buffer, Chr(146), "'")     'right single quote
            
            
        'Double quotes seems to make just too much trouble; let's remove them.
            'Let Buffer = Replace(Buffer, Chr(147), Chr(34)) 'left double quote
            'Let Buffer = Replace(Buffer, Chr(148), Chr(34)) 'right double quote
            Let Buffer = Replace(Buffer, Chr(147), "") 'left double quote
            Let Buffer = Replace(Buffer, Chr(148), "") 'right double quote
            Let Buffer = Replace(Buffer, Chr(34), "") 'left double quote
        
        'Stuff with dashes - all treated the same.
            Let Buffer = Replace(Buffer, ",--", "% ")
            Let Buffer = Replace(Buffer, ":--", "% ")
            Let Buffer = Replace(Buffer, ";--", "% ")
            Let Buffer = Replace(Buffer, "--", "% ")
        
        'Reduce multiple spaces and hyphens to single.
            Do
                If Replace(Buffer, "  ", " ") = Buffer Then GoTo DoubleSpaceExit
                Let Buffer = Replace(Buffer, "  ", " ")
            Loop
DoubleSpaceExit:

            'The string " (" is for junctural purposes a punctuation on the preceding
            '   word.
                Let Buffer = Replace(Buffer, " (", "( ")
                
    Let WholeLineCleanup = Trim(Buffer)
       

End Function

Function HasVowel(MyString As String) As Boolean

    'We want to know if there is another vowel coming up in this word, during our leftward scan.
    
    Dim i
    
    For i = Len(MyString) To 1 Step -1
        Select Case LCase(Mid(MyString, i, 1))
            Case "i", "e", "a", "o", "u"
                Let HasVowel = True
                Exit Function
            Case " ", "-"
                Let HasVowel = False
                Exit Function
        End Select
    Next i
        
End Function

Function Readjustments(MyString As String) As String

    'Maximize onsets to make word interiors look better to the eye, same for digraphs, deal with Shakespearian th'.
    
    Dim Onset As String, MyVowel As String, MyTarget As String
    
    'Onset clusters:
        Let Onset = "pr"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "tr"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "cr"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "br"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "dr"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "gr"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "pl"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "cl"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "bl"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "gl"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
    
    'Orthographic digraphs should likewise be adjusted:
        Let Onset = "th"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "ch"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
        Let Onset = "wh"
            Let MyString = Replace(MyString, Left(Onset, 1) + " " + Right(Onset, 1), " " + Left(Onset, 1) + Right(Onset, 1))
            
    'th' doesn't make a syllable
        Let MyVowel = "i"
            Let MyString = Replace(MyString, "th'WB " + MyVowel, "th'" + MyVowel)
        Let MyVowel = "e"
            Let MyString = Replace(MyString, "th'WB " + MyVowel, "th'" + MyVowel)
        Let MyVowel = "a"
            Let MyString = Replace(MyString, "th'WB " + MyVowel, "th'" + MyVowel)
        Let MyVowel = "o"
            Let MyString = Replace(MyString, "th'WB " + MyVowel, "th'" + MyVowel)
        Let MyVowel = "u"
            Let MyString = Replace(MyString, "th'WB " + MyVowel, "th'" + MyVowel)
    
    
    Let Readjustments = MyString
    
End Function


Function Syllabified(MyWord As String, MyLine As String) As String

    'Given a word, syllabify it.
    
        Dim i As Long
        Dim MySymbol As String
        Dim WordLength As Long
        Dim WordFinal As Boolean
        Dim WordBuffer As String
        Dim StressGuess As String
            
    'Check if the word is in the dictionary.  If so, you can just use the stored values, and avoid user checking
        For i = 1 To gNumberOfDictionaryEntries
            If MyWord = gStoredWords(i) Then
                Let Syllabified = gStoredSyllabifications(i)
                Let mStressBuffer = gStoredStressPatterns(i)
                Exit Function
            End If
        Next i
    
    'Go through the word in right-to-left order.
    
        Let mNewEntryMade = True
        Let WordLength = Len(MyWord)
        Let WordFinal = True
        
        For i = WordLength To 1 Step -1
            Let MySymbol = Mid(MyWord, i, 1)
            Select Case LCase(MySymbol)
                'e in final position is assumed not to make a syllable.  It does only in monosyllables,
                '   treated correctly in any event, and in a few rare words like Daphne
                    Case "e"
                        If WordFinal = True Then
                            'Even when word-final, e is not silent in words like "able".
                                If i >= 3 Then
                                    Select Case Mid(MyWord, i - 2, 2)
                                        Case "pl", "tl", "cl", "kl", "bl", "dl", "gl", "fl", "sl", "zl", "tr", "dr", "cr", "gr"
                                            'Not a silent e, treat it like any vowel.
                                              GoSub AvoidStrandingConsonants
                                              Let WordFinal = False
                                              GoTo SegmentRestartPoint  'Basically, Next i
                                    End Select
                                End If
                            Let WordBuffer = MySymbol + WordBuffer
                            Let WordFinal = False
                        Else
                            'e in nonfinal position is just another vowel.
                                GoSub AvoidStrandingConsonants
                                Let WordFinal = False
                        End If
                    Case "a", "i", "o", "u", "y"
                        'Vowels licence syllable breaks, but only if they won't strand consonants.
                            GoSub AvoidStrandingConsonants
                            Let WordFinal = False
                    Case "s"
                        's's are assumed to be plurals and do not cancel the assumption that e is silent.
                        '   Therefore, the flag WordFinal is not set to False here.
                            Let WordBuffer = MySymbol + WordBuffer
                        'However, double s's always indicate a sounded preceding s.
                            If i < Len(MyWord) Then
                                If Mid(MyWord, i + 1, 1) = "s" Then
                                    Let WordFinal = False
                                End If
                            End If
                    Case "'"
                        'Apostrophes and hyphens restore the word-finality status, so e.g. "love's" and "love-juice"
                        '   will have silent e's.
                            Let WordBuffer = MySymbol + WordBuffer
                            Let WordFinal = True
                    Case "-"
                        'Hyphens attract a syllable break no matter what.
                            Let WordBuffer = MySymbol + " " + WordBuffer
                    Case Else
                        '
                        Let WordBuffer = MySymbol + WordBuffer
                        Let WordFinal = False
            End Select
SegmentRestartPoint:
        Next i

    'Do the late readjustments (maximal onset, digraphs, th')
        Let WordBuffer = Readjustments(WordBuffer)
        
    'Send the result to the editing box for user approval.
        Let frmApproveWord.lblWord.Caption = MyWord
        Let frmApproveWord.lblLine.Caption = MyLine
        Let frmApproveWord.txtSyllables.Text = WordBuffer
        Let frmApproveWord.lblProgress = Trim(Str(mNumberOfLines)) + "/" + Trim(Str(mTotalNumberOfLines))
        'Make a guess about the stress contour, to save the user time.
            Let frmApproveWord.txtStressPattern.Text = frmApproveWord.GuessStress(WordBuffer)
        frmApproveWord.Show vbModal
        
        Let Syllabified = mSyllabificationBuffer
    
    Exit Function
    
AvoidStrandingConsonants:

    'The program puts a space one consonant before a vowel.  But we don't want this to happen if this
    '   will strand further consonants in the word.
    
        'Do this only when the vowel is not the first symbol in the line.
            If i > 1 Then
                Select Case (Mid(MyWord, i - 1, 1))
                    Case "b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z"
                        'HasVowel( ) tells you there is another vowel coming up in the word, so it's safe to
                        '   divide syllables.
                            If HasVowel(Left(MyWord, i - 1)) Then
                                'Add the syllable break, a space.
                                    Let WordBuffer = " " + (Mid(MyWord, i - 1, 1)) + MySymbol + WordBuffer
                                'Alter the index, since you've added two.
                                    Let i = i - 1
                            Else
                                'It's not safe to add a syllable break.
                                    Let WordBuffer = MySymbol + WordBuffer
                            End If
                    Case Else
                       'You need the C to syllabify.  This won't catch syllables in hiatus, but this is rare, especially
                       '    in poetry, where prosodic rules resolve them.
                            Let WordBuffer = MySymbol + WordBuffer
                End Select
            Else
                'No room for another syllable in the scan.
                    Let WordBuffer = MySymbol + WordBuffer
            End If
    
    Return


End Function

Function CountSyllables(MyString As String) As Long

    'In this system, the number of syllables is the number of blanks plus one.
        Let CountSyllables = s.NumberContainedIn(MyString, " ") + 1
    
End Function

Function Proclitic(MyString As String, MyStress As String) As Boolean

    'See if a word is a proclitic, for purposes of juncture.
        
        Dim Buffer As String
        
        'Only stressless or weak stressed words can be proclitics.
            Select Case MyStress
                Case "1", "12", "21"
                    'Do nothing
                Case Else
                    Let Proclitic = False
                    Exit Function
            End Select
        
        'Also, exclude the enclitics, i.e. the object pronounces.
            Select Case LCase(Replace(MyString, " ", ""))
                Case "me", "thee", "him", "us", "them"
                    Let Proclitic = False
                    Exit Function
            End Select
            
            Let Proclitic = True
    
End Function

Sub PostTheVacuousBox(MyLine As String)

    'Post the line on the vacuous box, so user can ok it.
        Let frmVacuousLine.Label1.Caption = MyLine
        Let frmVacuousLine.Label2.Caption = "(Line #" + Trim(Str(mNumberOfLines)) + "; no entries needed.)"
        Let frmVacuousLine.Label3.Caption = Trim(Str(mNumberOfLines)) + "/" + Trim(Str(mTotalNumberOfLines))

        frmVacuousLine.Show vbModal

End Sub
