/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.AbstractShortPriorityQueue;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortHeaps;
import java.util.NoSuchElementException;

public class ShortHeapPriorityQueue
extends AbstractShortPriorityQueue {
    protected short[] heap = ShortArrays.EMPTY_ARRAY;
    protected int size;
    protected ShortComparator c;

    public ShortHeapPriorityQueue(int capacity, ShortComparator c) {
        if (capacity > 0) {
            this.heap = new short[capacity];
        }
        this.c = c;
    }

    public ShortHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public ShortHeapPriorityQueue(ShortComparator c) {
        this(0, c);
    }

    public ShortHeapPriorityQueue() {
        this(0, null);
    }

    public ShortHeapPriorityQueue(short[] a, int size, ShortComparator c) {
        this(c);
        this.heap = a;
        this.size = size;
        ShortHeaps.makeHeap(a, size, c);
    }

    public ShortHeapPriorityQueue(short[] a, ShortComparator c) {
        this(a, a.length, c);
    }

    public ShortHeapPriorityQueue(short[] a, int size) {
        this(a, size, null);
    }

    public ShortHeapPriorityQueue(short[] a) {
        this(a, a.length);
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    public void enqueue(short x) {
        if (this.size == this.heap.length) {
            this.heap = ShortArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x;
        ShortHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    public short dequeueShort() {
        this.ensureNonEmpty();
        short result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            ShortHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    public short firstShort() {
        this.ensureNonEmpty();
        return this.heap[0];
    }

    public void changed() {
        this.ensureNonEmpty();
        ShortHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = ShortArrays.trim(this.heap, this.size);
    }

    public ShortComparator comparator() {
        return this.c;
    }
}

