/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.objects.AbstractObject2ShortMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2ShortOpenCustomHashMap<K>
extends AbstractObject2ShortMap<K>
implements Serializable,
Cloneable,
Hash {
    protected transient K[] key;
    protected transient short[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet<Map.Entry<K, Short>> entries;
    protected volatile transient ObjectSet<K> keys;
    protected volatile transient ShortCollection values;
    protected transient int growthFactor = 16;
    protected Hash.Strategy<K> strategy;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Object2ShortOpenCustomHashMap(int n, float f, Hash.Strategy<K> strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new short[this.free];
        this.state = new byte[this.free];
    }

    public Object2ShortOpenCustomHashMap(int n, Hash.Strategy<K> strategy) {
        this(n, 0.75f, strategy);
    }

    public Object2ShortOpenCustomHashMap(Hash.Strategy<K> strategy) {
        this(16, 0.75f, strategy);
    }

    public Object2ShortOpenCustomHashMap(Map<? extends K, ? extends Short> m, float f, Hash.Strategy<K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2ShortOpenCustomHashMap(Map<? extends K, ? extends Short> m, Hash.Strategy<K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2ShortOpenCustomHashMap(Object2ShortMap<K> m, float f, Hash.Strategy<K> strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2ShortOpenCustomHashMap(Object2ShortMap<K> m, Hash.Strategy<K> strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2ShortOpenCustomHashMap(K[] k, short[] v, float f, Hash.Strategy<K> strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2ShortOpenCustomHashMap(K[] k, short[] v, Hash.Strategy<K> strategy) {
        this(k, v, 0.75f, strategy);
    }

    public Hash.Strategy<K> strategy() {
        return this.strategy;
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(K k) {
        K[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] != -1 || key[h1] != HashCommon.REMOVED && h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] != -1 || key[h1] != HashCommon.REMOVED && h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (key[h1] == HashCommon.REMOVED || h != this.strategy.hashCode(key[h1]) || !this.strategy.equals(k, key[h1])) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || key[h1] != HashCommon.REMOVED && h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(K k) {
        K[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] == 0 || key[h1] != HashCommon.REMOVED && h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || key[h1] != HashCommon.REMOVED && h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    @Override
    public short put(K k, short v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            short oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    @Override
    public Short put(K ok, Short ov) {
        short v = ov;
        K k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            short oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    @Override
    public boolean containsValue(short v) {
        short[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public short getShort(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    @Override
    public short removeShort(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return this.value[i];
    }

    @Override
    public Short remove(Object ok) {
        int i = this.findKey(ok);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return this.value[i];
    }

    @Override
    public ObjectSet<Map.Entry<K, Short>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet<Map.Entry<K, Short>>(){

                @Override
                public ObjectIterator<Map.Entry<K, Short>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2ShortOpenCustomHashMap.this.findKey(e.getKey());
                    return i >= 0 && Object2ShortOpenCustomHashMap.this.value[i] == (Short)e.getValue();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2ShortOpenCustomHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Object2ShortOpenCustomHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                @Override
                public int size() {
                    return Object2ShortOpenCustomHashMap.this.count;
                }

                @Override
                public void clear() {
                    Object2ShortOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    @Override
    public ObjectSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ShortCollection values() {
        if (this.values == null) {
            this.values = new AbstractShortCollection(){

                public ShortIterator iterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Object2ShortOpenCustomHashMap.this.count;
                }

                public boolean contains(short v) {
                    return Object2ShortOpenCustomHashMap.this.containsValue(v);
                }

                public void clear() {
                    Object2ShortOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int newN = PRIMES[newP];
        K[] key = this.key;
        Object[] newKey = new Object[newN];
        short[] value = this.value;
        short[] newValue = new short[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            K k = key[i];
            short v = value[i];
            int k2i = this.strategy.hashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Object2ShortOpenCustomHashMap c;
        try {
            c = (Object2ShortOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (short[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            if (this != this.key[i]) {
                t = this.strategy.hashCode(this.key[i]);
            }
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        short[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeShort(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new short[n];
        short[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            Object k = s.readObject();
            short v = s.readShort();
            int k2i = this.strategy.hashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ShortIterator {
        public short nextShort() {
            return Object2ShortOpenCustomHashMap.this.value[this.nextEntry()];
        }

        public Short next() {
            return Object2ShortOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractObjectSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2ShortOpenCustomHashMap.this.count;
        }

        @Override
        public boolean contains(Object k) {
            return Object2ShortOpenCustomHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldCount = Object2ShortOpenCustomHashMap.this.count;
            Object2ShortOpenCustomHashMap.this.remove(k);
            return Object2ShortOpenCustomHashMap.this.count != oldCount;
        }

        @Override
        public void clear() {
            Object2ShortOpenCustomHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator<K> {
        @Override
        public K next() {
            return Object2ShortOpenCustomHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Map.Entry<K, Short>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, Short> next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Object2ShortOpenCustomHashMap.this.count;
            byte[] state = Object2ShortOpenCustomHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Object2ShortOpenCustomHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Object2ShortOpenCustomHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Object2ShortOpenCustomHashMap.this.state[this.last] = 1;
            Object2ShortOpenCustomHashMap.this.key[this.last] = HashCommon.REMOVED;
            --Object2ShortOpenCustomHashMap.this.count;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Object2ShortMap.Entry<K>,
    Map.Entry<K, Short> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Object2ShortOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public Short getValue() {
            return Object2ShortOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public short getShortValue() {
            return Object2ShortOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public short setValue(short v) {
            short oldValue = Object2ShortOpenCustomHashMap.this.value[this.index];
            Object2ShortOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Short setValue(Short v) {
            return this.setValue((short)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Object2ShortOpenCustomHashMap.this.strategy.equals(Object2ShortOpenCustomHashMap.this.key[this.index], e.getKey()) && Object2ShortOpenCustomHashMap.this.value[this.index] == (Short)e.getValue();
        }

        @Override
        public int hashCode() {
            return Object2ShortOpenCustomHashMap.this.strategy.hashCode(Object2ShortOpenCustomHashMap.this.key[this.index]) ^ Object2ShortOpenCustomHashMap.this.value[this.index];
        }

        public String toString() {
            return Object2ShortOpenCustomHashMap.this.key[this.index] + "->" + Object2ShortOpenCustomHashMap.this.value[this.index];
        }
    }
}

