/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2FloatMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLong2FloatMap
implements Long2FloatMap,
Serializable {
    protected float defRetValue;

    protected AbstractLong2FloatMap() {
    }

    @Override
    public void defaultReturnValue(float rv) {
        this.defRetValue = rv;
    }

    @Override
    public float defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public float put(long key, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float remove(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? Float.valueOf(this.get(k)) : null;
    }

    @Override
    public Float put(Long ok, Float ov) {
        long k = ok;
        float v = this.put(k, ov.floatValue());
        return this.containsKey(k) ? Float.valueOf(v) : null;
    }

    @Override
    public Float remove(Object ok) {
        long k = (Long)ok;
        float v = this.remove(k);
        return this.containsKey(k) ? Float.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue(((Float)ov).floatValue());
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    @Override
    public boolean containsValue(float v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(long k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Float> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Long, ? extends Float>> i = m.entrySet().iterator();
        if (m instanceof Long2FloatMap) {
            while (n-- != 0) {
                Long2FloatMap.Entry e = (Long2FloatMap.Entry)i.next();
                this.put(e.getLongKey(), e.getFloatValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Long, ? extends Float> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2FloatMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2FloatMap.this.size();
            }

            public void clear() {
                AbstractLong2FloatMap.this.clear();
            }

            public LongIterator iterator() {
                return new AbstractLongIterator(){
                    final ObjectIterator<Map.Entry<Long, Float>> i;
                    {
                        this.i = AbstractLong2FloatMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2FloatMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public FloatCollection values() {
        return new AbstractFloatCollection(){

            public boolean contains(float k) {
                return AbstractLong2FloatMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2FloatMap.this.size();
            }

            public void clear() {
                AbstractLong2FloatMap.this.clear();
            }

            public FloatIterator iterator() {
                return new AbstractFloatIterator(){
                    final ObjectIterator<Map.Entry<Long, Float>> i;
                    {
                        this.i = AbstractLong2FloatMap.this.entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Long2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Long, Float>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Long, Float>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2FloatMap.Entry e = (Long2FloatMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(e.getFloatValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2FloatMap.Entry {
        protected long key;
        protected float value;

        public BasicEntry(Long key, Float value) {
            this.key = key;
            this.value = value.floatValue();
        }

        public BasicEntry(long key, float value) {
            this.key = key;
            this.value = value;
        }

        public Long getKey() {
            return this.key;
        }

        public long getLongKey() {
            return this.key;
        }

        public Float getValue() {
            return Float.valueOf(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        public Float setValue(Float value) {
            return Float.valueOf(this.setValue(value.floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

