/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.eval.MolecularClockLikelihoodModel;
import pal.math.MinimiserMonitor;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalHints;
import pal.misc.NeoParameterized;
import pal.treesearch.ConstraintModel;
import pal.treesearch.GroupLeader;
import pal.treesearch.HeightInformationUser;

public class GeneralConstraintGroupManager {
    private final ConstraintModel.GroupManager relatedGroup_;
    private GroupLeader[] leaders_ = null;
    private final Function allOptimisationFunction_;
    private final Function primaryOptimisationFunction_;
    private final Function secondaryOptimisationFunction_;
    private final MolecularClockLikelihoodModel.External external_;

    public GeneralConstraintGroupManager(ConstraintModel.GroupManager relatedGroup) {
        this.relatedGroup_ = relatedGroup;
        this.allOptimisationFunction_ = GeneralConstraintGroupManager.createFunction(relatedGroup.getAllGroupRelatedParameterAccess());
        this.primaryOptimisationFunction_ = GeneralConstraintGroupManager.createFunction(relatedGroup.getPrimaryGroupRelatedParameterAccess());
        this.secondaryOptimisationFunction_ = GeneralConstraintGroupManager.createFunction(relatedGroup.getSecondaryGroupRelatedParameterAccess());
        System.out.println("All:" + this.allOptimisationFunction_);
        System.out.println("Primary:" + this.allOptimisationFunction_);
        System.out.println("Secondary:" + this.allOptimisationFunction_);
        System.out.println("All:" + this.allOptimisationFunction_.getNumArguments());
        System.out.println("Primary:" + this.allOptimisationFunction_.getNumArguments());
        System.out.println("Secondary:" + this.allOptimisationFunction_.getNumArguments());
        this.external_ = relatedGroup.createNewClockExternal();
    }

    public boolean isOptimisable() {
        return this.allOptimisationFunction_ != null && this.allOptimisationFunction_.getNumArguments() > 0;
    }

    public boolean isPrimaryOptimisable() {
        return this.primaryOptimisationFunction_ != null && this.primaryOptimisationFunction_.getNumArguments() > 0;
    }

    public boolean isSecondarOptimisable() {
        return this.secondaryOptimisationFunction_ != null && this.secondaryOptimisationFunction_.getNumArguments() > 0;
    }

    private static final Function createFunction(NeoParameterized parameterAccess) {
        if (parameterAccess != null) {
            return new Function(parameterAccess);
        }
        return null;
    }

    public MolecularClockLikelihoodModel.External obtainConstrainedExternalCalculator() {
        return this.external_;
    }

    public ConstraintModel.GroupManager getRelatedGroup() {
        return this.relatedGroup_;
    }

    private final void obtainLeafInformation(HeightInformationUser user) {
        int i = 0;
        while (i < this.leaders_.length) {
            this.leaders_[i].obtainLeafInformation(user);
            ++i;
        }
    }

    private final void postSetupNotify() {
        int i = 0;
        while (i < this.leaders_.length) {
            this.leaders_[i].postSetupNotify(this.relatedGroup_);
            ++i;
        }
    }

    public void setup() {
        HeightInformationUser user = new HeightInformationUser();
        this.obtainLeafInformation(user);
        this.relatedGroup_.initialiseParameters(user.getLabels(), user.getHeights());
        this.postSetupNotify();
    }

    public boolean isSameGroup(ConstraintModel.GroupManager queryGroup) {
        return queryGroup == this.relatedGroup_;
    }

    public void addGroupLeader(GroupLeader gl) {
        if (this.leaders_ == null) {
            this.leaders_ = new GroupLeader[]{gl};
        } else {
            GroupLeader[] newLeaders = new GroupLeader[this.leaders_.length + 1];
            System.arraycopy(this.leaders_, 0, newLeaders, 0, this.leaders_.length);
            newLeaders[this.leaders_.length] = gl;
            this.leaders_ = newLeaders;
        }
    }

    public final double optimiseAllGlobalClockConstraints(MultivariateMinimum minimiser, LikelihoodScoreAccess scoreAccess, int fxFracDigits, int xFracDigits, MinimiserMonitor rateMonitor) {
        return this.optimiseGlobalClockConstraintsImpl(this.allOptimisationFunction_, minimiser, scoreAccess, fxFracDigits, xFracDigits, rateMonitor);
    }

    public final double optimisePrimaryGlobalClockConstraints(MultivariateMinimum minimiser, LikelihoodScoreAccess scoreAccess, int fxFracDigits, int xFracDigits, MinimiserMonitor rateMonitor) {
        return this.optimiseGlobalClockConstraintsImpl(this.primaryOptimisationFunction_, minimiser, scoreAccess, fxFracDigits, xFracDigits, rateMonitor);
    }

    public final double optimiseSecondaryGlobalClockConstraints(MultivariateMinimum minimiser, LikelihoodScoreAccess scoreAccess, int fxFracDigits, int xFracDigits, MinimiserMonitor rateMonitor) {
        return this.optimiseGlobalClockConstraintsImpl(this.primaryOptimisationFunction_, minimiser, scoreAccess, fxFracDigits, xFracDigits, rateMonitor);
    }

    private final double optimiseGlobalClockConstraintsImpl(Function f, MultivariateMinimum minimiser, LikelihoodScoreAccess scoreAccess, int fxFracDigits, int xFracDigits, MinimiserMonitor rateMonitor) {
        if (f != null && f.getNumArguments() > 0) {
            f.setup(scoreAccess);
            double[] arguments = f.getArgumentStore();
            double result = -minimiser.findMinimum(f, arguments, fxFracDigits, xFracDigits, rateMonitor);
            f.updateCurrent(arguments);
            return result;
        }
        return 1.0;
    }

    public static interface LikelihoodScoreAccess {
        public double calculateLikelihoodScore();
    }

    public static final class Store {
        private GeneralConstraintGroupManager[] constraintGroupManagers_ = new GeneralConstraintGroupManager[0];

        public final GeneralConstraintGroupManager[] getConstraintGroupManagers() {
            return this.constraintGroupManagers_;
        }

        public final GeneralConstraintGroupManager getConstraintGroupManager(String[] leafLabelSet, ConstraintModel constraints) {
            return this.getConstraintGroupManager(constraints.getGlobalClockConstraintGrouping(leafLabelSet));
        }

        public final GeneralConstraintGroupManager getConstraintGroupManager(ConstraintModel.GroupManager grouping) {
            if (this.constraintGroupManagers_.length == 0) {
                GeneralConstraintGroupManager groupManager = new GeneralConstraintGroupManager(grouping);
                this.constraintGroupManagers_ = new GeneralConstraintGroupManager[]{groupManager};
                return groupManager;
            }
            int i = 0;
            while (i < this.constraintGroupManagers_.length) {
                if (this.constraintGroupManagers_[i].isSameGroup(grouping)) {
                    return this.constraintGroupManagers_[i];
                }
                ++i;
            }
            GeneralConstraintGroupManager groupManager = new GeneralConstraintGroupManager(grouping);
            GeneralConstraintGroupManager[] newManagers = new GeneralConstraintGroupManager[this.constraintGroupManagers_.length + 1];
            System.arraycopy(this.constraintGroupManagers_, 0, newManagers, 0, this.constraintGroupManagers_.length);
            newManagers[this.constraintGroupManagers_.length] = groupManager;
            this.constraintGroupManagers_ = newManagers;
            return groupManager;
        }

        public void setupConstraintGroupManagers() {
            int i = 0;
            while (i < this.constraintGroupManagers_.length) {
                this.constraintGroupManagers_[i].setup();
                ++i;
            }
        }
    }

    private static final class Function
    implements MultivariateFunction {
        private LikelihoodScoreAccess scoreAccess_;
        private final NeoParameterized parameterAccess_;
        private final double[] argumentStore_;

        public Function(NeoParameterized parameterAccess) {
            this.parameterAccess_ = parameterAccess;
            this.argumentStore_ = new double[parameterAccess.getNumberOfParameters()];
        }

        public double[] getArgumentStore() {
            this.parameterAccess_.getParameters(this.argumentStore_, 0);
            return this.argumentStore_;
        }

        public void updateCurrent(double[] arguments) {
            this.parameterAccess_.setParameters(arguments, 0);
        }

        public void setup(LikelihoodScoreAccess scoreAccess) {
            this.scoreAccess_ = scoreAccess;
        }

        public double evaluate(double[] argument) {
            if (this.scoreAccess_ == null) {
                throw new RuntimeException("Assertion error : rootAccess is null, need to call setup at some point!");
            }
            this.parameterAccess_.setParameters(argument, 0);
            double result = -this.scoreAccess_.calculateLikelihoodScore();
            return result;
        }

        public int getNumArguments() {
            return this.parameterAccess_.getNumberOfParameters();
        }

        public double getLowerBound(int n) {
            return this.parameterAccess_.getLowerLimit(n);
        }

        public double getUpperBound(int n) {
            return this.parameterAccess_.getUpperLimit(n);
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }
    }
}

