/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.treesearch.FreeBranch;
import pal.treesearch.FreeNode;
import pal.treesearch.GeneralConstraintGroupManager;
import pal.treesearch.GeneralConstructionTool;

public class FreeInternalNode
implements FreeNode {
    private final FreeBranch[] connections_ = new FreeBranch[3];
    private final FreeBranch[] markConnections_ = new FreeBranch[3];
    private final PatternInfo[] patternInfos_;
    private final boolean[] patternsValid_;
    private static final int[] LEFT_LOOKUP = new int[]{1, 0, 0};
    private static final int[] RIGHT_LOOKUP = new int[]{2, 2, 1};
    private final UnconstrainedLikelihoodModel.Internal calculator_;
    private boolean topologyChangedSinceLastFlat_ = true;
    private boolean topologyChangedSincleLastExtended_ = true;

    public FreeInternalNode(Node i, FreeBranch parentFreeBranch, GeneralConstructionTool tool, GeneralConstraintGroupManager.Store store) {
        this.connections_[0] = parentFreeBranch;
        this.connections_[1] = new FreeBranch(i.getChild(0), (FreeNode)this, tool, store);
        this.connections_[2] = new FreeBranch(i.getChild(1), (FreeNode)this, tool, store);
        this.patternsValid_ = new boolean[]{false, false, false};
        this.calculator_ = tool.allocateNewFreeInternalCalculator();
        int numberOfSites = tool.getNumberOfSites();
        this.patternInfos_ = new PatternInfo[]{new PatternInfo(numberOfSites, true), new PatternInfo(numberOfSites, true), new PatternInfo(numberOfSites, true)};
    }

    public void mark() {
        this.markConnections_[0] = this.connections_[0];
        this.markConnections_[1] = this.connections_[1];
        this.markConnections_[2] = this.connections_[2];
    }

    public void undoToMark() {
        this.connections_[0] = this.markConnections_[0];
        this.connections_[1] = this.markConnections_[1];
        this.connections_[2] = this.markConnections_[2];
        this.topologyChanged();
    }

    private final void topologyChanged() {
        this.topologyChangedSinceLastFlat_ = true;
        this.topologyChangedSincleLastExtended_ = true;
    }

    public boolean hasDirectConnection(FreeBranch c) {
        int i = 0;
        while (i < this.connections_.length) {
            if (this.connections_[i] == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasConnection(FreeBranch c, FreeBranch caller) {
        int i = 0;
        while (i < this.connections_.length) {
            if (this.connections_[i] == c || this.connections_[i] != caller && this.connections_[i].hasConnection(c, this)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void testLikelihood(FreeBranch caller, GeneralConstructionTool tool) {
        int i = 0;
        while (i < this.connections_.length) {
            if (this.connections_[i] != caller) {
                this.connections_[i].testLikelihood(this, tool);
            }
            ++i;
        }
    }

    public void setConnectingBranches(FreeBranch[] store, int number) {
        if (number != 3) {
            throw new IllegalArgumentException("Must be three connections not:" + number);
        }
        System.arraycopy(store, 0, this.connections_, 0, 3);
        this.topologyChanged();
    }

    public FreeBranch getLeftBranch(FreeBranch caller) {
        return this.connections_[LEFT_LOOKUP[this.getCallerIndex(caller)]];
    }

    public FreeBranch getRightBranch(FreeBranch caller) {
        return this.connections_[RIGHT_LOOKUP[this.getCallerIndex(caller)]];
    }

    public FreeBranch extract(FreeBranch caller) {
        int callerIndex = this.getCallerIndex(caller);
        FreeBranch left = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeBranch right = this.connections_[RIGHT_LOOKUP[callerIndex]];
        FreeNode rightNode = right.getOther(this);
        left.swapNode(this, rightNode);
        rightNode.swapConnection(right, left);
        this.topologyChanged();
        return right;
    }

    public void swapConnection(FreeBranch original, FreeNode nodeToReplace, FreeBranch newConnection) {
        int index = this.getCallerIndex(original);
        this.connections_[index] = newConnection;
        newConnection.swapNode(nodeToReplace, this);
        original.swapNode(this, nodeToReplace);
        nodeToReplace.swapConnection(newConnection, original);
        this.topologyChanged();
    }

    public void swapConnection(FreeBranch original, FreeBranch newConnection) {
        int index = this.getCallerIndex(original);
        this.connections_[index] = newConnection;
        this.topologyChanged();
    }

    public PatternInfo getPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        return this.getPatternInfo(tool, this.getCallerIndex(caller));
    }

    private final PatternInfo getPatternInfo(GeneralConstructionTool tool, int callerIndex) {
        if (!this.patternsValid_[callerIndex]) {
            FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
            FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
            FreeNode left = leftConnection.getOther(this);
            FreeNode right = rightConnection.getOther(this);
            PatternInfo leftPattern = left.getPatternInfo(tool, leftConnection);
            PatternInfo rightPattern = right.getPatternInfo(tool, rightConnection);
            tool.build(this.patternInfos_[callerIndex], leftPattern, rightPattern);
            this.patternsValid_[callerIndex] = true;
        }
        return this.patternInfos_[callerIndex];
    }

    public Node buildPALNodeES(double branchLength, FreeBranch caller) {
        int callerIndex = this.getCallerIndex(caller);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        Node[] children = new Node[]{leftConnection.buildPALNodeES(this), rightConnection.buildPALNodeES(this)};
        return NodeFactory.createNodeBranchLength(branchLength, children);
    }

    public Node buildPALNodeBase(double branchLength, FreeBranch caller) {
        int callerIndex = this.getCallerIndex(caller);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        Node[] children = new Node[]{leftConnection.buildPALNodeBase(this), rightConnection.buildPALNodeBase(this)};
        return NodeFactory.createNodeBranchLength(branchLength, children);
    }

    public String toString(FreeBranch caller) {
        StringBuffer sb = new StringBuffer();
        boolean printed = false;
        int i = 0;
        while (i < this.connections_.length) {
            if (this.connections_[i] != caller) {
                if (printed) {
                    sb.append(", ");
                }
                printed = true;
                sb.append(this.connections_[i].toString(this));
            }
            ++i;
        }
        return sb.toString();
    }

    public void getAllComponents(ArrayList store, Class componentType) {
        this.getAllComponents(store, componentType, null);
    }

    public void getAllComponents(ArrayList store, Class componentType, FreeBranch caller) {
        if (componentType.isAssignableFrom(this.getClass())) {
            store.add(this);
        }
        int i = 0;
        while (i < this.connections_.length) {
            if (this.connections_[i] != caller) {
                this.connections_[i].getAllComponents(store, componentType, this);
            }
            ++i;
        }
    }

    private final int getCallerIndex(FreeBranch caller) {
        if (caller == null) {
            throw new IllegalArgumentException("getCallerIndex() called on null object");
        }
        if (caller == this.connections_[0]) {
            return 0;
        }
        if (caller == this.connections_[1]) {
            return 1;
        }
        if (caller == this.connections_[2]) {
            return 2;
        }
        throw new IllegalArgumentException("Unknown caller");
    }

    public ConditionalProbabilityStore getLeftExtendedConditionalProbabilities(FreeBranch callingConnection, UnconstrainedLikelihoodModel.External external, ConditionalProbabilityStore resultStore, GeneralConstructionTool tool) {
        int callerIndex = this.getCallerIndex(callingConnection);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        return leftConnection.getExtendedConditionalProbabilities(this, external, resultStore, tool);
    }

    public ConditionalProbabilityStore getRightExtendedConditionalProbabilities(FreeBranch callingConnection, UnconstrainedLikelihoodModel.External external, ConditionalProbabilityStore resultStore, GeneralConstructionTool tool) {
        int callerIndex = this.getCallerIndex(callingConnection);
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        return rightConnection.getExtendedConditionalProbabilities(this, external, resultStore, tool);
    }

    public PatternInfo getLeftPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        int callerIndex = this.getCallerIndex(caller);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeNode other = leftConnection.getOther(this);
        return other.getPatternInfo(tool, leftConnection);
    }

    public PatternInfo getRightPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        int callerIndex = this.getCallerIndex(caller);
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        FreeNode other = rightConnection.getOther(this);
        return other.getPatternInfo(tool, rightConnection);
    }

    public ConditionalProbabilityStore getFlatConditionalProbabilities(FreeBranch callerConnection, UnconstrainedLikelihoodModel.External externalCalculator, ConditionalProbabilityStore resultStore, GeneralConstructionTool tool) {
        int callerIndex = this.getCallerIndex(callerConnection);
        PatternInfo pi = this.getPatternInfo(tool, callerIndex);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        externalCalculator.calculateFlat(pi, leftConnection.getExtendedConditionalProbabilities(this, tool), rightConnection.getExtendedConditionalProbabilities(this, tool), resultStore);
        return resultStore;
    }

    public ConditionalProbabilityStore getFlatConditionalProbabilities(FreeBranch callerConnection, GeneralConstructionTool tool) {
        int callerIndex = this.getCallerIndex(callerConnection);
        PatternInfo pi = this.getPatternInfo(tool, callerIndex);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        boolean childrenChanged = this.topologyChangedSinceLastFlat_;
        this.topologyChangedSinceLastFlat_ = false;
        return this.calculator_.calculateFlat(pi, leftConnection.getExtendedConditionalProbabilities(this, tool), rightConnection.getExtendedConditionalProbabilities(this, tool));
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, FreeBranch callerConnection, UnconstrainedLikelihoodModel.External externalCalculator, ConditionalProbabilityStore resultStore, GeneralConstructionTool tool) {
        int callerIndex = this.getCallerIndex(callerConnection);
        PatternInfo pi = this.getPatternInfo(tool, callerIndex);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        externalCalculator.calculateExtended(distance, pi, leftConnection.getExtendedConditionalProbabilities(this, tool), rightConnection.getExtendedConditionalProbabilities(this, tool), resultStore);
        return resultStore;
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, FreeBranch callerConnection, GeneralConstructionTool tool) {
        int callerIndex = this.getCallerIndex(callerConnection);
        PatternInfo pi = this.getPatternInfo(tool, callerIndex);
        FreeBranch leftConnection = this.connections_[LEFT_LOOKUP[callerIndex]];
        FreeBranch rightConnection = this.connections_[RIGHT_LOOKUP[callerIndex]];
        boolean childrenChanged = this.topologyChangedSincleLastExtended_;
        this.topologyChangedSincleLastExtended_ = false;
        return this.calculator_.calculateExtended(distance, pi, leftConnection.getExtendedConditionalProbabilities(this, tool), rightConnection.getExtendedConditionalProbabilities(this, tool));
    }
}

