/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.alignment.Alignment;
import pal.substmodel.SubstitutionModel;
import pal.tree.Node;
import pal.treesearch.UnrootedMLSearcher;

public interface BranchAccess {
    public void setAnnotation(Object var1);

    public Object getAnnotation();

    public boolean isLeafBranch(String var1);

    public UnrootedMLSearcher attach(Node var1, Alignment var2);

    public UnrootedMLSearcher attach(String var1, Alignment var2);

    public UnrootedMLSearcher attach(Node var1, Alignment var2, SubstitutionModel var3);

    public UnrootedMLSearcher attach(String var1, Alignment var2, SubstitutionModel var3);

    public String[] getLeftLeafNames();

    public String[] getRightLeafNames();

    public int[] getSplitInformation(String[] var1);

    public static final class Utils {
        private static final boolean isContained(String[] set, String query) {
            int i = 0;
            while (i < set.length) {
                if (query.equals(set[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public static final boolean isContained(String[] larger, String[] smaller) {
            int i = 0;
            while (i < smaller.length) {
                if (!Utils.isContained(larger, smaller[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public static final boolean isIntersection(String[] one, String[] two) {
            int i = 0;
            while (i < one.length) {
                if (Utils.isContained(two, one[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public static final boolean isMatching(BranchAccess branch, String[] queryLeftLeaves, String[] queryRightLeaves) {
            String[] branchRight = branch.getRightLeafNames();
            if (Utils.isIntersection(queryLeftLeaves, branchRight)) {
                return false;
            }
            String[] branchLeft = branch.getLeftLeafNames();
            if (Utils.isIntersection(queryRightLeaves, branch.getLeftLeafNames())) {
                return false;
            }
            return Utils.isIntersection(branchLeft, queryLeftLeaves) && Utils.isIntersection(branchRight, queryRightLeaves);
        }

        public static final BranchAccess getMatching(BranchAccess[] base, BranchAccess query) {
            return Utils.getMatching(base, query.getLeftLeafNames(), query.getRightLeafNames());
        }

        public static final BranchAccess getMatching(BranchAccess[] base, String[] queryLeftLeaves, String[] queryRightLeaves) {
            int i = 0;
            while (i < base.length) {
                if (Utils.isMatching(base[i], queryLeftLeaves, queryRightLeaves)) {
                    return base[i];
                }
                ++i;
            }
            return null;
        }

        public static final void transferAnnotation(BranchAccess source, BranchAccess[] desination) {
            Utils.transferAnnotation(source.getLeftLeafNames(), source.getRightLeafNames(), source.getAnnotation(), desination);
        }

        public static final void transferAnnotation(String[] sourceLeftLeaves, String[] sourceRightLeaves, Object annotation, BranchAccess[] desination) {
            int i = 0;
            while (i < desination.length) {
                if (Utils.isMatching(desination[i], sourceLeftLeaves, sourceRightLeaves)) {
                    desination[i].setAnnotation(annotation);
                }
                ++i;
            }
        }

        public static final void transferAnnotation(BranchAccess[] source, BranchAccess[] destination) {
            int i = 0;
            while (i < source.length) {
                Utils.transferAnnotation(source[i], destination);
                ++i;
            }
        }
    }
}

