/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.treesearch.ConstraintModel;
import pal.treesearch.GeneralConstructionTool;
import pal.treesearch.SearcherUtils;

public abstract class AbstractLeafNode {
    private final String id_;
    private final int[] patternStateMatchup_;
    private final int uniqueCount_;
    private final int[] sequence_;
    private final PatternInfo pattern_;

    public AbstractLeafNode(String id, GeneralConstructionTool tool) {
        this.id_ = id;
        this.sequence_ = tool.getSequence(id);
        int numberOfStates = tool.getNumberOfStates();
        int numberOfSites = tool.getNumberOfSites();
        this.patternStateMatchup_ = new int[numberOfStates + 1];
        int[] sitePatternMatchup = new int[numberOfSites];
        this.uniqueCount_ = SearcherUtils.createMatchups(numberOfSites, numberOfStates, sitePatternMatchup, this.patternStateMatchup_, this.sequence_);
        this.pattern_ = new PatternInfo(sitePatternMatchup, this.uniqueCount_);
    }

    protected final UnconstrainedLikelihoodModel.Leaf createNewFreeLeafCalculator(GeneralConstructionTool tool) {
        return tool.createNewFreeLeafCalculator(this.patternStateMatchup_, this.uniqueCount_);
    }

    protected final MolecularClockLikelihoodModel.Leaf createNewConstrainedLeafCalculator(ConstraintModel.GroupManager parentGroup) {
        return parentGroup.createNewClockLeaf(this.pattern_, this.patternStateMatchup_);
    }

    public final String getLabel() {
        return this.id_;
    }

    public final PatternInfo getPatternInfo() {
        return this.pattern_;
    }

    public final int getNumberOfPatterns() {
        return this.pattern_.getNumberOfPatterns();
    }
}

