/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.util.ArrayList;
import pal.misc.Identifier;
import pal.misc.Utils;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.NodeUtils;
import pal.tree.RootedTreeInterface;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.tree.TreeIterator;
import pal.tree.UnrootedTreeInterface;
import pal.util.AlgorithmCallback;

public class TreeManipulator
implements UnrootedTreeInterface.Instructee,
RootedTreeInterface.Instructee {
    public static final int MIMIC_CONSTRUCTION = 100;
    public static final int EXPAND_CONSTRUCTION = 200;
    public static final int REDUCE_CONSTRUCTION = 300;
    private Connection unrootedTree_;
    private final int units_;
    private final double firstChildNodeLength_;
    private final boolean inputTreeUnrooted_;
    private static final ConnectionMethodCaller ASSERT_PATH_INFO_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.assertPathInfo(callingNode);
        }
    };
    private static final ConnectionMethodCaller CLEAR_PATH_INFO_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.clearPathInfo(callingNode);
        }
    };
    private static final ConnectionMethodCaller UPDATE_PATH_INFO_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.updatePathInfo(callingNode);
        }
    };
    private static final ConnectionMethodCaller GET_NUMBER_OF_CONNECTIONS_CALLER = new ConnectionMethodCaller(){

        public void callOn(Connection c, UndirectedNode callingNode) {
            c.getNumberOfConnections(callingNode);
        }
    };

    public TreeManipulator(Tree base, int constructionMode) {
        this(base.getRoot(), base.getUnits(), constructionMode);
    }

    public TreeManipulator(Tree base) {
        this(base.getRoot(), base.getUnits());
    }

    public TreeManipulator(Node base) {
        this(base, 6);
    }

    public TreeManipulator(Node base, int units) {
        this(base, units, 100);
    }

    public TreeManipulator(Node base, int units, int constructionMode) {
        PALNodeWrapper simpleBase = new PALNodeWrapper(base);
        this.unrootedTree_ = TreeManipulator.construct(simpleBase, constructionMode);
        this.inputTreeUnrooted_ = base.getChildCount() > 2;
        this.firstChildNodeLength_ = base.getChild(0).getBranchLength();
        this.units_ = units;
        this.unrootedTree_.clearPathInfo();
    }

    public TreeManipulator(UnrootedTreeInterface.Instructee base, int units, int constructionMode) {
        UnrootedInterfaceImpl ui = new UnrootedInterfaceImpl();
        base.instruct(ui);
        SimpleBranch root = ui.getSimpleRootBranch();
        this.unrootedTree_ = new Connection(root, constructionMode);
        this.firstChildNodeLength_ = root.getBranchLength() / 2.0;
        this.units_ = units;
        this.unrootedTree_.clearPathInfo();
        this.inputTreeUnrooted_ = true;
    }

    public TreeManipulator(RootedTreeInterface.Instructee base, int units, int constructionMode) {
        RootedInterfaceImpl ri = new RootedInterfaceImpl();
        base.instruct(ri);
        SimpleNode root = ri.getSimpleRoot();
        this.unrootedTree_ = TreeManipulator.construct(root, constructionMode);
        this.inputTreeUnrooted_ = false;
        this.firstChildNodeLength_ = root.getChild(0).getParentBranchLength();
        this.units_ = units;
        this.unrootedTree_.clearPathInfo();
    }

    private TreeManipulator(TreeManipulator base, Connection baseSubTreeConnector, Node subTree, int constructionMode) {
        PALNodeWrapper simpleSubTree = new PALNodeWrapper(subTree);
        this.unrootedTree_ = base.unrootedTree_.getAttached(baseSubTreeConnector, simpleSubTree, constructionMode);
        this.inputTreeUnrooted_ = base.unrootedTree_ == baseSubTreeConnector ? true : base.inputTreeUnrooted_;
        this.firstChildNodeLength_ = base.firstChildNodeLength_;
        this.units_ = base.units_;
        this.unrootedTree_.clearPathInfo();
    }

    private static final Connection construct(SimpleNode n, int constructionMode) {
        if (n.isLeaf()) {
            throw new IllegalArgumentException("Tree must contain more than a single OTU!");
        }
        if (n.getNumberOfChildren() == 2) {
            return new Connection(n.getChild(0), n.getChild(1), constructionMode);
        }
        UndirectedNode un = new UndirectedNode(n, constructionMode);
        return un.getPeerParentConnection();
    }

    public Node getMidPointRooted() {
        Node n = this.unrootedTree_.getMidPointRooted();
        NodeUtils.lengths2Heights(n);
        return n;
    }

    public Node getDefaultRoot() {
        Node n = this.unrootedTree_.getRootedAround(this.firstChildNodeLength_);
        NodeUtils.lengths2Heights(n);
        return n;
    }

    private boolean isFormsFormsExactClade(String[] possibleCladeMembers) {
        return this.unrootedTree_.isFormsExactClade(possibleCladeMembers);
    }

    public Node getAsInputRooting() {
        if (this.inputTreeUnrooted_) {
            return this.getUnrooted();
        }
        return this.getDefaultRoot();
    }

    public Tree getAsInputRootingTree() {
        return TreeManipulator.constructTree(this.getAsInputRooting(), this.units_);
    }

    public Tree getDefaultRootTree() {
        return TreeManipulator.constructTree(this.getDefaultRoot(), this.units_);
    }

    public Tree getMidPointRootedTree() {
        return TreeManipulator.constructTree(this.getMidPointRooted(), this.units_);
    }

    public Node getUnrooted() {
        Node n = this.unrootedTree_.getUnrooted();
        NodeUtils.lengths2Heights(n);
        return n;
    }

    public Tree getUnrootedTree() {
        return TreeManipulator.constructTree(this.getUnrooted(), this.units_);
    }

    private Connection[] getAllConnections() {
        return this.unrootedTree_.getAllConnections();
    }

    public Node getRootedBy(String[] outgroupNames) {
        Node n = this.unrootedTree_.getRootedAroundMRCA(outgroupNames);
        NodeUtils.lengths2Heights(n);
        return n;
    }

    public void instructRootedBy(RootedTreeInterface rootedInterface, String[] outgroupNames) {
        this.unrootedTree_.instructRootedAroundMRCA(rootedInterface, outgroupNames);
    }

    public Node getRootedBy(String[] outgroupNames, double ingroupBranchLength) {
        return this.unrootedTree_.getRootedAroundMRCA(outgroupNames, ingroupBranchLength);
    }

    public Node[] getAllRootedBy(String[] outgroupNames) {
        return this.unrootedTree_.getAllRootedAroundMRCA(outgroupNames);
    }

    public Tree getTreeRootedBy(String[] outgroupNames) {
        return TreeManipulator.constructTree(this.getRootedBy(outgroupNames), this.units_);
    }

    public Tree getTreeRootedBy(String[] outgroupNames, double ingroupBranchLength) {
        return TreeManipulator.constructTree(this.getRootedBy(outgroupNames, ingroupBranchLength), this.units_);
    }

    public Tree[] getAllTreesRootedBy(String[] outgroupNames) {
        Node[] nodes = this.getAllRootedBy(outgroupNames);
        Tree[] trees = new Tree[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            trees[i] = TreeManipulator.constructTree(nodes[i], this.units_);
            ++i;
        }
        return trees;
    }

    public TreeIterator getEveryRootIterator() {
        return new RootIterator(this.getAllConnections(), this.units_);
    }

    public void instruct(UnrootedTreeInterface treeInterface) {
        UnrootedTreeInterface.BaseBranch base = treeInterface.createBase();
        this.unrootedTree_.instruct(base);
    }

    public void instruct(RootedTreeInterface treeInterface) {
        RootedTreeInterface.RNode base = treeInterface.createRoot();
        this.unrootedTree_.instruct(base, this.firstChildNodeLength_);
    }

    public BranchAccess[] getBranchAccess() {
        Connection[] connections = this.getAllConnections();
        BranchAccess[] results = new BranchAccess[connections.length];
        int i = 0;
        while (i < connections.length) {
            results[i] = new BranchAccessImpl(this, connections[i], this.units_);
            ++i;
        }
        return results;
    }

    public Tree[] getEveryRoot() {
        Connection[] connections = this.getAllConnections();
        Tree[] results = new Tree[connections.length];
        int i = 0;
        while (i < connections.length) {
            results[i] = TreeManipulator.constructTree(connections[i].getRootedAround(), this.units_);
            ++i;
        }
        return results;
    }

    public Node getRootedAbove(Node base) {
        UndirectedNode match = this.unrootedTree_.getRelatedNode(base);
        if (match == null) {
            throw new IllegalArgumentException("Parameter node not found in original tree");
        }
        Node n = match.getPeerParentConnection().getRootedAround();
        NodeUtils.lengths2Heights(n);
        return n;
    }

    public Tree getTreeRootedAbove(Node n) {
        return TreeManipulator.constructTree(this.getRootedAbove(n), this.units_);
    }

    public static final Tree getUnrooted(Tree base) {
        return new TreeManipulator(base).getUnrootedTree();
    }

    public static final Tree getMidpointRooted(Tree base) {
        return new TreeManipulator(base).getMidPointRootedTree();
    }

    public static final Tree[] getEveryRoot(Tree base) {
        return new TreeManipulator(base).getEveryRoot();
    }

    public static final TreeIterator getEveryRootIterator(Tree base) {
        return new TreeManipulator(base).getEveryRootIterator();
    }

    public static final Tree getRootedBy(Tree base, String[] outgroupNames) {
        return new TreeManipulator(base).getTreeRootedBy(outgroupNames);
    }

    public static final Tree getRootedBy(Tree base, String[] outgroupNames, double ingroupBranchLength) {
        return new TreeManipulator(base).getTreeRootedBy(outgroupNames, ingroupBranchLength);
    }

    public static final Tree[] getAllRootingsBy(Tree base, String[] outgroupNames) {
        return new TreeManipulator(base).getAllTreesRootedBy(outgroupNames);
    }

    private static final Tree constructTree(Node n, int units) {
        SimpleTree st = new SimpleTree(n);
        st.setUnits(units);
        return st;
    }

    private static final boolean contains(String[] names, String name) {
        int i = 0;
        while (i < names.length) {
            if (name.equals(names[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final class PALNodeWrapper
    implements SimpleNode {
        private final Node peer_;
        private final PALNodeWrapper[] children_;
        private final PALBranchWrapper parentBranch_;

        public PALNodeWrapper(Node peer) {
            this(peer, null);
        }

        public PALNodeWrapper(Node peer, PALNodeWrapper parent) {
            this.peer_ = peer;
            this.parentBranch_ = parent == null ? null : new PALBranchWrapper(parent, this, peer.getBranchLength());
            this.children_ = new PALNodeWrapper[peer.getChildCount()];
            int i = 0;
            while (i < this.children_.length) {
                this.children_[i] = new PALNodeWrapper(peer.getChild(i), this);
                ++i;
            }
        }

        public Object getAnnotation() {
            return null;
        }

        public String getLabel() {
            Identifier id = this.peer_.getIdentifier();
            if (id != null) {
                return id.getName();
            }
            return null;
        }

        public boolean isLeaf() {
            return this.children_.length == 0;
        }

        public int getNumberOfChildren() {
            return this.children_.length;
        }

        public SimpleNode getChild(int child) {
            return this.children_[child];
        }

        public SimpleBranch getParentBranch() {
            return this.parentBranch_;
        }

        public Node getPALPeer() {
            return this.peer_;
        }

        public double getParentBranchLength() {
            return this.parentBranch_ == null ? 0.0 : this.parentBranch_.getBranchLength();
        }
    }

    public static final class PALBranchWrapper
    implements SimpleBranch {
        private final PALNodeWrapper parent_;
        private final PALNodeWrapper child_;
        private final double branchLength_;

        public PALBranchWrapper(PALNodeWrapper parent, PALNodeWrapper child, double branchLength) {
            this.parent_ = parent;
            this.child_ = child;
            this.branchLength_ = branchLength;
        }

        public SimpleNode getParentNode() {
            return this.parent_;
        }

        public SimpleNode getChildNode() {
            return this.child_;
        }

        public final double getBranchLength() {
            return this.branchLength_;
        }

        public final Object getAnnotation() {
            return null;
        }
    }

    private static final class InstructableBranch
    implements SimpleBranch,
    RootedTreeInterface.RBranch,
    UnrootedTreeInterface.UBranch,
    UnrootedTreeInterface.BaseBranch {
        private final InstructableNode parent_;
        private final InstructableNode child_;
        private double length_;
        private Object annotation_;

        public InstructableBranch() {
            this.parent_ = new InstructableNode(this);
            this.child_ = new InstructableNode(this);
        }

        public SimpleNode getParentNode() {
            return this.parent_;
        }

        public SimpleNode getChildNode() {
            return this.child_;
        }

        public InstructableBranch(InstructableNode parent, InstructableNode child) {
            this.parent_ = parent;
            this.child_ = child;
        }

        public double getBranchLength() {
            return this.length_;
        }

        public Object getAnnotation() {
            return this.annotation_;
        }

        public void setLength(double length) {
            this.length_ = length;
        }

        public void setAnnotation(Object annotation) {
            this.annotation_ = annotation;
        }

        public RootedTreeInterface.RNode getMoreRecentNode() {
            return this.child_;
        }

        public RootedTreeInterface.RNode getLessRecentNode() {
            return this.parent_;
        }

        public UnrootedTreeInterface.UNode getCloserNode() {
            return this.parent_;
        }

        public UnrootedTreeInterface.UNode getFartherNode() {
            return this.child_;
        }

        public UnrootedTreeInterface.UNode getLeftNode() {
            return this.parent_;
        }

        public UnrootedTreeInterface.UNode getRightNode() {
            return this.child_;
        }
    }

    private static final class InstructableNode
    implements SimpleNode,
    RootedTreeInterface.RNode,
    UnrootedTreeInterface.UNode {
        private final InstructableBranch parent_;
        private String label_;
        private ArrayList children_ = null;
        public Object annotation_;

        public InstructableNode() {
            this((InstructableBranch)null);
        }

        public String getLabel() {
            return this.label_;
        }

        public InstructableNode(InstructableNode parent) {
            this.parent_ = new InstructableBranch(parent, this);
        }

        public InstructableNode(InstructableBranch parent) {
            this.parent_ = parent;
        }

        public void setAnnotation(Object annotation) {
            this.annotation_ = annotation;
        }

        public Object getAnnotation() {
            return this.annotation_;
        }

        public boolean isLeaf() {
            return this.children_ == null || this.children_.size() == 0;
        }

        public int getNumberOfChildren() {
            return this.children_ == null ? 0 : this.children_.size();
        }

        public SimpleNode getChild(int child) {
            return (SimpleNode)this.children_.get(child);
        }

        public SimpleBranch getParentBranch() {
            return this.parent_;
        }

        public double getParentBranchLength() {
            return this.parent_ == null ? 0.0 : this.parent_.getBranchLength();
        }

        public Node getPALPeer() {
            return null;
        }

        public void setLabel(String label) {
            this.label_ = label;
        }

        public void resetChildren() {
            if (this.children_ != null) {
                this.children_.clear();
            }
        }

        private final InstructableNode createChildImpl() {
            InstructableNode child = new InstructableNode(this);
            if (this.children_ == null) {
                this.children_ = new ArrayList();
            }
            this.children_.add(child);
            return child;
        }

        public RootedTreeInterface.RBranch getParentRBranch() {
            return this.parent_;
        }

        public RootedTreeInterface.RNode createRChild() {
            return this.createChildImpl();
        }

        public UnrootedTreeInterface.UBranch getParentUBranch() {
            return this.parent_;
        }

        public UnrootedTreeInterface.UNode createUChild() {
            return this.createChildImpl();
        }
    }

    private static final class UnrootedInterfaceImpl
    implements UnrootedTreeInterface {
        private InstructableBranch root_;

        private UnrootedInterfaceImpl() {
        }

        public UnrootedTreeInterface.BaseBranch createBase() {
            this.root_ = new InstructableBranch();
            return this.root_;
        }

        public SimpleBranch getSimpleRootBranch() {
            return this.root_;
        }
    }

    private static final class RootedInterfaceImpl
    implements RootedTreeInterface {
        private InstructableNode root_;

        private RootedInterfaceImpl() {
        }

        public RootedTreeInterface.RNode createRoot() {
            this.root_ = new InstructableNode();
            return this.root_;
        }

        public SimpleNode getSimpleRoot() {
            return this.root_;
        }
    }

    private static interface SimpleBranch {
        public double getBranchLength();

        public Object getAnnotation();

        public SimpleNode getParentNode();

        public SimpleNode getChildNode();
    }

    private static interface SimpleNode {
        public boolean isLeaf();

        public int getNumberOfChildren();

        public SimpleNode getChild(int var1);

        public SimpleBranch getParentBranch();

        public Object getAnnotation();

        public String getLabel();

        public double getParentBranchLength();

        public Node getPALPeer();
    }

    public static interface BranchAccess {
        public TreeManipulator attachSubTree(Node var1, int var2);

        public String[][] getLabelSplit();

        public void setAnnotation(Object var1);
    }

    private static final class BranchAccessImpl
    implements BranchAccess {
        private final Connection connection_;
        private final int units_;
        private final TreeManipulator parent_;

        public BranchAccessImpl(TreeManipulator parent, Connection connection, int units) {
            this.connection_ = connection;
            this.units_ = units;
            this.parent_ = parent;
        }

        public TreeManipulator attachSubTree(Node subTree, int constructionMode) {
            return new TreeManipulator(this.parent_, this.connection_, subTree, constructionMode);
        }

        public String[][] getLabelSplit() {
            return this.connection_.getLabelSplit();
        }

        public void setAnnotation(Object annotation) {
            this.connection_.setAnnotation(annotation);
        }
    }

    private static final class RootIterator
    implements TreeIterator {
        private final Connection[] connections_;
        private final int units_;
        private int currentConnection_;

        public RootIterator(Connection[] connections, int units) {
            this.connections_ = connections;
            this.units_ = units;
            this.currentConnection_ = 0;
        }

        public Tree getNextTree(AlgorithmCallback callback) {
            return TreeManipulator.constructTree(this.connections_[this.currentConnection_++].getRootedAround(), this.units_);
        }

        public boolean isMoreTrees() {
            return this.currentConnection_ != this.connections_.length;
        }
    }

    private static final class UndirectedNode {
        private Connection[] connectedNodes_;
        private final Node palPeer_;
        private final String label_;
        private final Object annotation_;

        private UndirectedNode(Connection connection, int childStartingIndex, SimpleNode parent) {
            this.palPeer_ = null;
            this.label_ = null;
            this.annotation_ = null;
            this.connectedNodes_ = new Connection[3];
            int numberOfChildren = parent.getNumberOfChildren();
            this.connectedNodes_[0] = connection;
            if (numberOfChildren - childStartingIndex == 2) {
                this.connectedNodes_[1] = new Connection(this, parent.getChild(childStartingIndex), 200);
                this.connectedNodes_[2] = new Connection(this, parent.getChild(childStartingIndex + 1), 200);
            } else {
                this.connectedNodes_[1] = new Connection(this, parent.getChild(childStartingIndex), 200);
                this.connectedNodes_[2] = new Connection(this, parent, childStartingIndex + 1, 0.0, null);
            }
        }

        public UndirectedNode(SimpleNode peer, int constructionMode) {
            int numberOfChildren = peer.getNumberOfChildren();
            if (numberOfChildren <= 2) {
                throw new IllegalArgumentException("Peer must have at least three children!");
            }
            this.palPeer_ = peer.getPALPeer();
            this.label_ = peer.getLabel();
            this.annotation_ = peer.getLabel();
            if (constructionMode == 300) {
                int numberOfReducedChildren = UndirectedNode.countReducedChildren(peer);
                this.connectedNodes_ = new Connection[numberOfReducedChildren];
                int i = 0;
                while (i < numberOfReducedChildren) {
                    Connection c;
                    this.connectedNodes_[i] = c = new Connection(this, UndirectedNode.getReducedChild(peer, i), 300);
                    ++i;
                }
            } else if (constructionMode == 100 || numberOfChildren <= 3) {
                this.connectedNodes_ = new Connection[numberOfChildren];
                int i = 0;
                while (i < numberOfChildren) {
                    this.connectedNodes_[i] = new Connection(this, peer.getChild(i), constructionMode);
                    ++i;
                }
            } else {
                this.connectedNodes_ = new Connection[3];
                this.connectedNodes_[0] = new Connection(this, peer.getChild(0), constructionMode);
                this.connectedNodes_[1] = new Connection(this, peer.getChild(1), constructionMode);
                this.connectedNodes_[2] = new Connection(this, peer, 2, 0.0, null);
            }
        }

        private UndirectedNode(int constructionMode, Connection parentConnection, SimpleNode peer) {
            this.palPeer_ = peer.getPALPeer();
            this.label_ = peer.getLabel();
            this.annotation_ = peer.getAnnotation();
            int numberOfChildren = peer.getNumberOfChildren();
            if (constructionMode == 300) {
                int numberOfReducedChildren = UndirectedNode.countReducedChildren(peer);
                this.connectedNodes_ = new Connection[numberOfReducedChildren + 1];
                this.connectedNodes_[0] = parentConnection;
                int i = 0;
                while (i < numberOfReducedChildren) {
                    Connection c;
                    this.connectedNodes_[i + 1] = c = new Connection(this, UndirectedNode.getReducedChild(peer, i), 300);
                    ++i;
                }
            } else if (constructionMode == 100 || numberOfChildren <= 2) {
                this.connectedNodes_ = new Connection[numberOfChildren + 1];
                this.connectedNodes_[0] = parentConnection;
                int i = 0;
                while (i < numberOfChildren) {
                    this.connectedNodes_[i + 1] = new Connection(this, peer.getChild(i), constructionMode);
                    ++i;
                }
            } else {
                this.connectedNodes_ = new Connection[3];
                this.connectedNodes_[0] = parentConnection;
                this.connectedNodes_[1] = new Connection(this, peer.getChild(0), constructionMode);
                this.connectedNodes_[2] = new Connection(this, peer, 1, 0.0, null);
            }
        }

        private UndirectedNode(UndirectedNode orginal, Connection attachmentPoint, SimpleNode subTree, int constructionModel, Connection parent) {
            throw new RuntimeException("Not implemented yet!");
        }

        public final UndirectedNode getAttached(Connection attachmentPoint, SimpleNode subTree, int constructionMode, Connection parent) {
            return new UndirectedNode(this, attachmentPoint, subTree, constructionMode, parent);
        }

        private static final int countReducedChildren(SimpleNode base) {
            int count = 0;
            int childCount = base.getNumberOfChildren();
            int i = 0;
            while (i < childCount) {
                SimpleNode c = base.getChild(i);
                count = !c.isLeaf() && c.getParentBranchLength() <= 1.0E-9 ? (count += UndirectedNode.countReducedChildren(c)) : ++count;
                ++i;
            }
            return count;
        }

        private static final SimpleNode getReducedChild(SimpleNode base, int childIndex) {
            int childCount = base.getNumberOfChildren();
            int i = 0;
            while (i < childCount) {
                SimpleNode c = base.getChild(i);
                if (!c.isLeaf() && c.getParentBranchLength() <= 1.0E-9) {
                    SimpleNode rc = UndirectedNode.getReducedChild(c, childIndex);
                    if (rc != null) {
                        return rc;
                    }
                    childIndex -= UndirectedNode.countReducedChildren(c);
                } else {
                    if (childIndex == 0) {
                        return c;
                    }
                    --childIndex;
                }
                ++i;
            }
            return null;
        }

        public void instruct(UnrootedTreeInterface.UNode node, Connection callingConnection) {
            if (this.label_ != null) {
                node.setLabel(this.label_);
            }
            if (this.annotation_ != null) {
                node.setAnnotation(this.annotation_);
            }
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    c.instruct(node.createUChild().getParentUBranch(), this);
                }
                ++i;
            }
        }

        public final int getNumberOfMatchingLeaves(String[] leafSet, Connection caller) {
            if (this.isLeaf()) {
                return TreeManipulator.contains(leafSet, this.label_) ? 1 : 0;
            }
            int count = 0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != caller) {
                    count += c.getNumberOfMatchingLeaves(leafSet, this);
                }
                ++i;
            }
            return count;
        }

        public int getExactCladeCount(String[] possibleCladeMembers, Connection caller) {
            if (this.isLeaf()) {
                return Utils.isContains(possibleCladeMembers, this.label_) ? 1 : 0;
            }
            int count = 0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != caller) {
                    int subCount = c.getExactCladeCount(possibleCladeMembers, this);
                    if (subCount < 0) {
                        return -1;
                    }
                    if (subCount == 0) {
                        if (count > 0) {
                            return -1;
                        }
                    } else if (i == 0) {
                        count = subCount;
                    } else {
                        if (count == 0) {
                            return -1;
                        }
                        count += subCount;
                    }
                }
                ++i;
            }
            return count;
        }

        public void instruct(RootedTreeInterface.RNode base, Connection callingConnection) {
            if (this.label_ != null) {
                base.setLabel(this.label_);
            }
            if (this.annotation_ != null) {
                base.setAnnotation(this.annotation_);
            }
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    c.instruct(base.createRChild().getParentRBranch(), this);
                }
                ++i;
            }
        }

        public Connection getPeerParentConnection() {
            return this.connectedNodes_[0];
        }

        private void assertCallingConnection(Connection callingConnection) {
            boolean found = false;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                if (this.connectedNodes_[i] == callingConnection) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                throw new RuntimeException("Assertion error : calling connection not one of my connections");
            }
        }

        public void callMethodOnConnections(Connection callingConnection, ConnectionMethodCaller caller) {
            this.assertCallingConnection(callingConnection);
            int i = 0;
            while (i < this.connectedNodes_.length) {
                if (this.connectedNodes_[i] != callingConnection) {
                    caller.callOn(this.connectedNodes_[i], this);
                }
                ++i;
            }
        }

        public int getNumberOfConnections() {
            return this.getNumberOfConnections(null);
        }

        public int getNumberOfConnections(Connection callingConnection) {
            int count = 0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    count += c.getNumberOfConnections(this);
                }
                ++i;
            }
            return count;
        }

        public final void addLabels(ArrayList store, Connection callingConnection) {
            boolean count = false;
            if (this.connectedNodes_.length == 1) {
                if (callingConnection != this.connectedNodes_[0]) {
                    throw new RuntimeException("Assertion error : calling connection not recognised");
                }
                store.add(this.label_);
            } else {
                int i = 0;
                while (i < this.connectedNodes_.length) {
                    Connection c = this.connectedNodes_[i];
                    if (c != callingConnection) {
                        c.addLabels(store, this);
                    }
                    ++i;
                }
            }
        }

        public Connection[] getAllConnections() {
            int size = this.getNumberOfConnections();
            Connection[] array = new Connection[size];
            this.getConnections(array, 0);
            return array;
        }

        public int getConnections(Connection[] array, int index) {
            return this.getConnections(null, array, index);
        }

        public int getConnections(Connection callingConnection, Connection[] array, int index) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    index = c.getConnections(this, array, index);
                }
                ++i;
            }
            return index;
        }

        private final Connection getMidPointConnection(Connection callingConnection, Connection best) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    best = c.getMidPointConnection(this, best);
                }
                ++i;
            }
            return best;
        }

        public final Connection getMRCAConnectionBaseTraverse(Connection callingConnection, String[] nodeNames) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection mrca;
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection && (mrca = c.getMRCAConnectionBaseTraverse(this, nodeNames)) != null) {
                    return mrca;
                }
                ++i;
            }
            return null;
        }

        public final int getAllMRCAConnectionBaseTraverse(Connection callingConnection, String[] nodeNames, Connection[] store, int numberInStore) {
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (c != callingConnection) {
                    numberInStore = c.getAllMRCAConnectionBaseTraverse(this, nodeNames, store, numberInStore);
                }
                ++i;
            }
            return numberInStore;
        }

        public final boolean isLeaf() {
            return this.connectedNodes_.length <= 1;
        }

        public double getMaximumPathLengthToLeaf(Connection blockingConnection) {
            double maxPathLength = 0.0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection c = this.connectedNodes_[i];
                if (this.connectedNodes_[i] != blockingConnection) {
                    UndirectedNode other = c.getOtherEnd(this);
                    double length = c.getMaxLengthToLeaf(this) + c.getDistance();
                    maxPathLength = Math.max(maxPathLength, length);
                }
                ++i;
            }
            return maxPathLength;
        }

        public Node buildTree(Connection blockingConnection, double distance) {
            if (this.connectedNodes_.length == 1) {
                return NodeFactory.createNodeBranchLength(distance, new Identifier(this.label_));
            }
            Node[] children = new Node[this.connectedNodes_.length - 1];
            int addIndex = 0;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                if (blockingConnection != this.connectedNodes_[i]) {
                    UndirectedNode other = this.connectedNodes_[i].getOtherEnd(this);
                    children[addIndex++] = other.buildTree(this.connectedNodes_[i], this.connectedNodes_[i].distance_);
                }
                ++i;
            }
            return NodeFactory.createNodeBranchLength(distance, children);
        }

        public Node buildUnrootedTree() {
            if (this.connectedNodes_.length == 1) {
                return NodeFactory.createNode(new Identifier(this.label_));
            }
            Node[] children = new Node[this.connectedNodes_.length];
            int i = 0;
            while (i < this.connectedNodes_.length) {
                UndirectedNode other = this.connectedNodes_[i].getOtherEnd(this);
                children[i] = other.buildTree(this.connectedNodes_[i], this.connectedNodes_[i].distance_);
                ++i;
            }
            return NodeFactory.createNode(children);
        }

        public UndirectedNode getMRCA(Connection callingConnection, String[] nodeNames) {
            if (this.isLeaf()) {
                if (TreeManipulator.contains(nodeNames, this.label_)) {
                    return this;
                }
                return null;
            }
            int count = 0;
            UndirectedNode lastMRCA = null;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                UndirectedNode other;
                UndirectedNode mrca;
                Connection c = this.connectedNodes_[i];
                if (callingConnection != c && (mrca = (other = c.getOtherEnd(this)).getMRCA(c, nodeNames)) != null) {
                    ++count;
                    lastMRCA = mrca;
                }
                ++i;
            }
            switch (count) {
                case 0: {
                    return null;
                }
                case 1: {
                    return lastMRCA;
                }
            }
            return this;
        }

        public Connection getMRCAConnection(Connection callingConnection, String[] nodeNames) {
            if (this.isLeaf()) {
                if (TreeManipulator.contains(nodeNames, this.label_)) {
                    return callingConnection;
                }
                return null;
            }
            int count = 0;
            Connection lastMRCA = null;
            int i = 0;
            while (i < this.connectedNodes_.length) {
                Connection mrca;
                Connection c = this.connectedNodes_[i];
                if (callingConnection != c && (mrca = c.getMRCAConnection(this, nodeNames)) != null) {
                    ++count;
                    lastMRCA = mrca;
                }
                ++i;
            }
            switch (count) {
                case 0: {
                    return null;
                }
                case 1: {
                    return lastMRCA;
                }
            }
            return callingConnection;
        }

        private UndirectedNode getRelatedNode(Node peer, Connection callerConnection) {
            if (this.palPeer_ == peer) {
                return this;
            }
            int i = 0;
            while (i < this.connectedNodes_.length) {
                UndirectedNode n;
                Connection c = this.connectedNodes_[i];
                if (c != callerConnection && (n = this.connectedNodes_[i].getOtherEnd(this).getRelatedNode(peer, c)) != null) {
                    return n;
                }
                ++i;
            }
            return null;
        }

        public UndirectedNode getRelatedNode(Node peer) {
            return this.getRelatedNode(peer, null);
        }
    }

    private static interface ConnectionMethodCaller {
        public void callOn(Connection var1, UndirectedNode var2);
    }

    private static final class Connection {
        private UndirectedNode firstNode_;
        private double maximumPathLengthToLeafViaFirstNode_;
        private boolean isFirstPathInfoFound_ = false;
        private UndirectedNode secondNode_;
        private double maximumPathLengthToLeafViaSecondNode_;
        private boolean isSecondPathInfoFound_ = false;
        private double distance_;
        private Object annotation_;

        public Connection(UndirectedNode firstNode, UndirectedNode secondNode, SimpleBranch connectingBranch) {
            this.firstNode_ = firstNode;
            this.secondNode_ = secondNode;
            this.distance_ = connectingBranch.getBranchLength();
            this.annotation_ = connectingBranch.getAnnotation();
        }

        public Connection(UndirectedNode baseNode, SimpleNode parent, int startingIndex, double branchLength, Object annotation) {
            this.firstNode_ = baseNode;
            this.secondNode_ = new UndirectedNode(this, startingIndex, parent);
            this.distance_ = branchLength;
            this.annotation_ = annotation;
        }

        public Connection(UndirectedNode parentNode, SimpleNode child, int constructionMode) {
            this.firstNode_ = parentNode;
            SimpleBranch connectingBranch = child.getParentBranch();
            this.distance_ = connectingBranch.getBranchLength();
            this.annotation_ = connectingBranch.getAnnotation();
            this.secondNode_ = new UndirectedNode(constructionMode, this, child);
        }

        public Connection(SimpleNode first, SimpleNode second, int constructionMode) {
            this.distance_ = first.getParentBranchLength() + second.getParentBranchLength();
            this.firstNode_ = new UndirectedNode(constructionMode, this, first);
            this.secondNode_ = new UndirectedNode(constructionMode, this, second);
        }

        public Connection(SimpleBranch branch, int constructionMode) {
            SimpleNode first = branch.getParentNode();
            SimpleNode second = branch.getChildNode();
            this.distance_ = branch.getBranchLength();
            this.annotation_ = branch.getAnnotation();
            this.firstNode_ = new UndirectedNode(constructionMode, this, first);
            this.secondNode_ = new UndirectedNode(constructionMode, this, second);
        }

        private Connection(Connection original, Connection attachmentPoint, SimpleNode subTree, int constructionMode) {
            if (original == attachmentPoint) {
                throw new RuntimeException("Not implemented yet!");
            }
            this.distance_ = original.distance_;
            this.annotation_ = original.annotation_;
            this.firstNode_ = original.firstNode_.getAttached(attachmentPoint, subTree, constructionMode, this);
            this.secondNode_ = original.secondNode_.getAttached(attachmentPoint, subTree, constructionMode, this);
        }

        public final Connection getAttached(Connection attachmentPoint, SimpleNode subTree, int constructionMode) {
            return new Connection(this, attachmentPoint, subTree, constructionMode);
        }

        public final String[][] getLabelSplit() {
            throw new RuntimeException("Not implemented yet!");
        }

        public final void setDistance(double distance) {
            this.distance_ = distance;
        }

        public final UndirectedNode getFirst() {
            return this.firstNode_;
        }

        public final UndirectedNode getSecond() {
            return this.secondNode_;
        }

        public final int getExactCladeCount(String[] possibleCladeMembers, UndirectedNode caller) {
            if (caller == this.firstNode_) {
                return this.secondNode_.getExactCladeCount(possibleCladeMembers, this);
            }
            if (caller == this.secondNode_) {
                return this.firstNode_.getExactCladeCount(possibleCladeMembers, this);
            }
            throw new RuntimeException("Assertion erro : unknown caller");
        }

        public final boolean isFormsExactClade(String[] possibleCladeMembers) {
            int leftCount = this.firstNode_.getExactCladeCount(possibleCladeMembers, this);
            int rightCount = this.secondNode_.getExactCladeCount(possibleCladeMembers, this);
            if (leftCount < 0 || rightCount < 0) {
                return false;
            }
            return leftCount > 0 && rightCount == 0 || rightCount > 0 && leftCount == 0;
        }

        public final int getNumberOfMatchingLeaves(String[] leafSet) {
            return this.firstNode_.getNumberOfMatchingLeaves(leafSet, this) + this.secondNode_.getNumberOfMatchingLeaves(leafSet, this);
        }

        public final int getNumberOfMatchingLeaves(String[] leafSet, UndirectedNode caller) {
            if (caller == this.firstNode_) {
                return this.secondNode_.getNumberOfMatchingLeaves(leafSet, this);
            }
            if (caller == this.secondNode_) {
                return this.firstNode_.getNumberOfMatchingLeaves(leafSet, this);
            }
            throw new RuntimeException("Assertion error : unknown caller");
        }

        public final UndirectedNode getRelatedNode(Node n) {
            UndirectedNode fromFirst = this.firstNode_.getRelatedNode(n, this);
            if (fromFirst != null) {
                return fromFirst;
            }
            return this.secondNode_.getRelatedNode(n, this);
        }

        public Node getUnrooted() {
            if (this.firstNode_.isLeaf()) {
                return this.secondNode_.buildUnrootedTree();
            }
            return this.firstNode_.buildUnrootedTree();
        }

        public final double getMaximumPathLengthToLeafViaFirst() {
            if (!this.isFirstPathInfoFound_) {
                this.maximumPathLengthToLeafViaFirstNode_ = this.firstNode_.getMaximumPathLengthToLeaf(this);
                this.isFirstPathInfoFound_ = true;
            }
            return this.maximumPathLengthToLeafViaFirstNode_;
        }

        public final double getMaximumPathLengthToLeafViaSecond() {
            if (!this.isSecondPathInfoFound_) {
                this.maximumPathLengthToLeafViaSecondNode_ = this.secondNode_.getMaximumPathLengthToLeaf(this);
                this.isSecondPathInfoFound_ = true;
            }
            return this.maximumPathLengthToLeafViaSecondNode_;
        }

        public final void addLabels(ArrayList store, UndirectedNode callingNode) {
            if (callingNode == this.firstNode_) {
                this.secondNode_.addLabels(store, this);
            } else if (callingNode == this.secondNode_) {
                this.firstNode_.addLabels(store, this);
            } else {
                throw new RuntimeException("Assertion error : unknown calling node!");
            }
        }

        public void setAnnotation(Object annotation) {
            this.annotation_ = annotation;
        }

        public void instruct(UnrootedTreeInterface.BaseBranch base) {
            base.setLength(this.distance_);
            if (this.annotation_ != null) {
                base.setAnnotation(this.annotation_);
            }
            this.firstNode_.instruct(base.getLeftNode(), this);
            this.secondNode_.instruct(base.getRightNode(), this);
        }

        public void instruct(RootedTreeInterface.RNode base, double firstChildLength) {
            base.resetChildren();
            RootedTreeInterface.RNode left = base.createRChild();
            RootedTreeInterface.RNode right = base.createRChild();
            RootedTreeInterface.RBranch leftBranch = left.getParentRBranch();
            RootedTreeInterface.RBranch rightBranch = right.getParentRBranch();
            leftBranch.setLength(firstChildLength);
            rightBranch.setLength(this.distance_ - firstChildLength);
            if (this.annotation_ != null) {
                leftBranch.setAnnotation(this.annotation_);
                rightBranch.setAnnotation(this.annotation_);
            }
            this.firstNode_.instruct(left, this);
            this.secondNode_.instruct(right, this);
        }

        public void instruct(UnrootedTreeInterface.UBranch base, UndirectedNode callingNode) {
            base.setLength(this.distance_);
            if (this.annotation_ != null) {
                base.setAnnotation(this.annotation_);
            }
            if (callingNode == this.firstNode_) {
                this.secondNode_.instruct(base.getFartherNode(), this);
            } else if (callingNode == this.secondNode_) {
                this.firstNode_.instruct(base.getFartherNode(), this);
            } else {
                throw new IllegalArgumentException("Calling node is unknown!");
            }
        }

        public void instruct(RootedTreeInterface.RBranch base, UndirectedNode callingNode) {
            base.setLength(this.distance_);
            if (this.annotation_ != null) {
                base.setAnnotation(this.annotation_);
            }
            if (callingNode == this.firstNode_) {
                this.secondNode_.instruct(base.getMoreRecentNode(), this);
            } else if (callingNode == this.secondNode_) {
                this.firstNode_.instruct(base.getMoreRecentNode(), this);
            } else {
                throw new IllegalArgumentException("Calling node is unknown!");
            }
        }

        public final double getMaximumPathDifference() {
            return Math.abs(this.getMaximumPathLengthToLeafViaFirst() - this.getMaximumPathLengthToLeafViaSecond());
        }

        public Connection getMRCAConnection(String[] nodeNames) {
            return this.getMRCAConnection(null, nodeNames);
        }

        public Node getRootedAroundMRCA(String[] nodeNames) {
            Connection mrca = this.getMRCAConnectionBaseTraverse(nodeNames);
            if (mrca != null) {
                return mrca.getRootedAround();
            }
            throw new IllegalArgumentException("Non existent outgroup:" + Utils.toString(nodeNames));
        }

        public void instructRootedAroundMRCA(RootedTreeInterface rootedInterface, String[] nodeNames) {
            Connection mrca = this.getMRCAConnectionBaseTraverse(nodeNames);
            if (mrca == null) {
                throw new IllegalArgumentException("Non existent outgroup:" + Utils.toString(nodeNames));
            }
            mrca.instructRootedAround(rootedInterface);
        }

        public Node[] getAllRootedAroundMRCA(String[] nodeNames) {
            Connection[] mrca = this.getAllMRCAConnectionBaseTraverse(nodeNames);
            if (mrca.length == 0) {
                throw new IllegalArgumentException("Non existent outgroup:" + Utils.toString(nodeNames));
            }
            Node[] nodes = new Node[mrca.length];
            int i = 0;
            while (i < nodes.length) {
                nodes[i] = mrca[i].getRootedAround();
                ++i;
            }
            return nodes;
        }

        public Node getRootedAroundMRCA(String[] nodeNames, double ingroupBranchLength) {
            Connection mrca = this.getMRCAConnectionBaseTraverse(nodeNames);
            if (mrca != null) {
                return mrca.getRootedAround(ingroupBranchLength, nodeNames);
            }
            if (this.getNumberOfMatchingLeaves(nodeNames) > 0) {
                return this.getRootedAround(ingroupBranchLength, nodeNames);
            }
            throw new IllegalArgumentException("Non existent outgroup:" + Utils.toString(nodeNames));
        }

        public Connection getMRCAConnection(UndirectedNode blockingNode, String[] nodeNames) {
            Connection second;
            Connection first = this.firstNode_ != blockingNode ? this.firstNode_.getMRCAConnection(this, nodeNames) : null;
            Connection connection = second = this.secondNode_ != blockingNode ? this.secondNode_.getMRCAConnection(this, nodeNames) : null;
            if (first != null) {
                if (second != null) {
                    return this;
                }
                return first;
            }
            return second;
        }

        public Connection getMRCAConnectionBaseTraverse(String[] nodeNames) {
            return this.getMRCAConnectionBaseTraverse(null, nodeNames);
        }

        public Connection[] getAllMRCAConnectionBaseTraverse(String[] nodeNames) {
            Connection[] store = new Connection[this.getNumberOfConnections()];
            int total = this.getAllMRCAConnectionBaseTraverse(nodeNames, store, 0);
            Connection[] result = new Connection[total];
            System.arraycopy(store, 0, result, 0, total);
            return result;
        }

        public int getAllMRCAConnectionBaseTraverse(String[] nodeNames, Connection[] store, int numberInStore) {
            return this.getAllMRCAConnectionBaseTraverse(null, nodeNames, store, numberInStore);
        }

        public Connection getMRCAConnectionBaseTraverse(UndirectedNode callingNode, String[] nodeNames) {
            Connection first = this.firstNode_.getMRCAConnection(this, nodeNames);
            Connection second = this.secondNode_.getMRCAConnection(this, nodeNames);
            System.out.println("Traverse:" + first + "   " + second);
            if (first != null) {
                Connection attempt;
                if (second == null) {
                    return first;
                }
                if (this.firstNode_ != callingNode && (attempt = this.firstNode_.getMRCAConnectionBaseTraverse(this, nodeNames)) != null) {
                    return attempt;
                }
                if (this.secondNode_ != callingNode && (attempt = this.secondNode_.getMRCAConnectionBaseTraverse(this, nodeNames)) != null) {
                    return attempt;
                }
                return null;
            }
            return second;
        }

        private final int addToStore(Connection c, Connection[] store, int numberInStore) {
            int i = 0;
            while (i < numberInStore) {
                if (store[i] == c) {
                    return numberInStore;
                }
                ++i;
            }
            store[numberInStore++] = c;
            return numberInStore;
        }

        public int getAllMRCAConnectionBaseTraverse(UndirectedNode callingNode, String[] nodeNames, Connection[] store, int numberInStore) {
            Connection first = this.firstNode_.getMRCAConnection(this, nodeNames);
            Connection second = this.secondNode_.getMRCAConnection(this, nodeNames);
            if (first != null) {
                if (second == null) {
                    return this.addToStore(first, store, numberInStore);
                }
                if (first == second && second == this) {
                    return this.addToStore(this, store, numberInStore);
                }
                if (this.firstNode_ != callingNode) {
                    numberInStore = this.firstNode_.getAllMRCAConnectionBaseTraverse(this, nodeNames, store, numberInStore);
                }
                if (this.secondNode_ != callingNode) {
                    numberInStore = this.secondNode_.getAllMRCAConnectionBaseTraverse(this, nodeNames, store, numberInStore);
                }
            }
            return numberInStore;
        }

        public final int getNumberOfConnections() {
            return this.getNumberOfConnections(null);
        }

        protected final int getNumberOfConnections(UndirectedNode blockingNode) {
            int count = 0;
            if (this.firstNode_ != blockingNode) {
                count += this.firstNode_.getNumberOfConnections(this);
            }
            if (this.secondNode_ != blockingNode) {
                count += this.secondNode_.getNumberOfConnections(this);
            }
            return count + 1;
        }

        public final Connection[] getAllConnections() {
            int size = this.getNumberOfConnections();
            Connection[] array = new Connection[size];
            this.getConnections(array, 0);
            return array;
        }

        protected final int getConnections(Connection[] array, int index) {
            return this.getConnections(null, array, index);
        }

        protected final int getConnections(UndirectedNode blockingNode, Connection[] array, int index) {
            array[index++] = this;
            if (this.firstNode_ != blockingNode) {
                index = this.firstNode_.getConnections(this, array, index);
            }
            if (this.secondNode_ != blockingNode) {
                index = this.secondNode_.getConnections(this, array, index);
            }
            return index;
        }

        public final Connection getMidPointConnection(UndirectedNode blockingNode, Connection best) {
            if (blockingNode == this.secondNode_) {
                best = this.firstNode_.getMidPointConnection(this, best);
            } else if (blockingNode == this.firstNode_) {
                best = this.secondNode_.getMidPointConnection(this, best);
            } else {
                throw new RuntimeException("Assertion error : getMidPointConnection called with invalid blockingNode");
            }
            double myPathDiff = this.getMaximumPathDifference();
            double bestDiff = best.getMaximumPathDifference();
            return myPathDiff < bestDiff ? this : best;
        }

        public Connection getMidPointConnection() {
            Connection best = this;
            best = this.getMidPointConnection(this.firstNode_, best);
            best = this.getMidPointConnection(this.secondNode_, best);
            return best;
        }

        public Node getMidPointRooted() {
            return this.getMidPointConnection().getRootedAround();
        }

        public double getMaxLengthToLeaf(UndirectedNode blockingNode) {
            if (this.secondNode_ == blockingNode) {
                return this.getMaximumPathLengthToLeafViaFirst();
            }
            if (this.firstNode_ == blockingNode) {
                return this.getMaximumPathLengthToLeafViaSecond();
            }
            throw new RuntimeException("Connection.GetMaxLengthToLeaf() called from unknown asking node");
        }

        public void recalculateMaximumPathLengths() {
            this.clearPathInfo();
            this.updatePathInfo();
            this.assertPathInfo();
        }

        public void assertPathInfo() {
            this.assertPathInfo(null);
        }

        public void assertPathInfo(UndirectedNode blockingNode) {
            if (this.isFirstPathInfoFound_ && this.isSecondPathInfoFound_) {
                if (blockingNode != this.firstNode_) {
                    this.firstNode_.callMethodOnConnections(this, ASSERT_PATH_INFO_CALLER);
                }
                if (blockingNode != this.secondNode_) {
                    this.secondNode_.callMethodOnConnections(this, ASSERT_PATH_INFO_CALLER);
                }
            } else {
                throw new RuntimeException("Assertion error : assertPathInfo failed!");
            }
        }

        public void updatePathInfo() {
            this.updatePathInfo(null);
        }

        public void updatePathInfo(UndirectedNode blockingNode) {
            if (!this.isFirstPathInfoFound_) {
                this.maximumPathLengthToLeafViaFirstNode_ = this.firstNode_.getMaximumPathLengthToLeaf(this);
                this.isFirstPathInfoFound_ = true;
            }
            if (blockingNode != this.firstNode_) {
                this.firstNode_.callMethodOnConnections(this, UPDATE_PATH_INFO_CALLER);
            }
            if (!this.isSecondPathInfoFound_) {
                this.maximumPathLengthToLeafViaSecondNode_ = this.secondNode_.getMaximumPathLengthToLeaf(this);
                this.isSecondPathInfoFound_ = true;
            }
            if (blockingNode != this.secondNode_) {
                this.secondNode_.callMethodOnConnections(this, UPDATE_PATH_INFO_CALLER);
            }
        }

        public void clearPathInfo() {
            this.clearPathInfo(null);
        }

        public void clearPathInfo(UndirectedNode blockingNode) {
            this.isFirstPathInfoFound_ = false;
            this.isSecondPathInfoFound_ = false;
            if (blockingNode != this.firstNode_) {
                this.firstNode_.callMethodOnConnections(this, CLEAR_PATH_INFO_CALLER);
            }
            if (blockingNode != this.secondNode_) {
                this.secondNode_.callMethodOnConnections(this, CLEAR_PATH_INFO_CALLER);
            }
        }

        public final double getDistance() {
            return this.distance_;
        }

        public final boolean isConnectedTo(UndirectedNode node) {
            return node == this.firstNode_ || node == this.secondNode_;
        }

        public final UndirectedNode getOtherEnd(UndirectedNode oneEnd) {
            if (oneEnd == this.firstNode_) {
                return this.secondNode_;
            }
            if (oneEnd == this.secondNode_) {
                return this.firstNode_;
            }
            throw new RuntimeException("Assertion error : getOtherEnd called with non connecting node");
        }

        public final void instructRootedAround(RootedTreeInterface rootedInterface) {
            RootedTreeInterface.RNode root = rootedInterface.createRoot();
            this.instructRootedAround(root);
        }

        public final void instructRootedAround(RootedTreeInterface.RNode peer) {
            double rightDist;
            double leftDist = this.getMaximumPathLengthToLeafViaFirst();
            double diff = leftDist - (rightDist = this.getMaximumPathLengthToLeafViaSecond());
            if (diff > this.distance_) {
                diff = 0.0;
            } else if (diff < -this.distance_) {
                diff = 0.0;
            }
            peer.resetChildren();
            RootedTreeInterface.RNode left = peer.createRChild();
            RootedTreeInterface.RNode right = peer.createRChild();
            RootedTreeInterface.RBranch leftBranch = left.getParentRBranch();
            RootedTreeInterface.RBranch rightBranch = right.getParentRBranch();
            leftBranch.setLength((this.distance_ - diff) / 2.0);
            rightBranch.setLength((this.distance_ + diff) / 2.0);
            if (this.annotation_ != null) {
                leftBranch.setAnnotation(this.annotation_);
                rightBranch.setAnnotation(this.annotation_);
            }
            this.firstNode_.instruct(left, this);
            this.secondNode_.instruct(right, this);
        }

        public final Node getRootedAround() {
            double rightDist;
            double leftDist = this.getMaximumPathLengthToLeafViaFirst();
            double diff = leftDist - (rightDist = this.getMaximumPathLengthToLeafViaSecond());
            if (diff > this.distance_) {
                diff = 0.0;
            } else if (diff < -this.distance_) {
                diff = 0.0;
            }
            Node left = this.firstNode_.buildTree(this, (this.distance_ - diff) / 2.0);
            Node right = this.secondNode_.buildTree(this, (this.distance_ + diff) / 2.0);
            Node n = NodeFactory.createNode(new Node[]{left, right});
            return n;
        }

        public final Node getRootedAround(double distanceForFirstChild) {
            double distanceForSecondChild = this.distance_ - distanceForFirstChild;
            if (distanceForSecondChild < 0.0) {
                distanceForFirstChild = this.distance_;
                distanceForSecondChild = 0.0;
            }
            Node left = this.firstNode_.buildTree(this, distanceForFirstChild);
            Node right = this.secondNode_.buildTree(this, distanceForSecondChild);
            Node n = NodeFactory.createNode(new Node[]{left, right});
            return n;
        }

        public final Node getRootedAround(double ingroupDistance, String[] outgroupMembers) {
            UndirectedNode ingroup;
            UndirectedNode outgroup;
            if (this.firstNode_.getMRCA(this, outgroupMembers) != null) {
                outgroup = this.firstNode_;
                ingroup = this.secondNode_;
            } else {
                ingroup = this.firstNode_;
                outgroup = this.secondNode_;
            }
            double distanceForOutgroup = this.distance_ - ingroupDistance;
            if (distanceForOutgroup < 0.0) {
                ingroupDistance = this.distance_;
                distanceForOutgroup = 0.0;
            }
            Node left = ingroup.buildTree(this, ingroupDistance);
            Node right = outgroup.buildTree(this, distanceForOutgroup);
            return NodeFactory.createNode(new Node[]{left, right});
        }
    }
}

