/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.distance.DistanceMatrix;
import pal.distance.DistanceMatrixGenerator;
import pal.tree.NeighborJoiningTree;
import pal.tree.Tree;
import pal.tree.TreeManipulator;
import pal.util.AlgorithmCallback;

public interface TreeGenerator {
    public Tree getNextTree(AlgorithmCallback var1);

    public static final class Utils {
        public static final TreeGenerator createNeighbourJoiningGenerator(DistanceMatrixGenerator dataGenerator, String[] outgroupNames) {
            return new NJGenerator(dataGenerator, outgroupNames);
        }

        private static final class NJGenerator
        implements TreeGenerator {
            private final DistanceMatrixGenerator dataGenerator_;
            private final String[] outgroupNames_;

            public NJGenerator(DistanceMatrixGenerator dataGenerator, String[] outgroupNames) {
                this.dataGenerator_ = dataGenerator;
                this.outgroupNames_ = outgroupNames;
            }

            public Tree getNextTree(AlgorithmCallback callback) {
                DistanceMatrix dm = this.dataGenerator_.generateNextMatrix(callback);
                NeighborJoiningTree t = new NeighborJoiningTree(dm);
                TreeManipulator tm = new TreeManipulator(t, 300);
                return tm.getTreeRootedBy(this.outgroupNames_);
            }
        }
    }
}

