/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.distance.DistanceMatrix;
import pal.misc.IdGroup;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class TreeDistanceMatrix
extends DistanceMatrix {
    public TreeDistanceMatrix(Tree t, IdGroup idGroup, boolean countEdges, double epsilon) {
        super(TreeDistanceMatrix.computeDistances(t, idGroup, countEdges, epsilon), idGroup);
    }

    public TreeDistanceMatrix(Tree t, IdGroup idGroup) {
        this(t, idGroup, false, 0.0);
    }

    public TreeDistanceMatrix(Tree t, boolean countEdges, double epsilon) {
        this(t, TreeUtils.getLeafIdGroup(t), countEdges, epsilon);
    }

    public TreeDistanceMatrix(Tree t) {
        this(t, false, 0.0);
    }

    private static final double[][] computeDistances(Tree tree, IdGroup idGroup) {
        return TreeDistanceMatrix.computeDistances(tree, idGroup, false, 0.0);
    }

    public void recompute(Tree t) {
        IdGroup idGroup = TreeUtils.getLeafIdGroup(t);
        this.setIdGroup(idGroup);
        this.setDistances(TreeDistanceMatrix.computeDistances(t, idGroup));
    }

    private static final double[][] computeDistances(Tree tree, IdGroup idGroup, boolean countEdges, double epsilon) {
        int numSeqs = idGroup.getIdCount();
        double[][] distance = new double[numSeqs][numSeqs];
        int[] alias = TreeUtils.mapExternalIdentifiers(idGroup, tree);
        double[] dist = new double[tree.getExternalNodeCount()];
        double[] idist = new double[tree.getInternalNodeCount()];
        int i = 0;
        while (i < tree.getExternalNodeCount()) {
            TreeUtils.computeAllDistances(tree, i, dist, idist, countEdges, epsilon);
            int ai = alias[i];
            int j = 0;
            while (j < tree.getExternalNodeCount()) {
                distance[ai][alias[j]] = dist[j];
                ++j;
            }
            ++i;
        }
        return distance;
    }
}

