/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.math.OrderEnumerator;
import pal.math.OrthogonalHints;
import pal.mep.MutationRateModel;
import pal.misc.TimeOrderCharacterData;
import pal.misc.Utils;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.ParameterizedTree;
import pal.tree.Tree;

public class MutationRateModelTree
extends ParameterizedTree.ParameterizedTreeBase
implements OrthogonalHints,
ParameterizedTree {
    TimeOrderCharacterData tocd = null;
    MutationRateModel model = null;
    int numParameters;
    double maxRelativeHeight_ = 1.0;
    private double[] parameter;
    private double lnL = 0.0;
    private static final double MIN_MU = 1.0E-12;
    private static final double MIN_DELTA = 1.0E-12;

    public MutationRateModelTree(Tree t, TimeOrderCharacterData tocd, MutationRateModel model) {
        this(t, tocd, model, true);
    }

    public MutationRateModelTree(Tree t, TimeOrderCharacterData tocd, MutationRateModel model, boolean includeModelParameters) {
        this.setBaseTree(t);
        this.tocd = tocd;
        this.model = model;
        if (t.getRoot().getChildCount() < 2) {
            throw new RuntimeException("The root node must have at least two childs!");
        }
        NodeUtils.heights2Lengths(this.getRoot());
        this.numParameters = this.getInternalNodeCount();
        if (includeModelParameters) {
            this.numParameters += model.getNumParameters();
        }
        if (!tocd.hasTimes()) {
            throw new RuntimeException("Must have times!");
        }
        this.parameter = new double[this.getInternalNodeCount()];
        this.heights2parameters();
    }

    protected MutationRateModelTree(MutationRateModelTree toCopy) {
        this.tocd = toCopy.tocd;
        this.model = (MutationRateModel)toCopy.model.clone();
        this.parameter = Utils.getCopy(toCopy.parameter);
        this.lnL = toCopy.lnL;
        this.numParameters = toCopy.numParameters;
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public void setMaxRelativeHeight(double value) {
        this.maxRelativeHeight_ = value;
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public void setParameter(double param, int n) {
        if (n < this.getInternalNodeCount()) {
            this.parameter[n] = param;
        } else {
            this.model.setParameter(param, n - this.getInternalNodeCount());
        }
        this.parameters2Heights();
        NodeUtils.heights2Lengths(this.getRoot());
    }

    public double getParameter(int n) {
        if (n < this.getInternalNodeCount()) {
            return this.parameter[n];
        }
        return this.model.getParameter(n - this.getInternalNodeCount());
    }

    public double getLowerLimit(int n) {
        if (n < this.getInternalNodeCount()) {
            return 1.0E-9;
        }
        return this.model.getLowerLimit(n - this.getInternalNodeCount());
    }

    public double getDefaultValue(int n) {
        if (n < this.getInternalNodeCount()) {
            return 0.04;
        }
        return this.model.getDefaultValue(n - this.getInternalNodeCount());
    }

    public void setParameterSE(double paramSE, int n) {
        if (n < this.getInternalNodeCount()) {
            return;
        }
        this.model.setParameterSE(paramSE, n - this.getInternalNodeCount());
    }

    public double getUpperLimit(int n) {
        if (n < this.getInternalNodeCount()) {
            return this.maxRelativeHeight_;
        }
        return this.model.getUpperLimit(n - this.getInternalNodeCount());
    }

    public String getParameterizationInfo() {
        return "Mutation Rate Model based tree (" + this.model.toSingleLine() + ")";
    }

    public MutationRateModel getMutationRateModel() {
        return this.model;
    }

    protected void parameters2Heights() {
        int i = 0;
        while (i < this.getExternalNodeCount()) {
            int index = this.tocd.whichIdNumber(this.getExternalNode(i).getIdentifier().getName());
            this.getExternalNode(i).setNodeHeight(this.model.getExpectedSubstitutions(this.tocd.getTime(index)));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.getInternalNodeCount()) {
            Node node = this.getInternalNode(i2);
            node.setNodeHeight(this.parameter[i2] + NodeUtils.findLargestChild(node));
            ++i2;
        }
    }

    protected void heights2parameters() {
        int i = 0;
        while (i < this.getInternalNodeCount()) {
            Node node = this.getInternalNode(i);
            this.parameter[i] = node.getNodeHeight() - NodeUtils.findLargestChild(node);
            ++i;
        }
    }

    public void setLnL(double lnL) {
        this.lnL = lnL;
    }

    public double getLnL() {
        return this.lnL;
    }

    public OrthogonalHints getOrthogonalHints() {
        if (this.model.getNumParameters() == 0) {
            return this;
        }
        OrthogonalHints modelHints = this.model.getOrthogonalHints();
        if (modelHints != null) {
            return OrthogonalHints.Utils.getCombined(this, this.parameter.length, modelHints, this.model.getNumParameters());
        }
        return OrthogonalHints.Utils.getCombined(this, this.parameter.length, OrthogonalHints.Utils.getNull(), this.model.getNumParameters());
    }

    public OrderEnumerator getSuggestedOrdering(OrderEnumerator defaultOrdering) {
        return defaultOrdering;
    }

    public int getInternalParameterBoundaries(int parameter, double[] storage) {
        Node n = this.getInternalNode(parameter);
        if (n.isRoot()) {
            return 0;
        }
        int count = 0;
        Node p = n.getParent();
        Node current = n;
        double offset = 0.0;
        double baseLine = NodeUtils.findLargestChild(n);
        while (p != null) {
            Node max = null;
            int numberOfChildren = p.getChildCount();
            double maxHeight = Double.NEGATIVE_INFINITY;
            double realMaxHeight = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < numberOfChildren) {
                Node c = p.getChild(i);
                double nh = c.getNodeHeight();
                if (c != n && maxHeight < nh) {
                    maxHeight = nh;
                    max = c;
                }
                if (realMaxHeight < nh) {
                    realMaxHeight = nh;
                }
                ++i;
            }
            double value = maxHeight - offset - baseLine;
            if (value > this.maxRelativeHeight_) break;
            if (value > 0.0 && max != current) {
                if (count == storage.length) {
                    return -1;
                }
                if (count == 0 || value > storage[count - 1]) {
                    storage[count++] = value;
                }
            }
            offset += p.getNodeHeight() - realMaxHeight;
            current = p;
            p = p.getParent();
        }
        return count;
    }

    public Tree getCopy() {
        return new MutationRateModelTree(this);
    }

    public Object clone() {
        return this.getCopy();
    }

    public static final ParameterizedTree.Factory getParameterizedTreeFactory(MutationRateModel.Factory rateModel, TimeOrderCharacterData tocd) {
        return new TreeFactory(rateModel, tocd);
    }

    private static class TreeFactory
    implements ParameterizedTree.Factory {
        MutationRateModel.Factory rateModel_;
        TimeOrderCharacterData tocd_;

        public TreeFactory(MutationRateModel.Factory rateModel, TimeOrderCharacterData tocd) {
            this.rateModel_ = rateModel;
            this.tocd_ = tocd;
        }

        public ParameterizedTree generateNewTree(Tree base) {
            return new MutationRateModelTree(base, this.tocd_, this.rateModel_.generateNewModel(), true);
        }
    }
}

