/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.misc.Parameterized;
import pal.misc.Utils;
import pal.substmodel.MatrixExponential;
import pal.substmodel.NeoRateMatrix;

public class RateMatrixHandler
implements Parameterized,
Serializable {
    private final NeoRateMatrix rateMatrix_;
    private final double[] parameters_;
    private final double[] parametersSE_;
    private final double[] defaultParameters_;
    private boolean updateMatrix_ = true;
    private final double[] equilibriumFrequencies_;
    private final int dimension_;
    private final double[][] relativeRateStore_;
    private final double[][] qMatrixStore_;
    private final MatrixExponential matrixExp_;
    private final boolean reversible_;

    private RateMatrixHandler(RateMatrixHandler toCopy) {
        this(toCopy.rateMatrix_, toCopy.equilibriumFrequencies_);
        System.arraycopy(toCopy.parameters_, 0, this.parameters_, 0, this.dimension_);
        System.arraycopy(toCopy.parametersSE_, 0, this.parametersSE_, 0, this.dimension_);
    }

    public RateMatrixHandler(NeoRateMatrix rateMatrix, double[] equilibriumFrequencies) {
        this.rateMatrix_ = rateMatrix;
        System.out.println("Number of Parameters:" + rateMatrix.getNumberOfRateParameters());
        this.dimension_ = this.rateMatrix_.getDimension();
        this.parameters_ = new double[rateMatrix.getNumberOfRateParameters()];
        this.parametersSE_ = new double[this.parameters_.length];
        this.defaultParameters_ = new double[this.parameters_.length];
        rateMatrix.getDefaultRateParameters(this.defaultParameters_, 0);
        System.arraycopy(this.defaultParameters_, 0, this.parameters_, 0, this.parameters_.length);
        this.equilibriumFrequencies_ = Utils.getCopy(equilibriumFrequencies);
        this.relativeRateStore_ = new double[this.dimension_][this.dimension_];
        this.qMatrixStore_ = new double[this.dimension_][this.dimension_];
        this.matrixExp_ = new MatrixExponential(this.dimension_);
        this.reversible_ = this.rateMatrix_.isReversible();
    }

    public final RateMatrixHandler getCopy() {
        return new RateMatrixHandler(this);
    }

    public final double[] getEquilibriumFrequencies() {
        return this.equilibriumFrequencies_;
    }

    private final void checkMatrix() {
        if (this.updateMatrix_) {
            this.rateMatrix_.createRelativeRates(this.relativeRateStore_, this.parameters_, 0);
            RateMatrixHandler.fromQToR(this.relativeRateStore_, this.equilibriumFrequencies_, this.qMatrixStore_, this.dimension_, this.reversible_);
            double scale = RateMatrixHandler.makeValid(this.qMatrixStore_, this.equilibriumFrequencies_, this.dimension_);
            RateMatrixHandler.scale(this.qMatrixStore_, this.dimension_, scale);
            this.matrixExp_.updateByRelativeRates(this.qMatrixStore_);
            this.updateMatrix_ = false;
        }
    }

    public void getTransitionProbabilities(double distance, double[][] store) {
        this.checkMatrix();
        this.matrixExp_.setDistance(distance);
        this.matrixExp_.getTransitionProbabilities(store);
    }

    public void getTransitionProbabilitiesTranspose(double distance, double[][] store) {
        this.checkMatrix();
        this.matrixExp_.setDistanceTranspose(distance);
        this.matrixExp_.getTransitionProbabilities(store);
    }

    private static final void fromQToR(double[][] relativeRates, double[] equilibriumFrequencies, double[][] qMatrix, int dimension, boolean reversible) {
        if (reversible) {
            int i = 0;
            while (i < dimension) {
                int j = i + 1;
                while (j < dimension) {
                    qMatrix[i][j] = relativeRates[i][j] * equilibriumFrequencies[j];
                    qMatrix[j][i] = relativeRates[i][j] * equilibriumFrequencies[i];
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dimension) {
                int j = i + 1;
                while (j < dimension) {
                    qMatrix[i][j] = relativeRates[i][j] * equilibriumFrequencies[j];
                    qMatrix[j][i] = relativeRates[j][i] * equilibriumFrequencies[i];
                    ++j;
                }
                ++i;
            }
        }
    }

    private static final double makeValid(double[][] relativeRates, double[] equilibriumFrequencies, int dimension) {
        double total = 0.0;
        int i = 0;
        while (i < dimension) {
            double sum = 0.0;
            int j = 0;
            while (j < dimension) {
                if (i != j) {
                    sum += relativeRates[i][j];
                }
                ++j;
            }
            relativeRates[i][i] = -sum;
            total += equilibriumFrequencies[i] * sum;
            ++i;
        }
        return total;
    }

    private static final double calculateNormalScale(double[][] relativeRates, double[] equilibriumFrequencies, int dimension) {
        double scale = 0.0;
        int i = 0;
        while (i < dimension) {
            scale += -relativeRates[i][i] * equilibriumFrequencies[i];
            ++i;
        }
        return scale;
    }

    private static final void normalize(double[][] relativeRates, double[] equilibriumFrequencies, int dimension) {
        RateMatrixHandler.scale(relativeRates, dimension, RateMatrixHandler.calculateNormalScale(relativeRates, equilibriumFrequencies, dimension));
    }

    private static final void scale(double[][] relativeRates, int dimension, double scale) {
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                relativeRates[i][j] = relativeRates[i][j] / scale;
                ++j;
            }
            ++i;
        }
    }

    private static final void checkFrequencies(double[] frequencies, int dimension) {
        double MINFDIFF = 1.0E-10;
        double MINFREQ = 1.0E-10;
        int maxi = 0;
        double sum = 0.0;
        double maxfreq = 0.0;
        int i = 0;
        while (i < dimension) {
            double freq = frequencies[i];
            if (freq < 1.0E-10) {
                frequencies[i] = 1.0E-10;
            }
            if (freq > maxfreq) {
                maxfreq = freq;
                maxi = i;
            }
            sum += frequencies[i];
            ++i;
        }
        int n = maxi;
        frequencies[n] = frequencies[n] + (1.0 - sum);
        int i2 = 0;
        while (i2 < dimension - 1) {
            int j = i2 + 1;
            while (j < dimension) {
                if (frequencies[i2] == frequencies[j]) {
                    int n2 = i2;
                    frequencies[n2] = frequencies[n2] + 1.0E-10;
                    int n3 = j;
                    frequencies[n3] = frequencies[n3] - 1.0E-10;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void report(PrintWriter out) {
        out.println("Reporting Not functioning yet...");
    }

    private final void parametersChanged() {
        this.updateMatrix_ = true;
    }

    public int getNumParameters() {
        return this.parameters_.length;
    }

    public void setParameter(double param, int n) {
        this.parameters_[n] = param;
        this.parametersChanged();
    }

    public double getParameter(int n) {
        return this.parameters_[n];
    }

    public void setParameterSE(double paramSE, int n) {
        this.parametersSE_[n] = paramSE;
    }

    public double getLowerLimit(int n) {
        return this.rateMatrix_.getRateParameterLowerBound(n);
    }

    public double getUpperLimit(int n) {
        return this.rateMatrix_.getRateParameterUpperBound(n);
    }

    public double getDefaultValue(int n) {
        return this.defaultParameters_[n];
    }
}

