/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.datatype.CodonTable;
import pal.datatype.Codons;
import pal.datatype.DataType;
import pal.misc.MutableDouble;
import pal.misc.Utils;
import pal.substmodel.RateMatrixGroup;
import pal.substmodel.YangCodonModel;

public class PositiveSelectionRateMatrixGroup
implements RateMatrixGroup {
    private static final int NUMBER_OF_CATEGORIES = 3;
    private static final int NUMBER_OF_BASE_MATRIX_PARAMETERS = 2;
    private static final int PURIFYING_MATRIX_INDEX = 0;
    private static final int NEUTRAL_MATRIX_INDEX = 1;
    private static final int POSITIVE_MATRIX_INDEX = 2;
    private final YangCodonModel purifyingModel_;
    private final YangCodonModel neutralModel_;
    private final YangCodonModel positiveModel_;
    private final YangCodonModel[] allMatrices_;
    private final double[] freqs_;
    private final double[] purifyingParameters_;
    private final double[] neutralParameters_;
    private final double[] positiveParameters_;
    private final MutableDouble kappaStore_;
    private final MutableDouble omegaStore_;
    private static final long serialVersionUID = 4829485859252L;

    public PositiveSelectionRateMatrixGroup(MutableDouble kappaStore, MutableDouble omegaStore, double[] freqs, CodonTable table) {
        this.freqs_ = Utils.getCopy(freqs);
        this.kappaStore_ = kappaStore;
        this.omegaStore_ = omegaStore;
        this.purifyingModel_ = new YangCodonModel(0.0, kappaStore.getValue(), freqs, table);
        this.neutralModel_ = new YangCodonModel(1.0, kappaStore.getValue(), freqs, table);
        this.positiveModel_ = new YangCodonModel(omegaStore.getValue(), kappaStore.getValue(), freqs, table);
        this.neutralParameters_ = new double[2];
        this.positiveParameters_ = new double[2];
        this.purifyingParameters_ = new double[2];
        this.allMatrices_ = new YangCodonModel[3];
        this.allMatrices_[0] = this.purifyingModel_;
        this.allMatrices_[2] = this.positiveModel_;
        this.allMatrices_[1] = this.neutralModel_;
    }

    public int getNumberOfTransitionCategories() {
        return 3;
    }

    public void updateParameters(double[] categoryProbabilities) {
        double kappa = this.kappaStore_.getValue();
        double omega = this.omegaStore_.getValue();
        this.neutralParameters_[0] = this.positiveParameters_[0] = kappa;
        this.purifyingParameters_[0] = this.positiveParameters_[0];
        this.purifyingParameters_[1] = 0.0;
        this.neutralParameters_[1] = 1.0;
        this.positiveParameters_[1] = omega;
        double scale = categoryProbabilities[0] * this.purifyingModel_.setParametersNoScale(this.purifyingParameters_) + categoryProbabilities[1] * this.neutralModel_.setParametersNoScale(this.neutralParameters_) + categoryProbabilities[2] * this.positiveModel_.setParametersNoScale(this.positiveParameters_);
        this.neutralModel_.scale(scale);
        this.purifyingModel_.scale(scale);
        this.positiveModel_.scale(scale);
    }

    public double[] getEquilibriumFrequencies() {
        return this.freqs_;
    }

    public DataType getDataType() {
        return Codons.DEFAULT_INSTANCE;
    }

    public void getTransitionProbabilities(double branchLength, double[][][] tableStore) {
        int i = 0;
        while (i < 3) {
            this.allMatrices_[i].setDistance(branchLength);
            this.allMatrices_[i].getTransitionProbabilities(tableStore[i]);
            ++i;
        }
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] tableStore) {
        int i = 0;
        while (i < 3) {
            this.allMatrices_[i].setDistanceTranspose(branchLength);
            this.allMatrices_[i].getTransitionProbabilities(tableStore[i]);
            ++i;
        }
    }

    public void getTransitionProbabilities(double branchLength, int category, double[][] tableStore) {
        YangCodonModel rm = this.allMatrices_[category];
        rm.setDistance(branchLength);
        rm.getTransitionProbabilities(tableStore);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] tableStore) {
        YangCodonModel rm = this.allMatrices_[category];
        rm.setDistanceTranspose(branchLength);
        rm.getTransitionProbabilities(tableStore);
    }

    public String getSummary(double[] categoryProbabilities) {
        return "Positive Selection (kappa = " + this.kappaStore_.getValue() + ", omega = " + this.omegaStore_.getValue() + ", p0 = " + categoryProbabilities[0] + ", p1 =  " + categoryProbabilities[1] + ", p2 =  " + categoryProbabilities[2] + ")";
    }
}

