/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import pal.substmodel.NucleotideModel;
import pal.util.XMLConstants;

public class HKY
extends NucleotideModel
implements Serializable,
XMLConstants {
    public static final int KAPPA_PARAMETER_INDEX = 0;
    private boolean showSE;
    private double kappa;
    private double kappaSE;

    public HKY(double kappa, double[] freq) {
        super(freq);
        this.kappa = kappa;
        this.setParameters(new double[]{kappa});
        this.showSE = false;
    }

    public HKY(double[] params, double[] freq) {
        this(params[0], freq);
    }

    public Object clone() {
        return new HKY(this);
    }

    private HKY(HKY hky) {
        this(hky.kappa, hky.getEquilibriumFrequencies());
    }

    public int getModelID() {
        return 2;
    }

    public void report(PrintWriter out) {
        out.println("Model of substitution: HKY (Hasegawa et al. 1985)");
        out.print("Transition/transversion rate ratio kappa: ");
        this.format.displayDecimal(out, this.kappa, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.kappaSE, 2);
            out.print(")");
        }
        out.println();
        out.println();
        this.printFrequencies(out);
        this.printRatios(out);
    }

    public int getNumParameters() {
        return 1;
    }

    public void setParameterSE(double paramSE, int n) {
        this.kappaSE = paramSE;
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 1.0E-4;
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public double getDefaultValue(int n) {
        return 4.0;
    }

    public String getParameterName(int i) {
        if (i == 0) {
            return "kappa";
        }
        return "unknown";
    }

    public String getUniqueName() {
        return "HKY";
    }

    protected void rebuildRateMatrix(double[][] rate, double[] parameters) {
        this.kappa = parameters[0];
        rate[0][1] = 1.0;
        rate[0][2] = this.kappa;
        rate[0][3] = 1.0;
        rate[1][2] = 1.0;
        rate[1][3] = this.kappa;
        rate[2][3] = 1.0;
    }
}

