/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import pal.datatype.DataType;
import pal.math.OrthogonalHints;
import pal.misc.MultiParameterized;
import pal.misc.PalObjectListener;
import pal.misc.Parameterized;
import pal.substmodel.NeoRateMatrix;
import pal.substmodel.RateDistribution;
import pal.substmodel.RateMatrixHandler;
import pal.substmodel.SubstitutionModel;

public class GeneralRateDistributionSubstitutionModel
extends Parameterized.ParameterizedUser
implements SubstitutionModel {
    private RateMatrixHandler handler_;
    private RateDistribution rateDistribution_;
    private DataType dataType_;
    private MultiParameterized parameterization_;
    private int numberOfCategories_;
    private static final long serialVersionUID = 34127557628342342L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.handler_);
        out.writeObject(this.dataType_);
        out.writeObject(this.rateDistribution_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.handler_ = (RateMatrixHandler)in.readObject();
        this.dataType_ = (DataType)in.readObject();
        this.rateDistribution_ = (RateDistribution)in.readObject();
        this.setup();
    }

    private GeneralRateDistributionSubstitutionModel(GeneralRateDistributionSubstitutionModel toCopy) {
        this.handler_ = toCopy.handler_.getCopy();
        this.dataType_ = toCopy.dataType_;
        this.rateDistribution_ = (RateDistribution)toCopy.rateDistribution_.clone();
        this.setup();
    }

    public GeneralRateDistributionSubstitutionModel(NeoRateMatrix base, RateDistribution rateDistribution, DataType dt, double[] frequencies) {
        this.handler_ = new RateMatrixHandler(base, frequencies);
        this.dataType_ = dt;
        this.rateDistribution_ = rateDistribution;
        this.setup();
    }

    private final void setup() {
        this.parameterization_ = new MultiParameterized(this.handler_, this.rateDistribution_);
        this.numberOfCategories_ = this.rateDistribution_.getNumberOfRates();
        this.setParameterizedBase(this.parameterization_);
    }

    public double[] getMatrixParameters() {
        return this.parameterization_.getBaseParameters(this.handler_);
    }

    public double[] getRateDistributionParameters() {
        return this.parameterization_.getBaseParameters(this.rateDistribution_);
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public int getNumberOfTransitionCategories() {
        return this.rateDistribution_.getNumberOfRates();
    }

    public double getTransitionCategoryProbability(int category) {
        return this.rateDistribution_.getCategoryProbability(category);
    }

    public double[] getTransitionCategoryProbabilities() {
        return this.rateDistribution_.getCategoryProbabilities();
    }

    public double[] getEquilibriumFrequencies() {
        return this.handler_.getEquilibriumFrequencies();
    }

    public void getTransitionProbabilities(double branchLength, double[][][] store) {
        double[] rates = this.rateDistribution_.getRates();
        int i = 0;
        while (i < this.numberOfCategories_) {
            this.handler_.getTransitionProbabilities(branchLength * rates[i], store[i]);
            ++i;
        }
    }

    public void getTransitionProbabilities(double branchLength, int category, double[][] store) {
        this.handler_.getTransitionProbabilities(branchLength * this.rateDistribution_.getRate(category), store);
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, double[][][] store) {
        double[] rates = this.rateDistribution_.getRates();
        int i = 0;
        while (i < this.numberOfCategories_) {
            this.handler_.getTransitionProbabilitiesTranspose(branchLength * rates[i], store[i]);
            ++i;
        }
    }

    public void getTransitionProbabilitiesTranspose(double branchLength, int category, double[][] store) {
        this.handler_.getTransitionProbabilitiesTranspose(branchLength * this.rateDistribution_.getRate(category), store);
    }

    public void addPalObjectListener(PalObjectListener l) {
        throw new RuntimeException("Sorry, NeoRateMatrix stuff does not work with old likelihood calculators!");
    }

    public void removePalObjectListener(PalObjectListener l) {
        throw new RuntimeException("Sorry, NeoRateMatrix stuff does not work with old likelihood calculators!");
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }

    public void report(PrintWriter out) {
        this.handler_.report(out);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        this.report(pw);
        return "General Rate Distribution Substitution Model:\n" + sw.toString();
    }

    public Object clone() {
        return new GeneralRateDistributionSubstitutionModel(this);
    }

    public SubstitutionModel getCopy() {
        return new GeneralRateDistributionSubstitutionModel(this);
    }
}

