/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import pal.substmodel.NucleotideModel;
import pal.util.XMLConstants;

public class GTR
extends NucleotideModel
implements Serializable,
XMLConstants {
    private boolean showSE;
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double aSE;
    private double bSE;
    private double cSE;
    private double dSE;
    private double eSE;
    private static final long serialVersionUID = -8557884770092535699L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeBoolean(this.showSE);
        out.writeDouble(this.a);
        out.writeDouble(this.b);
        out.writeDouble(this.c);
        out.writeDouble(this.d);
        out.writeDouble(this.e);
        out.writeDouble(this.aSE);
        out.writeDouble(this.bSE);
        out.writeDouble(this.cSE);
        out.writeDouble(this.dSE);
        out.writeDouble(this.eSE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.showSE = in.readBoolean();
        this.a = in.readDouble();
        this.b = in.readDouble();
        this.c = in.readDouble();
        this.d = in.readDouble();
        this.e = in.readDouble();
        this.aSE = in.readDouble();
        this.bSE = in.readDouble();
        this.cSE = in.readDouble();
        this.dSE = in.readDouble();
        this.eSE = in.readDouble();
    }

    public GTR(double a, double b, double c, double d, double e, double[] freq) {
        super(freq);
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.setParameters(new double[]{a, b, c, d, e});
        this.showSE = false;
    }

    public GTR(double[] params, double[] freq) {
        this(params[0], params[1], params[2], params[3], params[4], freq);
    }

    public Object clone() {
        return new GTR(this);
    }

    private GTR(GTR gtr) {
        this(gtr.a, gtr.b, gtr.c, gtr.d, gtr.e, gtr.getEquilibriumFrequencies());
    }

    public int getModelID() {
        return 0;
    }

    public void report(PrintWriter out) {
        out.println("Model of substitution: GTR (Lanave et al. 1984)");
        out.print("Parameter a: ");
        this.format.displayDecimal(out, this.a, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.aSE, 2);
            out.print(")");
        }
        out.println();
        out.print("Parameter b: ");
        this.format.displayDecimal(out, this.b, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.bSE, 2);
            out.print(")");
        }
        out.println();
        out.print("Parameter c: ");
        this.format.displayDecimal(out, this.c, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.cSE, 2);
            out.print(")");
        }
        out.println();
        out.print("Parameter d: ");
        this.format.displayDecimal(out, this.d, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.dSE, 2);
            out.print(")");
        }
        out.println();
        out.print("Parameter e: ");
        this.format.displayDecimal(out, this.e, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.eSE, 2);
            out.print(")");
        }
        out.println();
        out.println("                                   A  C  G  T");
        out.println("Corresponding rate matrix      ----------------");
        out.println("(shown without frequencies):     A    a  b  c");
        out.println("                                 C       d  e");
        out.println("                                 G          1");
        out.println();
        this.printFrequencies(out);
        this.printRatios(out);
    }

    public int getNumParameters() {
        return 5;
    }

    public void setParameterSE(double paramSE, int n) {
        switch (n) {
            case 0: {
                this.aSE = paramSE;
                break;
            }
            case 1: {
                this.bSE = paramSE;
                break;
            }
            case 2: {
                this.cSE = paramSE;
                break;
            }
            case 3: {
                this.dSE = paramSE;
                break;
            }
            case 4: {
                this.eSE = paramSE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 1.0E-4;
    }

    public double getUpperLimit(int n) {
        return 10000.0;
    }

    public double getDefaultValue(int n) {
        return 1.0;
    }

    public String getUniqueName() {
        return "GTR";
    }

    public String getParameterName(int i) {
        switch (i) {
            case 0: {
                return "A-C";
            }
            case 1: {
                return "A-G";
            }
            case 2: {
                return "A-T";
            }
            case 3: {
                return "C-G";
            }
            case 4: {
                return "C-T";
            }
        }
        return "unknown";
    }

    protected void rebuildRateMatrix(double[][] rate, double[] parameters) {
        this.a = parameters[0];
        this.b = parameters[1];
        this.c = parameters[2];
        this.d = parameters[3];
        this.e = parameters[4];
        rate[0][1] = this.a;
        rate[0][2] = this.b;
        rate[0][3] = this.c;
        rate[1][2] = this.d;
        rate[1][3] = this.e;
        rate[2][3] = 1.0;
    }
}

