/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import pal.substmodel.NucleotideModel;
import pal.util.XMLConstants;

public class F84
extends NucleotideModel
implements Serializable,
XMLConstants {
    public static final int EXPECTED_TS_TV_PARAMETER_INDEX = 0;
    private boolean showSE;
    private double kappa;
    private double r;
    private double expectedTsTv;
    private double expectedTsTvSE;

    public F84(double expectedTsTv, double[] freq) {
        super(freq);
        this.expectedTsTv = expectedTsTv;
        this.setParameters(new double[]{expectedTsTv});
        this.convertToTN();
        this.showSE = false;
    }

    public F84(double[] params, double[] freq) {
        this(params[0], freq);
    }

    public int getModelID() {
        return 3;
    }

    public void report(PrintWriter out) {
        out.println("Model of substitution: F84 (Felsenstein 1984, PHYLIP)");
        out.print("PHYLIP Transition/transversion parameter: ");
        this.format.displayDecimal(out, this.expectedTsTv, 2);
        if (this.showSE) {
            out.print("  (S.E. ");
            this.format.displayDecimal(out, this.expectedTsTvSE, 2);
            out.print(")");
        }
        out.println();
        out.println();
        this.printFrequencies(out);
        this.printRatios(out);
        out.println();
        out.println("This model corresponds to a Tamura-Nei (1993) model with");
        out.print(" Transition/transversion rate ratio kappa: ");
        this.format.displayDecimal(out, this.kappa, 2);
        out.println();
        out.print(" Y/R transition rate ratio: ");
        this.format.displayDecimal(out, this.r, 2);
        out.println();
        out.println("and the above nucleotide frequencies.");
        out.println();
    }

    public int getNumParameters() {
        return 1;
    }

    public void setParameterSE(double paramSE, int n) {
        this.expectedTsTvSE = paramSE;
        this.showSE = true;
    }

    public double getLowerLimit(int n) {
        return 1.0E-4;
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public double getDefaultValue(int n) {
        return 2.0;
    }

    public String getUniqueName() {
        return "F84";
    }

    public String getParameterName(int i) {
        switch (i) {
            case 0: {
                return "transition/transversion ratio";
            }
        }
        return "unknown";
    }

    private void convertToTN() {
        double[] frequency = this.getEquilibriumFrequencies();
        double piA = frequency[0];
        double piC = frequency[1];
        double piG = frequency[2];
        double piT = frequency[3];
        double piR = piA + piG;
        double piY = piC + piT;
        double rho = piR * piY * (piR * piY * this.expectedTsTv - (piA * piG + piC * piT)) / (piC * piT * piR + piA * piG * piY);
        this.kappa = 1.0 + 0.5 * rho * (1.0 / piR + 1.0 / piY);
        this.r = (piY + rho) / piY * piR / (piR + rho);
    }

    protected void rebuildRateMatrix(double[][] rate, double[] parameters) {
        this.expectedTsTv = parameters[0];
        this.convertToTN();
        rate[0][1] = 1.0;
        rate[0][2] = 2.0 * this.kappa / (this.r + 1.0);
        rate[0][3] = 1.0;
        rate[1][2] = 1.0;
        rate[1][3] = 2.0 * this.kappa * this.r / (this.r + 1.0);
        rate[2][3] = 1.0;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.report(new PrintWriter(sw));
        return sw.toString();
    }
}

