/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import pal.misc.Utils;
import pal.substmodel.SingleSplitDistribution;

public class ConstantIndependentSingleSplitDistribution
implements SingleSplitDistribution {
    private final double[][] probabilityStore_;
    private final double[] parameterStore_;
    private final double[] normalisedParameterStore_;
    private final int numberOfBaseTransitionCategories_;
    private static final double PARAMETER_BASE = 1.0E-8;
    private static final double PARAMETER_MINIMUM = 1.0E-8;
    private static final double PARAMETER_DEFAULT = 0.50000001;
    private static final double PARAMETER_MAXIMUM = 1.00000001;

    public ConstantIndependentSingleSplitDistribution(int numberOfBaseTransitionCategories) {
        this(numberOfBaseTransitionCategories, null);
    }

    public ConstantIndependentSingleSplitDistribution(int numberOfBaseTransitionCategories, double[] initialParameters) {
        this.numberOfBaseTransitionCategories_ = numberOfBaseTransitionCategories;
        this.probabilityStore_ = new double[numberOfBaseTransitionCategories][numberOfBaseTransitionCategories];
        this.parameterStore_ = new double[numberOfBaseTransitionCategories];
        this.normalisedParameterStore_ = new double[numberOfBaseTransitionCategories];
        if (initialParameters == null) {
            int i = 0;
            while (i < this.parameterStore_.length) {
                this.parameterStore_[i] = 0.50000001;
                ++i;
            }
        } else if (initialParameters.length == numberOfBaseTransitionCategories) {
            int i = 0;
            while (i < numberOfBaseTransitionCategories) {
                this.parameterStore_[i] = initialParameters[i];
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Cannot handle " + initialParameters.length + " initial parameters");
        }
        ConstantIndependentSingleSplitDistribution.correctParameters(this.parameterStore_);
        this.updateProbabilityStore();
        System.out.println("Constant Independent probability model created:" + this);
    }

    public double[] getDistribution() {
        double[] distribution = new double[this.numberOfBaseTransitionCategories_ * this.numberOfBaseTransitionCategories_];
        int i = 0;
        while (i < distribution.length) {
            int a = i % this.numberOfBaseTransitionCategories_;
            int b = i / this.numberOfBaseTransitionCategories_;
            distribution[i] = this.normalisedParameterStore_[a] * this.normalisedParameterStore_[b];
            ++i;
        }
        return distribution;
    }

    public int getNumberOfBaseTransitionCategories() {
        return this.numberOfBaseTransitionCategories_;
    }

    public double[][] getDistributionInfo() {
        return this.probabilityStore_;
    }

    private final void updateProbabilityStore() {
        double total = 0.0;
        int i = 0;
        while (i < this.parameterStore_.length) {
            total += this.parameterStore_[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.normalisedParameterStore_.length) {
            this.normalisedParameterStore_[i2] = this.parameterStore_[i2] / total;
            ++i2;
        }
        boolean parameterIndex = false;
        int before = 0;
        while (before < this.numberOfBaseTransitionCategories_) {
            int after = 0;
            while (after < this.numberOfBaseTransitionCategories_) {
                this.probabilityStore_[before][after] = this.normalisedParameterStore_[before] * this.normalisedParameterStore_[after];
                ++after;
            }
            ++before;
        }
    }

    public int getNumberOfParameters() {
        return this.numberOfBaseTransitionCategories_;
    }

    public void setParameters(double[] store, int startIndex) {
        System.arraycopy(store, startIndex, this.parameterStore_, 0, this.parameterStore_.length);
        this.updateProbabilityStore();
    }

    public void getParameters(double[] store, int startIndex) {
        System.arraycopy(this.parameterStore_, 0, store, startIndex, this.parameterStore_.length);
    }

    public double getLowerLimit(int n) {
        return 1.0E-8;
    }

    public double getUpperLimit(int n) {
        return 1.00000001;
    }

    private static final void correctParameters(double[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            double p = parameters[i] + 1.0E-8;
            if (p < 1.0E-8) {
                p = 1.0E-8;
            } else if (p > 1.00000001) {
                p = 1.00000001;
            }
            parameters[i] = p;
            ++i;
        }
    }

    public void getDefaultValues(double[] store, int startIndex) {
        int i = 0;
        while (i < this.parameterStore_.length) {
            store[i + startIndex] = 0.50000001;
            ++i;
        }
    }

    public String toString() {
        return "Constant Independent(" + Utils.toString(this.parameterStore_) + " - > " + Utils.toString(this.getDistribution()) + ")";
    }
}

