/*
 * Decompiled with CFR 0.152.
 */
package pal.substmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import pal.datatype.DataType;
import pal.io.FormattedOutput;
import pal.math.OrthogonalHints;
import pal.misc.ExternalParameterListener;
import pal.misc.PalEventMulticaster;
import pal.misc.PalObjectEvent;
import pal.misc.PalObjectListener;
import pal.misc.ParameterEvent;
import pal.substmodel.MatrixExponential;
import pal.substmodel.RateMatrix;

public abstract class AbstractRateMatrix
implements RateMatrix,
ExternalParameterListener {
    private int dimension;
    private double[] frequency;
    private double[][] rate;
    private DataType dataType;
    protected FormattedOutput format = FormattedOutput.getInstance();
    private transient MatrixExponential matrixExp_;
    private transient PalObjectListener listeners_ = null;
    private transient PalObjectEvent defaultPalEvent_ = null;
    private transient boolean rebuildModel_ = false;
    private double[] parameterStore_ = null;
    private static final long serialVersionUID = 7726654175983028192L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(4);
        out.writeObject(this.frequency);
        out.writeObject(this.rate);
        out.writeObject(this.dataType);
        out.writeObject(this.parameterStore_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.frequency = (double[])in.readObject();
                this.dimension = this.frequency.length;
                this.rate = (double[][])in.readObject();
                this.dataType = (DataType)in.readObject();
                this.matrixExp_ = (MatrixExponential)in.readObject();
                this.format = FormattedOutput.getInstance();
                this.rebuildModel_ = true;
                this.parameterStore_ = null;
                break;
            }
            case 2: 
            case 3: {
                this.frequency = (double[])in.readObject();
                this.dimension = this.frequency.length;
                this.rate = (double[][])in.readObject();
                this.dataType = (DataType)in.readObject();
                this.matrixExp_ = null;
                this.format = FormattedOutput.getInstance();
                this.rebuildModel_ = true;
                this.parameterStore_ = null;
                break;
            }
            default: {
                if (version != 4) {
                    System.err.println("Warning: unknown matrix version:" + version);
                }
                this.frequency = (double[])in.readObject();
                this.dimension = this.frequency.length;
                this.rate = (double[][])in.readObject();
                this.dataType = (DataType)in.readObject();
                this.matrixExp_ = null;
                this.format = FormattedOutput.getInstance();
                this.rebuildModel_ = true;
                this.parameterStore_ = (double[])in.readObject();
            }
        }
    }

    protected AbstractRateMatrix(int dim) {
        this.dimension = dim;
        this.frequency = new double[dim];
        this.rate = new double[dim][dim];
        this.scheduleRebuild();
    }

    private final void scheduleRebuild() {
        this.rebuildModel_ = true;
    }

    public int getTypeID() {
        return this.dataType.getTypeID();
    }

    public abstract int getModelID();

    public int getDimension() {
        return this.dimension;
    }

    public double[] getEquilibriumFrequencies() {
        return this.frequency;
    }

    public double getEquilibriumFrequency(int i) {
        return this.frequency[i];
    }

    public DataType getDataType() {
        return this.dataType;
    }

    protected final void setDataType(DataType dt) {
        this.dataType = dt;
    }

    public double[][] getRelativeRates() {
        return this.rate;
    }

    public double getTransitionProbability(int fromState, int toState) {
        return this.matrixExp_.getTransitionProbability(fromState, toState);
    }

    private final void handleRebuild() {
        if (this.matrixExp_ == null) {
            this.matrixExp_ = new MatrixExponential(this);
        }
        if (this.rebuildModel_) {
            this.checkParameters();
            this.rebuildRateMatrix(this.rate, this.parameterStore_);
            this.fromQToR();
        }
    }

    public final void rebuild() {
    }

    public final void setDistance(double distance) {
        this.handleRebuild();
        this.matrixExp_.setDistance(distance);
    }

    public final void setDistanceTranspose(double distance) {
        this.handleRebuild();
        this.matrixExp_.setDistanceTranspose(distance);
    }

    public final void getTransitionProbabilities(double[][] probabilityStore) {
        this.matrixExp_.getTransitionProbabilities(probabilityStore);
    }

    private static final void cleanup(double[][] tableStore, int numberOfStates) {
        int i = 0;
        while (i < numberOfStates) {
            int j = 0;
            while (j < numberOfStates) {
                if (Double.isNaN(tableStore[i][j])) {
                    tableStore[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public void scale(double scale) {
        this.normalize(scale);
        this.updateMatrixExp();
        this.fireParametersChangedEvent();
    }

    protected void printFrequencies(PrintWriter out) {
        int i = 0;
        while (i < this.dimension) {
            out.print("pi(" + this.dataType.getChar(i) + ") = ");
            this.format.displayDecimal(out, this.frequency[i], 5);
            out.println();
            ++i;
        }
        out.println();
    }

    protected void setFrequencies(double[] f) {
        int i = 0;
        while (i < this.dimension) {
            this.frequency[i] = f[i];
            ++i;
        }
        this.checkFrequencies();
        this.scheduleRebuild();
    }

    public double setParametersNoScale(double[] parameters) {
        this.rebuildRateMatrix(this.rate, parameters);
        double result = this.incompleteFromQToR();
        this.rebuildModel_ = false;
        return result;
    }

    public void setParameters(double[] parameters) {
        this.checkParameters();
        System.arraycopy(parameters, 0, this.parameterStore_, 0, this.getNumParameters());
        this.scheduleRebuild();
    }

    private void fromQToR() {
        int i = 0;
        while (i < this.dimension) {
            int j = i + 1;
            while (j < this.dimension) {
                double q = this.rate[i][j];
                this.rate[i][j] = q * this.frequency[j];
                this.rate[j][i] = q * this.frequency[i];
                ++j;
            }
            ++i;
        }
        this.makeValid();
        this.normalize();
        this.updateMatrixExp();
        this.fireParametersChangedEvent();
    }

    private double incompleteFromQToR() {
        int i = 0;
        while (i < this.dimension) {
            int j = i + 1;
            while (j < this.dimension) {
                double q = this.rate[i][j];
                this.rate[i][j] = q * this.frequency[j];
                this.rate[j][i] = q * this.frequency[i];
                ++j;
            }
            ++i;
        }
        return this.makeValid();
    }

    private void finishFromQToR(double substitutionScale) {
        this.normalize(substitutionScale);
        this.updateMatrixExp();
        this.fireParametersChangedEvent();
    }

    private final void checkParameters() {
        if (this.parameterStore_ == null) {
            this.parameterStore_ = new double[this.getNumParameters()];
            int i = 0;
            while (i < this.parameterStore_.length) {
                this.parameterStore_[i] = this.getDefaultValue(i);
                ++i;
            }
        }
    }

    public final void setParameter(double value, int parameter) {
        this.checkParameters();
        this.parameterStore_[parameter] = value;
        this.scheduleRebuild();
    }

    public final double getParameter(int parameter) {
        this.checkParameters();
        return this.parameterStore_[parameter];
    }

    protected abstract void rebuildRateMatrix(double[][] var1, double[] var2);

    public void addPalObjectListener(PalObjectListener pol) {
        this.listeners_ = PalEventMulticaster.add(this.listeners_, pol);
    }

    public void removePalObjectListener(PalObjectListener pol) {
        this.listeners_ = PalEventMulticaster.remove(this.listeners_, pol);
    }

    protected void fireParametersChangedEvent() {
        if (this.listeners_ != null) {
            if (this.defaultPalEvent_ == null) {
                this.defaultPalEvent_ = new PalObjectEvent(this);
            }
            this.listeners_.parametersChanged(this.defaultPalEvent_);
        }
    }

    protected void fireParametersChangedEvent(PalObjectEvent pe) {
        if (this.listeners_ != null) {
            this.listeners_.parametersChanged(pe);
        }
    }

    protected void updateMatrixExp() {
        if (this.matrixExp_ == null) {
            this.matrixExp_ = new MatrixExponential(this);
        } else {
            this.matrixExp_.setMatrix(this);
        }
    }

    private double makeValid() {
        double total = 0.0;
        int i = 0;
        while (i < this.dimension) {
            double sum = 0.0;
            int j = 0;
            while (j < this.dimension) {
                if (i != j) {
                    sum += this.rate[i][j];
                }
                ++j;
            }
            this.rate[i][i] = -sum;
            total += this.frequency[i] * sum;
            ++i;
        }
        return total;
    }

    private void normalize() {
        double subst = 0.0;
        int i = 0;
        while (i < this.dimension) {
            subst += -this.rate[i][i] * this.frequency[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.dimension) {
            int j = 0;
            while (j < this.dimension) {
                this.rate[i2][j] = this.rate[i2][j] / subst;
                ++j;
            }
            ++i2;
        }
    }

    private void normalize(double substitutionScale) {
        int i = 0;
        while (i < this.dimension) {
            int j = 0;
            while (j < this.dimension) {
                this.rate[i][j] = this.rate[i][j] / substitutionScale;
                ++j;
            }
            ++i;
        }
    }

    private void checkFrequencies() {
        double MINFDIFF = 1.0E-10;
        double MINFREQ = 1.0E-10;
        int maxi = 0;
        double sum = 0.0;
        double maxfreq = 0.0;
        int i = 0;
        while (i < this.dimension) {
            double freq = this.frequency[i];
            if (freq < MINFREQ) {
                this.frequency[i] = MINFREQ;
            }
            if (freq > maxfreq) {
                maxfreq = freq;
                maxi = i;
            }
            sum += this.frequency[i];
            ++i;
        }
        int n = maxi;
        this.frequency[n] = this.frequency[n] + (1.0 - sum);
        int i2 = 0;
        while (i2 < this.dimension - 1) {
            int j = i2 + 1;
            while (j < this.dimension) {
                if (this.frequency[i2] == this.frequency[j]) {
                    int n2 = i2;
                    this.frequency[n2] = this.frequency[n2] + MINFDIFF;
                    int n3 = j;
                    this.frequency[n3] = this.frequency[n3] - MINFDIFF;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void parameterChanged(ParameterEvent pe) {
        this.scheduleRebuild();
        this.fireParametersChangedEvent();
    }

    public Object clone() {
        try {
            RateMatrix matrix = (RateMatrix)super.clone();
            if (matrix instanceof AbstractRateMatrix) {
                ((AbstractRateMatrix)matrix).listeners_ = null;
            }
            return matrix;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }

    protected final double[] getFrequencies() {
        return this.frequency;
    }
}

