/*
 * Decompiled with CFR 0.152.
 */
package pal.statistics;

import pal.alignment.Alignment;
import pal.substmodel.SubstitutionModel;
import pal.tree.Tree;
import pal.treesearch.UnrootedMLSearcher;

public interface ReplicateLikelihoodEvaluator {
    public double getReplicateLogLikelihood(Tree var1, Alignment var2);

    public static final class Utils {
        public static final ReplicateLikelihoodEvaluator createRELLEvaluator(SubstitutionModel model) {
            return new RELLEvaluator(model);
        }

        private static final class RELLEvaluator
        implements ReplicateLikelihoodEvaluator {
            private final SubstitutionModel model_;

            public RELLEvaluator(SubstitutionModel model) {
                this.model_ = model;
            }

            public double getReplicateLogLikelihood(Tree tree, Alignment alignment) {
                UnrootedMLSearcher searcher = new UnrootedMLSearcher(tree, alignment, this.model_);
                return searcher.calculateLogLikelihood();
            }
        }
    }
}

