/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pal.math.MersenneTwisterFast;
import pal.misc.BranchLimits;
import pal.misc.IdGenerator;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;
import pal.misc.UnitsProvider;
import pal.misc.Utils;
import pal.util.HeapSort;

public class TimeOrderCharacterData
implements Serializable,
BranchLimits,
UnitsProvider,
IdGroup {
    protected int[] timeOrdinals = null;
    protected double[] times = null;
    protected IdGroup taxa;
    protected int units = 1;
    protected SubgroupHandler[] subgroups_;
    private String name = "Time/order character data";
    private static final long serialVersionUID = 7672390862755080486L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(2);
        out.writeObject(this.timeOrdinals);
        out.writeObject(this.times);
        out.writeObject(this.taxa);
        out.writeInt(this.units);
        out.writeObject(this.name);
        out.writeObject(this.subgroups_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 1: {
                this.timeOrdinals = (int[])in.readObject();
                this.times = (double[])in.readObject();
                this.taxa = (IdGroup)in.readObject();
                this.units = in.readInt();
                this.name = (String)in.readObject();
                break;
            }
            default: {
                this.timeOrdinals = (int[])in.readObject();
                this.times = (double[])in.readObject();
                this.taxa = (IdGroup)in.readObject();
                this.units = in.readInt();
                this.name = (String)in.readObject();
                this.subgroups_ = (SubgroupHandler[])in.readObject();
            }
        }
    }

    protected TimeOrderCharacterData() {
    }

    private TimeOrderCharacterData(TimeOrderCharacterData toCopy, IdGroup base) {
        int size = toCopy.getIdCount();
        this.timeOrdinals = new int[size];
        boolean hasTimes = toCopy.hasTimes();
        this.times = hasTimes ? new double[size] : null;
        int i = 0;
        while (i < size) {
            String name = toCopy.getIdentifier(i).getName();
            int baseLocation = base.whichIdNumber(name);
            if (baseLocation < 0) {
                throw new IllegalArgumentException("Base does not contain:" + name);
            }
            this.timeOrdinals[baseLocation] = toCopy.timeOrdinals[i];
            if (hasTimes) {
                this.times[baseLocation] = toCopy.times[i];
            }
            ++i;
        }
        this.subgroups_ = SubgroupHandler.getCopy(toCopy.subgroups_, toCopy, base);
        this.units = toCopy.units;
        this.taxa = new SimpleIdGroup(base);
    }

    public TimeOrderCharacterData(IdGroup taxa, int units) {
        this(taxa, units, false);
    }

    public TimeOrderCharacterData(IdGroup taxa, int units, boolean contemp) {
        this.taxa = taxa;
        this.units = units;
        if (contemp) {
            double[] times = new double[taxa.getIdCount()];
            this.setTimes(times, units);
        }
    }

    public TimeOrderCharacterData(int numSeqsPerSample, int numSamples, double timeBetweenSamples, int units) {
        int n = numSeqsPerSample * numSamples;
        this.taxa = IdGenerator.createIdGroup(n);
        this.timeOrdinals = new int[this.taxa.getIdCount()];
        this.times = new double[this.taxa.getIdCount()];
        int index = 0;
        int i = 0;
        while (i < numSamples) {
            int j = 0;
            while (j < numSeqsPerSample) {
                this.times[index] = timeBetweenSamples * (double)i;
                this.timeOrdinals[index] = i;
                ++index;
                ++j;
            }
            ++i;
        }
        this.units = units;
    }

    public static TimeOrderCharacterData clone(TimeOrderCharacterData tocd) {
        return tocd.subset(tocd);
    }

    public TimeOrderCharacterData subset(IdGroup staxa) {
        TimeOrderCharacterData subset = new TimeOrderCharacterData(staxa, this.getUnits());
        subset.timeOrdinals = new int[staxa.getIdCount()];
        if (this.hasTimes()) {
            subset.times = new double[staxa.getIdCount()];
        }
        int i = 0;
        while (i < subset.timeOrdinals.length) {
            int index = this.taxa.whichIdNumber(staxa.getIdentifier(i).getName());
            subset.timeOrdinals[i] = this.timeOrdinals[index];
            if (this.hasTimes()) {
                subset.times[i] = this.times[index];
            }
            ++i;
        }
        return subset;
    }

    public int getUnits() {
        return this.units;
    }

    public final void setSubgroups(int[][] subgroups) {
        this.subgroups_ = SubgroupHandler.create(subgroups);
    }

    public final void setSubgroup(int[] subgroup) {
        this.subgroups_ = SubgroupHandler.create(subgroup);
    }

    public final void setSubgroup(String[] subgroup) {
        this.subgroups_ = SubgroupHandler.create(this, subgroup);
    }

    public final void setSubgroups(String[][] subgroups) {
        this.subgroups_ = SubgroupHandler.create(this, subgroups);
    }

    public final boolean hasSubgroups() {
        return this.subgroups_ != null;
    }

    public final int getNumberOfSubgroups() {
        return this.subgroups_ == null ? 0 : this.subgroups_.length;
    }

    public final TimeOrderCharacterData createSubgroup(int subgroupNumber) {
        return this.subgroups_[subgroupNumber].generateNewTOCD(this);
    }

    public final Identifier[] getSubgroupMembers(int subgroupNumber) {
        return this.subgroups_[subgroupNumber].getSubgroupMembers(this);
    }

    public void setTimes(double[] times, int units) {
        this.setTimes(times, units, true);
    }

    public void setTimes(double[] times, int units, boolean recalculateOrdinals) {
        this.times = times;
        this.units = units;
        if (recalculateOrdinals) {
            this.setOrdinalsFromTimes();
        }
    }

    public TimeOrderCharacterData scale(double rate, int newUnits) {
        TimeOrderCharacterData scaled = TimeOrderCharacterData.clone(this);
        scaled.units = newUnits;
        int i = 0;
        while (i < this.times.length) {
            scaled.times[i] = this.times[i] * rate;
            ++i;
        }
        return scaled;
    }

    public void setOrdinals(int[] ordinals) {
        this.timeOrdinals = ordinals;
    }

    public double getMaximumTime() {
        if (this.times == null) {
            throw new RuntimeException("Error: getMaximumTime() called with no times");
        }
        double max = this.times[0];
        int i = 1;
        while (i < this.times.length) {
            if (this.times[i] > max) {
                max = this.times[i];
            }
            ++i;
        }
        return max;
    }

    public double getMinimumTime() {
        if (this.times == null) {
            throw new RuntimeException("Error: getMinimumTime() called with no times");
        }
        double min = this.times[0];
        int i = 1;
        while (i < this.times.length) {
            if (this.times[i] < min) {
                min = this.times[i];
            }
            ++i;
        }
        return min;
    }

    public int[] getOrdinals() {
        return this.timeOrdinals;
    }

    public double[] getCopyOfTimes() {
        double[] copyTimes = new double[this.times.length];
        System.arraycopy(this.times, 0, copyTimes, 0, this.times.length);
        return copyTimes;
    }

    public TimeOrderCharacterData getReordered(IdGroup base) {
        return new TimeOrderCharacterData(this, base);
    }

    public void removeTimes() {
        this.times = null;
    }

    public TimeOrderCharacterData generateExpectedSubsitutionsTimedTOCD(double[] sampleRates) {
        TimeOrderCharacterData result = new TimeOrderCharacterData((IdGroup)this, 0);
        double[] times = new double[this.getIdCount()];
        int i = 0;
        while (i < times.length) {
            int sample = this.getTimeOrdinal(i);
            double total = 0.0;
            int es = 0;
            while (es < sample) {
                total += sampleRates[es];
                ++es;
            }
            times[i] = total;
            ++i;
        }
        result.setTimes(times, 0);
        return result;
    }

    public TimeOrderCharacterData generateDummyTimedTOCD(double[] sampleRates) {
        TimeOrderCharacterData dummy = new TimeOrderCharacterData((IdGroup)this, 0);
        double[] times = new double[this.getIdCount()];
        int i = 0;
        while (i < times.length) {
            times[i] = this.getTimeOrdinal(i);
            ++i;
        }
        dummy.setTimes(times, 6);
        return dummy;
    }

    public void setOrdinals(TimeOrderCharacterData tocd) {
        this.setOrdinals(tocd, null, false);
    }

    public void setTimesAndOrdinals(TimeOrderCharacterData tocd) {
        this.setOrdinals(tocd, null, true);
    }

    public void setOrdinals(TimeOrderCharacterData tocd, IdGroup standard, boolean doTimes) {
        if (this.timeOrdinals == null) {
            this.timeOrdinals = new int[this.taxa.getIdCount()];
        }
        if (doTimes && tocd.hasTimes()) {
            this.times = new double[this.taxa.getIdCount()];
        }
        if (standard == null) {
            standard = tocd;
        }
        int i = 0;
        while (i < this.taxa.getIdCount()) {
            String name = this.taxa.getIdentifier(i).getName();
            int index = standard.whichIdNumber(name);
            if (index == -1) {
                System.err.println("Identifiers don't match!");
                System.err.println("Trying to find: '" + name + "' in:");
                System.err.println(standard);
            }
            this.timeOrdinals[i] = tocd.getTimeOrdinal(index);
            if (doTimes && tocd.hasTimes()) {
                this.times[i] = tocd.getTime(index);
            }
            ++i;
        }
    }

    private final boolean equal(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    private void setOrdinalsFromTimes() {
        int[] indices = new int[this.times.length];
        this.timeOrdinals = new int[this.times.length];
        HeapSort.sort(this.times, indices);
        int ordinal = 0;
        int lastIndex = 0;
        this.timeOrdinals[indices[0]] = ordinal;
        int i = 1;
        while (i < indices.length) {
            if (!(Math.abs(this.times[indices[i]] - this.times[indices[lastIndex]]) <= 5.0E-7)) {
                lastIndex = i;
            }
            this.timeOrdinals[indices[i]] = ++ordinal;
            ++i;
        }
    }

    public int getNumChars() {
        if (this.hasTimes()) {
            return 2;
        }
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getTime(int taxon) {
        return this.times[taxon];
    }

    public double getOrdinalTime(int ordinal) {
        int i = 0;
        while (i < this.timeOrdinals.length) {
            if (this.timeOrdinals[i] == ordinal) {
                return this.times[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown ordinal");
    }

    public double getTime(String taxonName) {
        int i = this.whichIdNumber(taxonName);
        return this.times[i];
    }

    public double getHeight(int taxon, double rate) {
        return this.times[taxon] * rate;
    }

    public int getTimeOrdinal(int taxon) {
        return this.timeOrdinals[taxon];
    }

    public int getTimeOrdinal(String taxonName) {
        int i = this.whichIdNumber(taxonName);
        return this.timeOrdinals[i];
    }

    public int getTimeOrdinal(Identifier taxonName) {
        int i = this.whichIdNumber(taxonName.getName());
        return this.timeOrdinals[i];
    }

    public boolean hasTimes() {
        return this.times != null;
    }

    public double[] getUniqueTimeArray() {
        int count = this.getSampleCount();
        double[] utimes = new double[count];
        int i = 0;
        while (i < this.times.length) {
            utimes[this.getTimeOrdinal((int)i)] = this.times[i];
            ++i;
        }
        return utimes;
    }

    public double[][] getUniqueTimeMatrix() {
        double[] utimes = this.getUniqueTimeArray();
        int count = utimes.length;
        double[][] stimes = new double[count][count];
        int i = 0;
        while (i < count) {
            int j = 0;
            while (j < count) {
                stimes[i][j] = Math.abs(utimes[i] - utimes[j]);
                ++j;
            }
            ++i;
        }
        return stimes;
    }

    public int getSampleCount() {
        return this.getOrdinalCount();
    }

    public int getOrdinalCount() {
        int max = 0;
        int i = 0;
        while (i < this.timeOrdinals.length) {
            if (this.timeOrdinals[i] > max) {
                max = this.timeOrdinals[i];
            }
            ++i;
        }
        return max + 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Identifier\t" + (this.hasTimes() ? "Times\t" : "") + "Sample\n");
        int i = 0;
        while (i < this.taxa.getIdCount()) {
            sb.append(this.taxa.getIdentifier(i) + "\t" + (this.hasTimes() ? this.getTime(i) + "\t" : "") + this.getTimeOrdinal(i) + "\n");
            ++i;
        }
        return new String(sb);
    }

    public void shuffleTimes() {
        MersenneTwisterFast mtf = new MersenneTwisterFast();
        int[] indices = mtf.shuffled(this.timeOrdinals.length);
        int[] newOrdinals = new int[this.timeOrdinals.length];
        double[] newTimes = null;
        if (this.hasTimes()) {
            newTimes = new double[this.times.length];
        }
        int i = 0;
        while (i < this.timeOrdinals.length) {
            newOrdinals[i] = this.timeOrdinals[indices[i]];
            if (this.hasTimes()) {
                newTimes[i] = this.times[indices[i]];
            }
            ++i;
        }
        this.timeOrdinals = newOrdinals;
        if (this.hasTimes()) {
            this.times = newTimes;
        }
    }

    public Identifier getIdentifier(int i) {
        return this.taxa.getIdentifier(i);
    }

    public void setIdentifier(int i, Identifier ident) {
        this.taxa.setIdentifier(i, ident);
    }

    public int getIdCount() {
        return this.taxa.getIdCount();
    }

    public int whichIdNumber(String name) {
        return this.taxa.whichIdNumber(name);
    }

    public IdGroup getIdGroup() {
        return this.taxa;
    }

    public final double getSuggestedMaximumMutationRate() {
        double[] times = this.getUniqueTimeArray();
        double minDiff = times[1] - times[0];
        int i = 2;
        while (i < times.length) {
            double diff = times[i] - times[i - 1];
            if (diff < minDiff) {
                minDiff = diff;
            }
            ++i;
        }
        return 5.0 / minDiff;
    }

    private static final class SubgroupHandler
    implements Serializable {
        private int[] subgroupIndexes_;
        private static final long serialVersionUID = 341384756632221L;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeByte(1);
            out.writeObject(this.subgroupIndexes_);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                default: 
            }
            this.subgroupIndexes_ = (int[])in.readObject();
        }

        private SubgroupHandler(int[] subgroupIndexes) {
            this.subgroupIndexes_ = Utils.getCopy(subgroupIndexes);
        }

        private SubgroupHandler(SubgroupHandler toCopy, IdGroup oldBase, IdGroup newBase) {
            this(toCopy.subgroupIndexes_, oldBase, newBase);
        }

        private SubgroupHandler(int[] oldSubgroupIndexes, IdGroup oldBase, IdGroup newBase) {
            this.subgroupIndexes_ = new int[oldSubgroupIndexes.length];
            int i = 0;
            while (i < oldSubgroupIndexes.length) {
                String oldName = oldBase.getIdentifier(oldSubgroupIndexes[i]).getName();
                int newIndex = newBase.whichIdNumber(oldName);
                if (newIndex < 0) {
                    throw new IllegalArgumentException("Incompatible bases:" + oldName);
                }
                this.subgroupIndexes_[i] = newIndex;
                ++i;
            }
        }

        public Identifier[] getSubgroupMembers(TimeOrderCharacterData parent) {
            int size = this.subgroupIndexes_.length;
            Identifier[] ids = new Identifier[size];
            int i = 0;
            while (i < size) {
                ids[i] = parent.getIdentifier(this.subgroupIndexes_[i]);
                ++i;
            }
            return ids;
        }

        public TimeOrderCharacterData generateNewTOCD(TimeOrderCharacterData parent) {
            int size = this.subgroupIndexes_.length;
            Identifier[] ids = new Identifier[size];
            int i = 0;
            while (i < size) {
                ids[i] = parent.getIdentifier(this.subgroupIndexes_[i]);
                ++i;
            }
            TimeOrderCharacterData tocd = new TimeOrderCharacterData(new SimpleIdGroup(ids), parent.getUnits());
            if (parent.hasTimes()) {
                double[] times = new double[size];
                int i2 = 0;
                while (i2 < size) {
                    times[i2] = parent.getTime(this.subgroupIndexes_[i2]);
                    ++i2;
                }
                tocd.setTimes(times, parent.getUnits());
            } else {
                int[] ordinals = new int[size];
                int i3 = 0;
                while (i3 < size) {
                    ordinals[i3] = parent.getTimeOrdinal(this.subgroupIndexes_[i3]);
                    ++i3;
                }
                tocd.setOrdinals(ordinals);
            }
            return tocd;
        }

        public static final SubgroupHandler[] create(int[][] subgroupInfo) {
            SubgroupHandler[] handlers = new SubgroupHandler[subgroupInfo.length];
            int i = 0;
            while (i < handlers.length) {
                handlers[i] = new SubgroupHandler(subgroupInfo[i]);
                ++i;
            }
            return handlers;
        }

        public static final SubgroupHandler[] create(int[] subgroupInfo) {
            return new SubgroupHandler[]{new SubgroupHandler(subgroupInfo)};
        }

        private static final int[] getIndexes(TimeOrderCharacterData parent, String[] subgroupInfo) {
            int count = 0;
            int i = 0;
            while (i < subgroupInfo.length) {
                if (parent.whichIdNumber(subgroupInfo[i]) >= 0) {
                    ++count;
                }
                ++i;
            }
            int[] indexes = new int[count];
            count = 0;
            int i2 = 0;
            while (i2 < subgroupInfo.length) {
                int parentIndex = parent.whichIdNumber(subgroupInfo[i2]);
                if (parentIndex >= 0) {
                    indexes[count++] = parentIndex;
                }
                ++i2;
            }
            System.out.println("Parent:" + parent);
            System.out.println("Indexes:" + Utils.toString(indexes));
            return indexes;
        }

        public static final SubgroupHandler[] create(TimeOrderCharacterData parent, String[][] subgroupInfo) {
            SubgroupHandler[] handlers = new SubgroupHandler[subgroupInfo.length];
            int i = 0;
            while (i < handlers.length) {
                handlers[i] = new SubgroupHandler(SubgroupHandler.getIndexes(parent, subgroupInfo[i]));
                ++i;
            }
            return handlers;
        }

        public static final SubgroupHandler[] getCopy(SubgroupHandler[] toCopy, IdGroup oldBase, IdGroup newBase) {
            if (toCopy == null) {
                return null;
            }
            SubgroupHandler[] copy = new SubgroupHandler[toCopy.length];
            int i = 0;
            while (i < toCopy.length) {
                copy[i] = new SubgroupHandler(toCopy[i], oldBase, newBase);
                ++i;
            }
            return copy;
        }

        public static final SubgroupHandler[] create(TimeOrderCharacterData parent, String[] subgroupInfo) {
            return new SubgroupHandler[]{new SubgroupHandler(SubgroupHandler.getIndexes(parent, subgroupInfo))};
        }
    }
}

