/*
 * Decompiled with CFR 0.152.
 */
package pal.misc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.Nameable;

public class SimpleIdGroup
implements IdGroup,
Serializable,
Nameable {
    private String name;
    private Identifier[] ids;
    private Hashtable indices;
    private static final long serialVersionUID = -4266575329980153075L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.name);
        out.writeObject(this.ids);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.name = (String)in.readObject();
        this.ids = (Identifier[])in.readObject();
        this.indices = new Hashtable(this.ids.length);
        int i = 0;
        while (i < this.ids.length) {
            this.indices.put(this.ids[i].getName(), new Integer(i));
            ++i;
        }
    }

    public SimpleIdGroup(int size) {
        this(size, false);
    }

    public SimpleIdGroup(String[] labels) {
        this(labels.length);
        int i = 0;
        while (i < labels.length) {
            this.setIdentifier(i, new Identifier(labels[i]));
            ++i;
        }
    }

    public SimpleIdGroup(int size, boolean createIDs) {
        this.ids = new Identifier[size];
        this.indices = new Hashtable(size);
        if (createIDs) {
            int i = 0;
            while (i < size) {
                this.setIdentifier(i, new Identifier("" + i));
                ++i;
            }
        }
    }

    public SimpleIdGroup(Identifier[] id) {
        this(id.length);
        int i = 0;
        while (i < id.length) {
            this.setIdentifier(i, id[i]);
            ++i;
        }
    }

    public SimpleIdGroup(IdGroup a, IdGroup b) {
        this(a.getIdCount() + b.getIdCount());
        int i = 0;
        while (i < a.getIdCount()) {
            this.setIdentifier(i, a.getIdentifier(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < b.getIdCount()) {
            this.setIdentifier(i2 + a.getIdCount(), b.getIdentifier(i2));
            ++i2;
        }
    }

    public SimpleIdGroup(IdGroup a) {
        this(a.getIdCount());
        int i = 0;
        while (i < a.getIdCount()) {
            this.setIdentifier(i, a.getIdentifier(i));
            ++i;
        }
    }

    public SimpleIdGroup(IdGroup a, int toIgnore) {
        this(toIgnore < 0 || toIgnore > a.getIdCount() ? a.getIdCount() : a.getIdCount() - 1);
        int index = 0;
        int i = 0;
        while (i < a.getIdCount()) {
            if (i != toIgnore) {
                this.setIdentifier(index++, a.getIdentifier(i));
            }
            ++i;
        }
    }

    public int getIdCount() {
        return this.ids.length;
    }

    public Identifier getIdentifier(int i) {
        return this.ids[i];
    }

    public final String getName(int i) {
        return this.ids[i].getName();
    }

    public void setIdentifier(int i, Identifier id) {
        this.ids[i] = id;
        this.indices.put(id.getName(), new Integer(i));
    }

    public int whichIdNumber(String name) {
        Integer index = (Integer)this.indices.get(name);
        if (index != null) {
            return index;
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        int i = 0;
        while (i < this.getIdCount()) {
            sb.append(this.getIdentifier(i) + " ");
            ++i;
        }
        sb.append("]");
        return new String(sb);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }
}

