/*
 * Decompiled with CFR 0.152.
 */
package pal.mep;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pal.eval.MolecularClockLikelihoodModel;
import pal.io.FormattedOutput;
import pal.math.OrthogonalHints;
import pal.misc.Parameterized;
import pal.misc.Report;
import pal.misc.SampleInformation;
import pal.misc.Summarizable;
import pal.misc.TimeOrderCharacterData;
import pal.misc.Units;
import pal.treesearch.ConstraintModel;

public abstract class MutationRateModel
implements Units,
Parameterized,
Report,
Cloneable,
Serializable,
Summarizable {
    protected FormattedOutput fo;
    private int units;
    private double maximumMutationRate_;
    private static final long serialVersionUID = -1755051453782951214L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.units);
        out.writeDouble(this.maximumMutationRate_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.units = in.readInt();
        this.maximumMutationRate_ = in.readDouble();
        this.fo = FormattedOutput.getInstance();
    }

    protected MutationRateModel(int units, double maximumMutationRate) {
        this.setUnits(units, maximumMutationRate);
        this.fo = FormattedOutput.getInstance();
    }

    protected MutationRateModel(MutationRateModel toCopy) {
        this.units = toCopy.units;
        this.maximumMutationRate_ = toCopy.maximumMutationRate_;
        this.fo = FormattedOutput.getInstance();
    }

    public abstract Object clone();

    public abstract MutationRateModel getCopy();

    public abstract double getMutationRate(double var1);

    public abstract double getExpectedSubstitutions(double var1);

    public double getTime(double expectedSubs) {
        return this.getEndTime(expectedSubs, 0.0);
    }

    public abstract double getEndTime(double var1, double var3);

    public abstract void scale(double var1);

    public double getExpectedSubstitutions(double start, double finish) {
        return this.getExpectedSubstitutions(finish) - this.getExpectedSubstitutions(start);
    }

    public TimeOrderCharacterData scale(TimeOrderCharacterData toScale) {
        if (this.getUnits() != toScale.getUnits()) {
            throw new IllegalArgumentException("Incompatible units, expecting " + this.getUnits() + ", found (in toScale) " + toScale.getUnits());
        }
        TimeOrderCharacterData scaled = TimeOrderCharacterData.clone(toScale);
        double[] times = new double[scaled.getIdCount()];
        int i = 0;
        while (i < times.length) {
            times[i] = this.getExpectedSubstitutions(scaled.getTime(i));
            ++i;
        }
        scaled.setTimes(times, 0, false);
        return scaled;
    }

    public final void setUnits(int u, double maximumMutationRate) {
        if (u == 0) {
            throw new IllegalArgumentException("Units cannot be Expected Substitutions!");
        }
        this.units = u;
        this.maximumMutationRate_ = maximumMutationRate;
    }

    protected final double getMaximumMutationRate() {
        return this.maximumMutationRate_;
    }

    public int getUnits() {
        return this.units;
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }

    public abstract String toSingleLine();

    public abstract Factory generateFactory();

    public static interface Factory {
        public MutationRateModel generateNewModel();

        public ConstraintModel buildConstraintModel(SampleInformation var1, MolecularClockLikelihoodModel.Instance var2);
    }
}

