/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MachineAccuracy;
import pal.math.NumericalDerivative;
import pal.math.UnivariateFunction;

public class UnivariateMinimum {
    public double minx;
    public double fminx;
    public double f2minx;
    public int numFun;
    public int maxFun = 0;
    private static final double C = (3.0 - Math.sqrt(5.0)) / 2.0;
    private static final double GOLD = (Math.sqrt(5.0) + 1.0) / 2.0;
    private static final double delta = 0.01;

    public double findMinimum(double x, UnivariateFunction f) {
        double tol = MachineAccuracy.EPSILON;
        return this.optimize(x, f, tol);
    }

    public double findMinimum(double x, UnivariateFunction f, int fracDigits) {
        double tol = Math.pow(10.0, -1 - fracDigits);
        double optx = this.optimize(x, f, tol);
        return optx;
    }

    public double findMinimum(UnivariateFunction f) {
        double tol = MachineAccuracy.EPSILON;
        return this.optimize(f, tol);
    }

    public double findMinimum(UnivariateFunction f, int fracDigits) {
        double tol = Math.pow(10.0, -1 - fracDigits);
        double optx = this.optimize(f, tol);
        return optx;
    }

    public double optimize(UnivariateFunction f, double tol, double lowerBound, double upperBound) {
        this.numFun = 2;
        return this.minin(lowerBound, upperBound, f.evaluate(lowerBound), f.evaluate(upperBound), f, tol);
    }

    public double optimize(UnivariateFunction f, double tol) {
        return this.optimize(f, tol, f.getLowerBound(), f.getUpperBound());
    }

    public double optimize(double x, UnivariateFunction f, double tol, double lowerBound, double upperBound) {
        double[] range = this.bracketize(lowerBound, x, upperBound, f);
        return this.minin(range[0], range[1], range[2], range[3], f, tol);
    }

    public double optimize(double x, UnivariateFunction f, double tol) {
        return this.optimize(x, f, tol, f.getLowerBound(), f.getUpperBound());
    }

    private double trim(double x, int fracDigits) {
        double m = Math.pow(10.0, fracDigits);
        return (double)Math.round(x * m) / m;
    }

    private double constrain(double x, boolean toMax, double min, double max) {
        if (toMax) {
            if (x > max) {
                return max;
            }
            return x;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    private double[] bracketize(double min, double a, double max, UnivariateFunction f) {
        double ulim;
        boolean searchToMax;
        if (min > max) {
            throw new IllegalArgumentException("Argument min (" + min + ") larger than argument max (" + max + ")");
        }
        if (a < min) {
            a = min;
        } else if (a > max) {
            a = max;
        }
        if (a < min || a > max) {
            throw new IllegalArgumentException("Starting point not in given range (" + min + ", " + a + ", " + max + ")");
        }
        double b = a - min < max - a ? a + 0.01 * (max - a) : a - 0.01 * (a - min);
        this.numFun = 0;
        double fa = f.evaluate(a);
        ++this.numFun;
        double fb = f.evaluate(b);
        ++this.numFun;
        if (fb > fa) {
            double tmp = a;
            a = b;
            b = tmp;
            tmp = fa;
            fa = fb;
            fb = tmp;
        }
        if (b > a) {
            searchToMax = true;
            ulim = max;
        } else {
            searchToMax = false;
            ulim = min;
        }
        double c = b + GOLD * (b - a);
        c = this.constrain(c, searchToMax, min, max);
        double fc = f.evaluate(c);
        ++this.numFun;
        while (fb > fc) {
            double q = (b - c) * (fb - fa);
            double r = (b - a) * (fb - fc);
            if (q == r) {
                q += MachineAccuracy.EPSILON;
            }
            double u = b - ((b - c) * q - (b - a) * r) / 2.0 / (q - r);
            u = this.constrain(u, searchToMax, min, max);
            double fu = 0.0;
            boolean magnify = false;
            if ((b - u) * (u - c) > 0.0) {
                fu = f.evaluate(u);
                ++this.numFun;
                if (fu < fc) {
                    a = b;
                    b = u;
                    fa = fb;
                    fb = fu;
                    break;
                }
                if (fu > fb) {
                    c = u;
                    fc = fu;
                    break;
                }
                magnify = true;
            } else if ((c - u) * (u - ulim) > 0.0) {
                fu = f.evaluate(u);
                ++this.numFun;
                if (fu < fc) {
                    b = c;
                    c = u;
                    fb = fc;
                    fc = fu;
                    magnify = true;
                }
            } else if (u == ulim) {
                fu = f.evaluate(u);
                ++this.numFun;
            } else {
                magnify = true;
            }
            if (magnify) {
                u = c + GOLD * (c - b);
                u = this.constrain(u, searchToMax, min, max);
                fu = f.evaluate(u);
                ++this.numFun;
            }
            a = b;
            b = c;
            c = u;
            fa = fb;
            fb = fc;
            fc = fu;
        }
        double[] result = new double[]{a, c, fa, fc};
        return result;
    }

    private double minin(double a, double b, double fa, double fb, UnivariateFunction f, double tol) {
        double v;
        double d = 0.0;
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Nonpositive absolute tolerance tol");
        }
        if (a == b) {
            this.minx = a;
            this.fminx = fa;
            this.f2minx = NumericalDerivative.secondDerivative(f, this.minx);
            return this.minx;
        }
        if (b < a) {
            double tmp = a;
            a = b;
            b = tmp;
            tmp = fa;
            fa = fb;
            fb = tmp;
        }
        double w = a;
        double fw = fa;
        double z = b;
        double fz = fb;
        if (fz > fw) {
            v = z;
            z = w;
            w = v;
            v = fz;
            fz = fw;
            fw = v;
        }
        v = w;
        double fv = fw;
        double e = 0.0;
        while (this.maxFun == 0 || this.numFun <= this.maxFun) {
            double u;
            double m = (a + b) * 0.5;
            double tol_act = MachineAccuracy.SQRT_EPSILON + tol;
            double tol_act2 = 2.0 * tol_act;
            if (Math.abs(z - m) <= tol_act2 - (b - a) * 0.5) break;
            double r = 0.0;
            double q = 0.0;
            double p = 0.0;
            if (Math.abs(e) > tol_act) {
                r = (z - w) * (fz - fv);
                q = (z - v) * (fz - fw);
                p = (z - v) * q - (z - w) * r;
                if ((q = (q - r) * 2.0) > 0.0) {
                    p = -p;
                } else {
                    q = -q;
                }
                r = e;
                e = d;
            }
            if (Math.abs(p) < Math.abs(q * r * 0.5) && p > (a - z) * q && p < (b - z) * q) {
                d = p / q;
                u = z + d;
                if (u - a < tol_act2 || b - u < tol_act2) {
                    d = z < m ? tol_act : -tol_act;
                }
            } else {
                e = (z < m ? b : a) - z;
                d = C * e;
            }
            u = z + (Math.abs(d) >= tol_act ? d : (d > 0.0 ? tol_act : -tol_act));
            double fu = f.evaluate(u);
            ++this.numFun;
            if (fu <= fz) {
                if (u < z) {
                    b = z;
                } else {
                    a = z;
                }
                v = w;
                fv = fw;
                w = z;
                fw = fz;
                z = u;
                fz = fu;
                continue;
            }
            if (u < z) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw) {
                v = w;
                fv = fw;
                w = u;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && v != w) continue;
            v = u;
            fv = fu;
        }
        this.minx = z;
        this.fminx = fz;
        this.f2minx = NumericalDerivative.secondDerivative(f, this.minx);
        return z;
    }
}

