/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.Matrix;

public interface LMSSolver {
    public double[] solve(double[][] var1, double[] var2);

    public static final class Utils {
        public static final LMSSolver getSimpleSolver() {
            return SimpleSolver.INSTANCE;
        }

        private static final class SimpleSolver
        implements LMSSolver {
            public static final LMSSolver INSTANCE = new SimpleSolver();

            private SimpleSolver() {
            }

            public double[] solve(double[][] xMatrix, double[] dMatrix) {
                Matrix m = new Matrix(xMatrix);
                Matrix mTranspose = m.getTranspose();
                Matrix ls = mTranspose.getMultiplied(m).getInverse().getMultiplied(mTranspose);
                Matrix d = new Matrix(new double[][]{dMatrix}).getTranspose();
                Matrix result = ls.getMultiplied(d);
                return result.toArray();
            }
        }
    }
}

