/*
 * Decompiled with CFR 0.152.
 */
package pal.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class OutputTarget
extends PrintWriter {
    private StringWriter stringWriter;

    public static OutputTarget openFile(String name) throws IOException {
        return new OutputTarget(new PrintWriter(new BufferedWriter(new FileWriter(name))));
    }

    public static OutputTarget openStdOut() {
        return new OutputTarget(new PrintWriter(System.out));
    }

    public static OutputTarget openString() {
        StringWriter sw = new StringWriter();
        return new OutputTarget(new PrintWriter(sw), sw);
    }

    public String getString() {
        if (this.stringWriter == null) {
            return "";
        }
        return this.stringWriter.toString();
    }

    private OutputTarget(PrintWriter out) {
        super(out);
    }

    private OutputTarget(PrintWriter out, StringWriter sw) {
        super(out);
        this.stringWriter = sw;
    }
}

