/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import pal.gui.LabelDisplayer;
import pal.gui.NameColouriser;
import pal.gui.Painter;
import pal.gui.PositionedNode;
import pal.misc.Identifier;
import pal.misc.LabelMapping;
import pal.misc.TimeOrderCharacterData;
import pal.misc.Units;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public abstract class TreePainter
implements Painter {
    public static final Color BACKGROUND = Color.white;
    public static final Color FOREGROUND = Color.black;
    public static final Color NORMAL_LABEL_COLOR = Color.green.darker();
    public static final LabelDisplayer NORMAL_LABEL_DISPLAY = LabelDisplayer.Utils.buildDisplay(Color.green.darker());
    public static final LabelDisplayer HILITED_LABEL_DISPLAY = LabelDisplayer.Utils.buildDisplay(Color.red.darker(), 1);
    public static final Color BOOTSTRAP_SUPPORT_COLOUR = Color.black;
    public static final String BOOTSTRAP_ATTRIBUTE_NAME = "bootstrap";
    public static final int DEFAULT_FONT_SIZE = 15;
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final String DEFAULT_FONT_NAME = "times";
    public static final Font DEFAULT_FONT = new Font("times", 0, 15);
    public PositionedNode treeNode;
    public String title_;
    protected String attName = null;
    boolean showTitle_;
    private Tree tree;
    private TimeOrderCharacterData tocd = null;
    double width;
    double height;
    double maxHeight = -1.0;
    double maxLeafTime = 0.0;
    double sizeOfScale = 0.0;
    private int penWidth = 2;
    private boolean usingColor = true;
    private boolean showingNodeHeights = false;
    protected boolean showingInternalLabels = true;
    private boolean usingSymbols = false;
    private NameColouriser colouriser_ = null;
    private LabelMapping labelMapping_ = null;
    private Font labelFont_ = DEFAULT_FONT;

    public TreePainter(Tree toDisplay, String title, boolean showTitle) {
        this.title_ = title;
        this.showTitle_ = showTitle;
        this.tree = toDisplay;
        this.standardTreePrep();
    }

    protected int getBootstrapValue(PositionedNode node) {
        Object o = this.tree.getAttribute(node.getPeer(), BOOTSTRAP_ATTRIBUTE_NAME);
        if (o == null) {
            return -1;
        }
        return (Integer)o;
    }

    protected void standardTreePrep() {
        TreeUtils.rotateByLeafCount(this.tree);
        this.treeNode = new PositionedNode(this.tree.getRoot());
        this.treeNode.calculatePositions();
        this.width = NodeUtils.getLeafCount(this.treeNode);
        this.height = this.treeNode.getNodeHeight();
        this.maxLeafTime = 0.0;
        this.maxLeafTime = TreePainter.getMaxLeafTime(this.treeNode);
        this.maxLeafTime *= 1.5;
        this.sizeOfScale = this.getSizeOfScale(this.height / 5.0);
    }

    public final void setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
        this.sizeOfScale = this.getSizeOfScale(maxHeight / 5.0);
    }

    public final void setAttributeName(String name) {
        this.attName = name;
    }

    public final void setPenWidth(int p) {
        this.penWidth = p;
    }

    public final int getPenWidth() {
        return this.penWidth;
    }

    public final void setTree(Tree tree) {
        this.tree = tree;
        this.standardTreePrep();
        this.setTreeImpl(tree);
    }

    public void setTreeImpl(Tree tree) {
    }

    public final void setUsingColor(boolean use) {
        this.usingColor = use;
    }

    public final boolean isUsingColor() {
        return this.usingColor;
    }

    public final void setShowingNodeHeights(boolean s) {
        this.showingNodeHeights = s;
    }

    public final boolean isShowingNodeHeights() {
        return this.showingNodeHeights;
    }

    public final boolean isShowingInternalLabels() {
        return this.showingInternalLabels;
    }

    public final TimeOrderCharacterData getTimeOrderCharacterData() {
        return this.tocd;
    }

    public final void setTimeOrderCharacterData(TimeOrderCharacterData tocd) {
        this.tocd = tocd;
        this.usingSymbols = true;
    }

    public final boolean isUsingSymbols() {
        return this.usingSymbols;
    }

    public final void setUsingSymbols(boolean use) {
        this.usingSymbols = use;
        if (this.tocd == null) {
            this.usingSymbols = false;
        }
    }

    protected final Tree getTree() {
        return this.tree;
    }

    protected final double getSizeOfScale(double target) {
        double sos = 0.1;
        boolean accept = false;
        boolean divideByTwo = true;
        while (!accept) {
            if (sos / target >= 5.0) {
                sos /= divideByTwo ? 2.0 : 5.0;
                divideByTwo = !divideByTwo;
                continue;
            }
            if (sos / target < 0.2) {
                sos *= divideByTwo ? 5.0 : 2.0;
                divideByTwo = !divideByTwo;
                continue;
            }
            accept = true;
        }
        return sos;
    }

    protected static final double getMaxLeafTime(Node node) {
        if (!node.isLeaf()) {
            double max = TreePainter.getMaxLeafTime(node.getChild(0));
            double posmax = 0.0;
            int i = 1;
            while (i < node.getChildCount()) {
                posmax = TreePainter.getMaxLeafTime(node.getChild(i));
                if (posmax > max) {
                    max = posmax;
                }
                ++i;
            }
            return max;
        }
        return node.getNodeHeight();
    }

    public static final void drawSymbol(Graphics g, int x, int y, int width, int index) {
        int halfWidth = width / 2;
        switch (index % 6) {
            case 0: {
                g.fillRect(x, y, width, width);
                break;
            }
            case 1: {
                g.drawRect(x, y, width, width);
                break;
            }
            case 2: {
                g.fillOval(x, y, width, width);
                break;
            }
            case 3: {
                g.drawOval(x, y, width, width);
                break;
            }
            case 4: {
                g.drawLine(x, y + width, x + halfWidth, y);
                g.drawLine(x + halfWidth, y, x + width, y + width);
                g.drawLine(x, y + width, x + width, y + width);
                break;
            }
            case 5: {
                g.drawLine(x, y, x + width, y + width);
                g.drawLine(x, y + width, x + width, y);
            }
        }
    }

    public final boolean isShowTitle() {
        return this.showTitle_;
    }

    public final void setColouriser(NameColouriser nc) {
        this.colouriser_ = nc;
    }

    public final void setLabelMapping(LabelMapping lp) {
        this.labelMapping_ = lp;
    }

    public final void setTitle(String title) {
        this.title_ = title;
        this.showTitle_ = true;
    }

    protected final String getNodeName(Node node) {
        if (this.labelMapping_ != null) {
            return this.labelMapping_.getLabel(node.getIdentifier());
        }
        return node.getIdentifier().getName();
    }

    public final String getTitle() {
        return this.title_;
    }

    public final void doTitle(Graphics g, int x, int y) {
        if (this.showTitle_) {
            g.drawString(this.title_, x, y);
        }
    }

    protected final void doScale(Graphics g, double xScale, int x, int y) {
        g.setColor(FOREGROUND);
        g.drawLine(x, y, x + (int)Math.round(this.sizeOfScale * xScale), y);
        g.drawString(this.sizeOfScale + " " + Units.UNIT_NAMES[this.tree.getUnits()], x, y - 12);
    }

    protected final LabelDisplayer getNodeDisplay(Node n, LabelDisplayer defaultDisplay) {
        if (this.colouriser_ != null) {
            return this.colouriser_.getDisplay(n.getIdentifier(), defaultDisplay);
        }
        return defaultDisplay;
    }

    private int getLongestIdentifierPixelWidth(FontMetrics fm, Node n) {
        String name;
        Identifier id = n.getIdentifier();
        int myWidth = 0;
        if (id != null && (name = id.getName()) != null) {
            if (this.labelMapping_ != null) {
                name = this.labelMapping_.getLabel(name, name);
            }
            myWidth = fm.stringWidth(name);
        }
        int numberChild = n.getChildCount();
        int i = 0;
        while (i < numberChild) {
            myWidth = Math.max(myWidth, this.getLongestIdentifierPixelWidth(fm, n.getChild(i)));
            ++i;
        }
        return myWidth;
    }

    protected final int getLongestIdentifierPixelWidth(FontMetrics fm) {
        return this.getLongestIdentifierPixelWidth(fm, this.treeNode);
    }

    public final void setLabelFont(Font f) {
        this.labelFont_ = f;
    }

    public final void setLabelFontSize(int size) {
        this.labelFont_ = new Font(this.labelFont_.getFontName(), size, this.labelFont_.getSize());
    }

    protected final Font getLabelFont() {
        return this.labelFont_;
    }
}

