/*
 * Decompiled with CFR 0.152.
 */
package pal.gui;

import pal.tree.Node;
import pal.tree.SimpleNode;

public class PositionedNode
extends SimpleNode {
    protected double x;
    boolean highlight_;
    Node peer_;

    public PositionedNode(Node node, Node highlightNode) {
        this.init(node);
        this.peer_ = node;
        if (!node.isLeaf()) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.addChild(new PositionedNode(node.getChild(i), highlightNode));
                ++i;
            }
        }
        this.highlight_ = node == highlightNode;
    }

    public PositionedNode(Node node) {
        this.init(node);
        this.peer_ = node;
        if (!node.isLeaf()) {
            int i = 0;
            while (i < node.getChildCount()) {
                this.addChild(new PositionedNode(node.getChild(i)));
                ++i;
            }
        }
    }

    public void calculatePositions() {
        double[] currentXPos = new double[]{0.0};
        this.calculateXPositions(currentXPos);
    }

    public Node getPeer() {
        return this.peer_;
    }

    private double calculateXPositions(double[] currentXPos) {
        if (!this.isLeaf()) {
            this.x = ((PositionedNode)this.getChild(0)).calculateXPositions(currentXPos);
            int i = 1;
            while (i < this.getChildCount()) {
                this.x += ((PositionedNode)this.getChild(i)).calculateXPositions(currentXPos);
                ++i;
            }
            this.x /= (double)this.getChildCount();
        } else {
            this.x = currentXPos[0];
            currentXPos[0] = currentXPos[0] + 1.0;
        }
        return this.x;
    }

    public boolean isHighlighted() {
        return this.highlight_;
    }

    public double getX() {
        return this.x;
    }
}

