/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import pal.substmodel.SubstitutionModel;

public interface SiteDetails {
    public SubstitutionModel getRelatedModel();

    public double[] getSitePosteriors(int var1);

    public double[] getSiteLikelihoods();

    public double[] getSiteLogLikelihoods();

    public static final class Utils {
        public static final SiteDetails create(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, SubstitutionModel model, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites, double[] siteLikelihoods) {
            return new SimpleSiteDetails(categoryPatternConditionalProbabilities, isLoggedConditionals, model, numberOfPatterns, sitePatternMatchup, numberOfSites, siteLikelihoods);
        }

        public static final SiteDetails create(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites, double[] siteLikelihoods) {
            return new SimpleSiteDetails(categoryPatternConditionalProbabilities, isLoggedConditionals, numberOfPatterns, sitePatternMatchup, numberOfSites, siteLikelihoods);
        }

        private static final class SimpleSiteDetails
        implements SiteDetails {
            private final double[][] categoryPatternConditionalProbabilities_;
            private final double[][] patternPosteriors_;
            private final double[] siteLikelihoods_;
            private final double[] siteLogLikelihoods_;
            private final int[] sitePatternMatchup_;
            private final SubstitutionModel model_;
            private final int numberOfSites_;

            public SimpleSiteDetails(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites, double[] siteLikelihoods) {
                this(categoryPatternConditionalProbabilities, isLoggedConditionals, null, numberOfPatterns, sitePatternMatchup, numberOfSites, siteLikelihoods);
            }

            public SimpleSiteDetails(double[][] categoryPatternConditionalProbabilities, boolean isLoggedConditionals, SubstitutionModel model, int numberOfPatterns, int[] sitePatternMatchup, int numberOfSites, double[] siteLikelihoods) {
                int numberOfCategories = model.getNumberOfTransitionCategories();
                this.siteLikelihoods_ = pal.misc.Utils.getCopy(siteLikelihoods);
                this.siteLogLikelihoods_ = new double[numberOfSites];
                double llh = 0.0;
                int i = 0;
                while (i < numberOfSites) {
                    this.siteLogLikelihoods_[i] = Math.log(this.siteLikelihoods_[i]);
                    llh += this.siteLogLikelihoods_[i];
                    ++i;
                }
                System.out.println("Total:" + llh);
                this.categoryPatternConditionalProbabilities_ = isLoggedConditionals ? SimpleSiteDetails.convertLogged(categoryPatternConditionalProbabilities, numberOfCategories, numberOfPatterns) : pal.misc.Utils.getCopy(categoryPatternConditionalProbabilities);
                this.numberOfSites_ = numberOfSites;
                this.sitePatternMatchup_ = pal.misc.Utils.getCopy(sitePatternMatchup);
                this.patternPosteriors_ = new double[numberOfPatterns][numberOfCategories];
                int p = 0;
                while (p < numberOfPatterns) {
                    double total = 0.0;
                    int c = 0;
                    while (c < numberOfCategories) {
                        total += categoryPatternConditionalProbabilities[c][p];
                        ++c;
                    }
                    int c2 = 0;
                    while (c2 < numberOfCategories) {
                        this.patternPosteriors_[p][c2] = categoryPatternConditionalProbabilities[c2][p] / total;
                        ++c2;
                    }
                    ++p;
                }
                this.model_ = model;
            }

            public double[] getSiteLikelihoods() {
                return this.siteLikelihoods_;
            }

            public double[] getSiteLogLikelihoods() {
                return this.siteLogLikelihoods_;
            }

            public SubstitutionModel getRelatedModel() {
                return this.model_;
            }

            public double[] getSitePosteriors(int site) {
                return this.patternPosteriors_[this.sitePatternMatchup_[site]];
            }

            private static final double[][] convertLogged(double[][] loggedStore, int numberOfCategories, int numberOfPatterns) {
                double[][] result = new double[numberOfCategories][numberOfPatterns];
                int c = 0;
                while (c < numberOfCategories) {
                    int p = 0;
                    while (p < numberOfPatterns) {
                        result[c][p] = Math.exp(loggedStore[c][p]);
                        ++p;
                    }
                    ++c;
                }
                return result;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < this.numberOfSites_) {
                    double[] sitePosteriors = this.getSitePosteriors(i);
                    sb.append(pal.misc.Utils.argmax(sitePosteriors));
                    sb.append(" - ");
                    sb.append("Site ");
                    sb.append(i + 1);
                    sb.append(":");
                    sb.append(pal.misc.Utils.toString(sitePosteriors));
                    sb.append("\n");
                    ++i;
                }
                return sb.toString();
            }
        }
    }
}

