/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.datatype.DataType;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.LHCalculator;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.SimpleLHCalculator;
import pal.eval.SiteDetails;
import pal.misc.NeoParameterized;
import pal.misc.Parameterized;
import pal.misc.ParameterizedNeoWrapper;
import pal.substmodel.SubstitutionModel;

public class SimpleMolecularClockLikelihoodModel
implements MolecularClockLikelihoodModel {
    public static final MolecularClockLikelihoodModel.Instance createInstance(LHCalculator.Factory baseFactory, SubstitutionModel model) {
        int numberOfCategories = model.getNumberOfTransitionCategories();
        DataType dt = model.getDataType();
        return new SimpleInstance(model, baseFactory.createSeries(numberOfCategories, dt));
    }

    public static final MolecularClockLikelihoodModel.Instance createInstance(SubstitutionModel model) {
        return SimpleMolecularClockLikelihoodModel.createInstance(SimpleLHCalculator.getFactory(), model);
    }

    private static final class SimpleInstance
    implements MolecularClockLikelihoodModel.Instance {
        private int numberOfCategories_;
        private LHCalculator.Generator baseGenerator_;
        private SubstitutionModel substitutionModel_;
        private NeoParameterized parameterAccess_;
        private static final long serialVersionUID = 2661663212643526344L;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeByte(1);
            out.writeInt(this.numberOfCategories_);
            out.writeObject(this.baseGenerator_);
            out.writeObject(this.substitutionModel_);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            switch (version) {
                default: 
            }
            this.numberOfCategories_ = in.readInt();
            this.baseGenerator_ = (LHCalculator.Generator)in.readObject();
            this.substitutionModel_ = (SubstitutionModel)in.readObject();
            this.parameterAccess_ = new ParameterizedNeoWrapper(this.substitutionModel_);
        }

        public SimpleInstance(SubstitutionModel sm, LHCalculator.Generator baseGenerator) {
            this.numberOfCategories_ = sm.getNumberOfTransitionCategories();
            this.substitutionModel_ = sm;
            this.baseGenerator_ = baseGenerator;
            this.parameterAccess_ = new ParameterizedNeoWrapper(this.substitutionModel_);
        }

        public Parameterized getSubstitutionModelParameterAccess() {
            return this.substitutionModel_;
        }

        public boolean hasSubstitutionModelParameters() {
            return this.substitutionModel_.getNumParameters() != 0;
        }

        public MolecularClockLikelihoodModel.Leaf createNewLeaf(MolecularClockLikelihoodModel.HeightConverter heightConverter, PatternInfo pattern, int[] patternStateMatchup) {
            return new LeafImpl(this.baseGenerator_.createNewLeaf(patternStateMatchup, pattern.getNumberOfPatterns()), this.substitutionModel_, heightConverter);
        }

        public MolecularClockLikelihoodModel.External createNewExternal(MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            return new ExternalImpl(this.baseGenerator_.createNewExternal(), this.substitutionModel_, heightConverter);
        }

        public MolecularClockLikelihoodModel.Internal createNewInternal(MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            return new InternalImpl(this.baseGenerator_.createNewInternal(), this.substitutionModel_, heightConverter);
        }

        public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
            return this.baseGenerator_.createAppropriateConditionalProbabilityStore(isForLeaf);
        }

        public String getSubstitutionModelSummary() {
            return "Model:" + this.substitutionModel_.toString();
        }

        public NeoParameterized getParameterAccess() {
            return this.parameterAccess_;
        }
    }

    private static final class LeafImpl
    implements MolecularClockLikelihoodModel.Leaf {
        private final LHCalculator.Leaf base_;
        private final SubstitutionModel model_;
        private final MolecularClockLikelihoodModel.HeightConverter heightConverter_;

        public LeafImpl(LHCalculator.Leaf base, SubstitutionModel model, MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            this.base_ = base;
            this.model_ = model;
            this.heightConverter_ = heightConverter;
        }

        public ConditionalProbabilityStore calculateExtendedConditionals(double topBaseHeight, double bottomBaseHeight) {
            return this.base_.getExtendedConditionalProbabilities(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, true);
        }

        public ConditionalProbabilityStore calculateFlatConditionals(double relatedHeight) {
            return this.base_.getFlatConditionalProbabilities();
        }
    }

    private static final class ExternalImpl
    implements MolecularClockLikelihoodModel.External {
        private final LHCalculator.External base_;
        private final SubstitutionModel model_;
        private final MolecularClockLikelihoodModel.HeightConverter heightConverter_;

        public ExternalImpl(LHCalculator.External base, SubstitutionModel model, MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            this.base_ = base;
            this.model_ = model;
            this.heightConverter_ = heightConverter;
        }

        public void calculateSingleExtendedConditionals(double topBaseHeight, double bottomBaseHeight, int numberOfPatterns, ConditionalProbabilityStore baseConditionalProbabilities, ConditionalProbabilityStore resultConditionalProbabilities) {
            this.base_.calculateSingleExtendedIndirect(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, numberOfPatterns, baseConditionalProbabilities, resultConditionalProbabilities);
        }

        public void calculateSingleDescendentExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore descendentConditionalProbabilities) {
            this.base_.calculateSingleExtendedDirect(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, centerPattern.getNumberOfPatterns(), descendentConditionalProbabilities);
        }

        public void calculateSingleAscendentExtendedConditionalsDirect(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore ascendentConditionalProbabilityProbabilties) {
            this.base_.calculateSingleExtendedDirect(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, centerPattern.getNumberOfPatterns(), ascendentConditionalProbabilityProbabilties);
        }

        public void calculateSingleAscendentExtendedConditionalsIndirect(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore baseAscendentConditionalProbabilityProbabilties, ConditionalProbabilityStore resultConditionalProbabilityProbabilties) {
            this.base_.calculateSingleExtendedIndirect(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, centerPattern.getNumberOfPatterns(), baseAscendentConditionalProbabilityProbabilties, resultConditionalProbabilityProbabilties);
        }

        public void calculateExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilities, ConditionalProbabilityStore rightConditionalProbabilities, ConditionalProbabilityStore resultStore) {
            this.base_.calculateExtended(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, centerPattern, leftConditionalProbabilities, rightConditionalProbabilities, resultStore);
        }

        public double calculateLogLikelihoodNonRoot(double nodeHeight, PatternInfo centerPattern, ConditionalProbabilityStore ascendentConditionalProbabilitiesStore, ConditionalProbabilityStore descendentConditionalProbabilitiesStore) {
            return this.base_.calculateLogLikelihood(this.model_, centerPattern, ascendentConditionalProbabilitiesStore, descendentConditionalProbabilitiesStore);
        }

        public double calculateLogLikelihood(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            return this.base_.calculateLogLikelihood(this.model_, centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore);
        }

        public double calculateLogLikelihoodSingle(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore conditionalProbabilitiesStore) {
            return this.base_.calculateLogLikelihoodSingle(this.model_, centerPattern.getPatternWeights(), centerPattern.getNumberOfPatterns(), conditionalProbabilitiesStore);
        }

        public void calculateFlatConditionals(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore, ConditionalProbabilityStore resultConditionalProbabilitiesStore) {
            this.base_.calculateFlat(centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore, resultConditionalProbabilitiesStore);
        }

        public SiteDetails calculateSiteDetails(double rootHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilitiesStore, ConditionalProbabilityStore rightConditionalProbabilitiesStore) {
            return this.base_.calculateSiteDetailsRooted(this.model_, centerPattern, leftConditionalProbabilitiesStore, rightConditionalProbabilitiesStore);
        }
    }

    private static final class InternalImpl
    implements MolecularClockLikelihoodModel.Internal {
        private final LHCalculator.Internal base_;
        private final SubstitutionModel model_;
        private final MolecularClockLikelihoodModel.HeightConverter heightConverter_;

        public InternalImpl(LHCalculator.Internal base, SubstitutionModel model, MolecularClockLikelihoodModel.HeightConverter heightConverter) {
            this.base_ = base;
            this.model_ = model;
            this.heightConverter_ = heightConverter;
        }

        public ConditionalProbabilityStore calculatePostExtendedFlatConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            return this.base_.calculatePostExtendedFlat(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, true);
        }

        public ConditionalProbabilityStore calculateExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            return this.base_.calculateExtended(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties, true);
        }

        public ConditionalProbabilityStore calculateAscendentExtendedConditionals(double topBaseHeight, double bottomBaseHeight, PatternInfo centerPattern, ConditionalProbabilityStore ascenedentConditionalProbabilityProbabilties, ConditionalProbabilityStore otherConditionalProbabilityProbabilties) {
            return this.base_.calculateExtended(this.heightConverter_.getExpectedSubstitutionDistance(bottomBaseHeight, topBaseHeight), this.model_, centerPattern, ascenedentConditionalProbabilityProbabilties, otherConditionalProbabilityProbabilties, true);
        }

        public ConditionalProbabilityStore calculateAscendentFlatConditionals(PatternInfo centerPattern, ConditionalProbabilityStore ascenedentConditionalProbabilityProbabilties, ConditionalProbabilityStore otherConditionalProbabilityProbabilties) {
            return this.base_.calculateFlat(centerPattern, ascenedentConditionalProbabilityProbabilties, otherConditionalProbabilityProbabilties);
        }

        public ConditionalProbabilityStore calculateFlatConditionals(PatternInfo centerPattern, ConditionalProbabilityStore leftConditionalProbabilityProbabilties, ConditionalProbabilityStore rightConditionalProbabilityProbabilties) {
            return this.base_.calculateFlat(centerPattern, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties);
        }
    }
}

