/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import pal.datatype.DataType;
import pal.misc.Utils;

public class LikelihoodSummary
implements Serializable {
    private double overallLogLikelihood_;
    private double[] categoryProbabilities_;
    private double[][] individualLikelihoods_;
    private int[] sitePatternMatchup_;
    private DataType dataType_;
    private static final long serialVersionUID = -37625234234158192L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeDouble(this.overallLogLikelihood_);
        out.writeObject(this.categoryProbabilities_);
        out.writeObject(this.individualLikelihoods_);
        out.writeObject(this.sitePatternMatchup_);
        out.writeObject(this.dataType_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.overallLogLikelihood_ = in.readDouble();
        this.categoryProbabilities_ = (double[])in.readObject();
        this.individualLikelihoods_ = (double[][])in.readObject();
        this.sitePatternMatchup_ = (int[])in.readObject();
        this.dataType_ = (DataType)in.readObject();
    }

    public LikelihoodSummary(DataType dt, double overallLogLikelihood, double[] categoryProbabilities, double[][] individualLikelihoods, int[] sitePatternMatchup) {
        this.dataType_ = dt;
        this.overallLogLikelihood_ = overallLogLikelihood;
        this.categoryProbabilities_ = Utils.getCopy(categoryProbabilities);
        this.individualLikelihoods_ = Utils.getCopy(individualLikelihoods);
        this.sitePatternMatchup_ = Utils.getCopy(sitePatternMatchup);
    }

    public final double getOverallLogLikelihood() {
        return this.overallLogLikelihood_;
    }

    public final int[][] generateCategoryRankings() {
        int[][] rankings = new int[this.sitePatternMatchup_.length][];
        int i = 0;
        while (i < rankings.length) {
            rankings[i] = this.generateCategoryRanking(i);
            ++i;
        }
        return rankings;
    }

    public final double[] generateSiteLikelihoods(int site) {
        return Utils.getCopy(this.individualLikelihoods_[this.sitePatternMatchup_[site]]);
    }

    public final double[] generateSitePosteriors(int site) {
        double[] rs = this.generateSiteLikelihoods(site);
        double total = 0.0;
        int i = 0;
        while (i < rs.length) {
            total += rs[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < rs.length) {
            int n = i2++;
            rs[n] = rs[n] / total;
        }
        return rs;
    }

    public final int[] generateCategoryRanking(int site) {
        double[] likelihoods = this.individualLikelihoods_[this.sitePatternMatchup_[site]];
        int[] ranking = new int[likelihoods.length];
        boolean[] used = new boolean[likelihoods.length];
        int i = 0;
        while (i < used.length) {
            used[i] = false;
            ++i;
        }
        int i2 = 0;
        while (i2 < ranking.length) {
            int max = -1;
            double maxValue = -1.0;
            int j = 0;
            while (j < used.length) {
                if (!used[j] && (max < 0 || likelihoods[j] > maxValue)) {
                    max = j;
                    maxValue = likelihoods[j];
                }
                ++j;
            }
            used[max] = true;
            ranking[i2] = max;
            ++i2;
        }
        return ranking;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Likelihood Summary\n\n");
        sb.append("Data Type:" + this.dataType_ + "\n");
        sb.append("Overall Log Likelihood:" + this.overallLogLikelihood_ + "\n");
        sb.append("Number of sites:" + this.sitePatternMatchup_.length + "\n\n");
        int i = 0;
        while (i < this.sitePatternMatchup_.length) {
            double[] sitePosteriors = this.generateSitePosteriors(i);
            int[] ranking = this.generateCategoryRanking(i);
            sb.append("Site:" + i);
            sb.append(' ');
            sb.append(Utils.toString(ranking));
            sb.append("\n");
            sb.append(" posteriors:" + Utils.toString(sitePosteriors));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

