/*
 * Decompiled with CFR 0.152.
 */
package pal.eval;

import java.io.Serializable;
import pal.misc.Utils;

public final class ConditionalProbabilityStore
implements Serializable {
    private final int numberOfCategories_;
    private final int numberOfStates_;
    private final double[][][] store_;
    private int patternCapacity_;
    private final ExtraProcessor extraProcessor_;
    private boolean isBasedOnCachedData_ = false;
    private boolean fix_ = false;

    private ConditionalProbabilityStore(ConditionalProbabilityStore toCopy) {
        this.numberOfCategories_ = toCopy.numberOfCategories_;
        this.numberOfStates_ = toCopy.numberOfStates_;
        this.store_ = Utils.getCopy(toCopy.store_);
        this.patternCapacity_ = toCopy.patternCapacity_;
        this.extraProcessor_ = toCopy.extraProcessor_ == null ? null : toCopy.extraProcessor_.getCopy();
        this.isBasedOnCachedData_ = toCopy.isBasedOnCachedData_;
        this.fix_ = toCopy.fix_;
    }

    public ConditionalProbabilityStore(int numberOfCategories, int numberOfStates) {
        this(numberOfCategories, numberOfStates, null);
    }

    public ConditionalProbabilityStore(int numberOfCategories, int numberOfStates, ExtraProcessor extraProcessor) {
        this.numberOfCategories_ = numberOfCategories;
        this.numberOfStates_ = numberOfStates;
        this.store_ = new double[numberOfCategories][][];
        this.patternCapacity_ = 0;
        this.extraProcessor_ = extraProcessor;
        if (this.extraProcessor_ != null) {
            this.extraProcessor_.setParent(this);
            this.extraProcessor_.setNewNumberOfPatterns(0);
        }
    }

    public final ConditionalProbabilityStore getCopy() {
        return new ConditionalProbabilityStore(this);
    }

    public final boolean isHasExtraProcessor() {
        return this.extraProcessor_ != null;
    }

    public final ExtraProcessor getExtraProcessor() {
        return this.extraProcessor_;
    }

    private final void ensureSize(int numberOfPatterns, boolean createStateArray) {
        if (numberOfPatterns > this.patternCapacity_) {
            if (this.fix_) {
                throw new IllegalArgumentException("Cannot resize to accomodate " + numberOfPatterns + " patterns (store has been fixed)");
            }
            if (createStateArray) {
                int i = 0;
                while (i < this.numberOfCategories_) {
                    this.store_[i] = new double[numberOfPatterns][this.numberOfStates_];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.numberOfCategories_) {
                    this.store_[i] = new double[numberOfPatterns][];
                    ++i;
                }
            }
            if (this.extraProcessor_ != null) {
                this.extraProcessor_.setNewNumberOfPatterns(numberOfPatterns);
            }
            this.patternCapacity_ = numberOfPatterns;
        }
    }

    public int getPatternCapacity() {
        return this.patternCapacity_;
    }

    public double[][][] getCurrentConditionalProbabilities() {
        return this.store_;
    }

    public double[][] getCurrentConditionalProbabilities(int category) {
        return this.store_[category];
    }

    public double[][][] getConditionalProbabilityAccess(int numberOfPatterns, boolean resultsBasedOnCachedData) {
        this.ensureSize(numberOfPatterns, true);
        this.isBasedOnCachedData_ = resultsBasedOnCachedData;
        return this.store_;
    }

    public double[][][] getConditionalProbabilityAccessNoChangeData(int numberOfPatterns, boolean resultsBasedOnCachedData) {
        if (numberOfPatterns > this.patternCapacity_) {
            throw new IllegalArgumentException("Cannot provided for requested number of patterns. Asked for " + numberOfPatterns + " can only give " + this.patternCapacity_);
        }
        this.isBasedOnCachedData_ = resultsBasedOnCachedData;
        return this.store_;
    }

    public double[][][] getIncompleteConditionalProbabilityAccess(int numberOfPatterns, boolean resultsBasedOnCachedData, boolean fix) {
        this.ensureSize(numberOfPatterns, false);
        this.isBasedOnCachedData_ = resultsBasedOnCachedData;
        this.fix_ = fix;
        return this.store_;
    }

    public double calculateLogLikelihood(double[] categoryProbabilities, double[] equilibriumFrequencies, int[] patternWeights, int numberOfPatterns) {
        double logLikelihood = 0.0;
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            double total = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double prob = 0.0;
                double[] stateArray = this.store_[cat][pattern];
                int state = 0;
                while (state < this.numberOfStates_) {
                    prob += equilibriumFrequencies[state] * stateArray[state];
                    ++state;
                }
                total += categoryProbabilities[cat] * prob;
                ++cat;
            }
            logLikelihood = patternWeights != null ? (logLikelihood += Math.log(total) * (double)patternWeights[pattern]) : (logLikelihood += Math.log(total));
            ++pattern;
        }
        return logLikelihood;
    }

    public double calculateLogLikelihood(double[] categoryProbabilities, double[] equilibriumFrequencies, int numberOfPatterns) {
        return this.calculateLogLikelihood(categoryProbabilities, equilibriumFrequencies, null, numberOfPatterns);
    }

    public double[] calculatePatternLogLikelihoods(double[] categoryProbabilities, double[] equilibriumFrequencies, int numberOfPatterns) {
        double[] result = new double[numberOfPatterns];
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            double total = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                double prob = 0.0;
                double[] stateArray = this.store_[cat][pattern];
                int state = 0;
                while (state < this.numberOfStates_) {
                    prob += equilibriumFrequencies[state] * stateArray[state];
                    ++state;
                }
                total += categoryProbabilities[cat] * prob;
                ++cat;
            }
            result[pattern] = Math.log(total);
            ++pattern;
        }
        return result;
    }

    public double[][] calculateCategoryPatternConditionalProbabilities(double[] categoryProbabilities, double[] equilibriumFrequencies, int numberOfPatterns) {
        double logLikelihood = 0.0;
        boolean patternIndex = false;
        double[][] result = new double[this.numberOfCategories_][numberOfPatterns];
        int pattern = 0;
        while (pattern < numberOfPatterns) {
            double total = 0.0;
            int cat = 0;
            while (cat < this.numberOfCategories_) {
                int state;
                double prob = 0.0;
                double[] stateArray = this.store_[cat][pattern];
                if (equilibriumFrequencies == null) {
                    state = 0;
                    while (state < this.numberOfStates_) {
                        prob += stateArray[state];
                        ++state;
                    }
                } else {
                    state = 0;
                    while (state < this.numberOfStates_) {
                        prob += equilibriumFrequencies[state] * stateArray[state];
                        ++state;
                    }
                }
                result[cat][pattern] = categoryProbabilities == null ? prob : categoryProbabilities[cat] * prob;
                ++cat;
            }
            ++pattern;
        }
        return result;
    }

    public boolean isBasedOnCachedData() {
        return this.isBasedOnCachedData_;
    }

    public void setBasedOnCachedData(boolean v) {
        this.isBasedOnCachedData_ = v;
    }

    public String toString() {
        return this.toString(this.patternCapacity_);
    }

    public String toString(int numberOfPatterns) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.numberOfCategories_) {
            sb.append(i);
            sb.append(":");
            sb.append(Utils.toString(this.store_[i]));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static interface ExtraProcessor {
        public ExtraProcessor getCopy();

        public void setNewNumberOfPatterns(int var1);

        public void setParent(ConditionalProbabilityStore var1);
    }
}

