/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import pal.alignment.Alignment;
import pal.alignment.SitePattern;
import pal.distance.AlignmentDistanceMatrix;
import pal.distance.DistanceMatrix;
import pal.substmodel.SubstitutionModel;
import pal.util.AlgorithmCallback;

public interface DistanceMatrixAccess {
    public DistanceMatrix obtainMatrix(AlgorithmCallback var1);

    public static final class Utils {
        public static DistanceMatrixAccess createSimple(DistanceMatrix base) {
            return new Simple(base);
        }

        public static DistanceMatrixAccess createEvolutionary(Alignment a, SubstitutionModel sm) {
            return new Evolutionary(a, sm);
        }

        private static final class Evolutionary
        implements DistanceMatrixAccess {
            private final Alignment alignment_;
            private final SubstitutionModel model_;

            public Evolutionary(Alignment alignment, SubstitutionModel model) {
                this.alignment_ = alignment;
                this.model_ = model;
            }

            public DistanceMatrix obtainMatrix(AlgorithmCallback callback) {
                return new AlignmentDistanceMatrix(SitePattern.getSitePattern(this.alignment_), this.model_, callback);
            }
        }

        private static final class Simple
        implements DistanceMatrixAccess {
            private final DistanceMatrix base_;

            public Simple(DistanceMatrix base) {
                this.base_ = base;
            }

            public DistanceMatrix obtainMatrix(AlgorithmCallback callback) {
                return this.base_;
            }
        }
    }
}

