/*
 * Decompiled with CFR 0.152.
 */
package pal.distance;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import pal.io.FormattedOutput;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;
import pal.misc.Utils;

public class DistanceMatrix
implements Serializable,
IdGroup {
    private IdGroup idGroup;
    private double[][] distance = null;
    static final long serialVersionUID = 4725925229860707633L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.idGroup);
        out.writeObject(this.distance);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.idGroup = (IdGroup)in.readObject();
        this.distance = (double[][])in.readObject();
    }

    public DistanceMatrix() {
    }

    public DistanceMatrix(double[][] distance, IdGroup idGroup) {
        this.distance = distance;
        this.idGroup = idGroup;
    }

    public DistanceMatrix(DistanceMatrix dm) {
        this.distance = Utils.getCopy(dm.distance);
        this.idGroup = dm.getIdGroup();
    }

    public DistanceMatrix(DistanceMatrix dm, IdGroup subset) {
        this.distance = new double[subset.getIdCount()][subset.getIdCount()];
        int i = 0;
        while (i < this.distance.length) {
            int index1 = dm.whichIdNumber(subset.getIdentifier(i).getName());
            int j = 0;
            while (j < i) {
                int index2 = dm.whichIdNumber(subset.getIdentifier(j).getName());
                this.distance[i][j] = dm.distance[index1][index2];
                this.distance[j][i] = this.distance[i][j];
                ++j;
            }
            ++i;
        }
        this.idGroup = subset;
    }

    public void printPHYLIP(PrintWriter out) {
        out.println("  " + this.distance.length);
        FormattedOutput format = FormattedOutput.getInstance();
        int i = 0;
        while (i < this.distance.length) {
            format.displayLabel(out, this.idGroup.getIdentifier(i).getName(), 10);
            out.print("      ");
            int j = 0;
            while (j < this.distance.length) {
                if (j % 6 == 0 && j != 0) {
                    out.println();
                    out.print("                ");
                }
                out.print("  ");
                format.displayDecimal(out, this.distance[i][j], 5);
                ++j;
            }
            out.println();
            ++i;
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.printPHYLIP(new PrintWriter(sw));
        return sw.toString();
    }

    public double squaredDistance(DistanceMatrix mat, boolean weighted) {
        double sum = 0.0;
        int i = 0;
        while (i < this.distance.length - 1) {
            int j = i + 1;
            while (j < this.distance.length) {
                double diff = this.distance[i][j] - mat.distance[i][j];
                double weight = weighted ? 1.0 / (this.distance[i][j] * this.distance[i][j]) : 1.0;
                sum += weight * diff * diff;
                ++j;
            }
            ++i;
        }
        return 2.0 * sum;
    }

    public double absoluteDistance(DistanceMatrix mat) {
        double sum = 0.0;
        int i = 0;
        while (i < this.distance.length - 1) {
            int j = i + 1;
            while (j < this.distance.length) {
                double diff = Math.abs(this.distance[i][j] - mat.distance[i][j]);
                sum += diff;
                ++j;
            }
            ++i;
        }
        return 2.0 * sum;
    }

    public int getSize() {
        return this.distance.length;
    }

    public final double[][] getClonedDistances() {
        return Utils.getCopy(this.distance);
    }

    protected final double[][] getDistances() {
        return Utils.getCopy(this.distance);
    }

    public final double getDistance(int row, int col) {
        return this.distance[row][col];
    }

    public void setDistance(int i, int j, double dist) {
        double d = dist;
        this.distance[j][i] = d;
        this.distance[i][j] = d;
    }

    public void addDistance(int i, int j, double delta) {
        double[] dArray = this.distance[i];
        int n = j;
        dArray[n] = dArray[n] + delta;
        double[] dArray2 = this.distance[j];
        int n2 = i;
        dArray2[n2] = dArray2[n2] + delta;
    }

    public double meanDistance() {
        double dist = 0.0;
        int count = 0;
        int i = 0;
        while (i < this.distance.length) {
            int j = 0;
            while (j < this.distance[i].length) {
                if (i != j) {
                    dist += this.distance[i][j];
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return dist / (double)count;
    }

    public Identifier getIdentifier(int i) {
        return this.idGroup.getIdentifier(i);
    }

    public void setIdentifier(int i, Identifier ident) {
        this.idGroup.setIdentifier(i, ident);
    }

    public int getIdCount() {
        return this.idGroup.getIdCount();
    }

    public int whichIdNumber(String name) {
        return this.idGroup.whichIdNumber(name);
    }

    public IdGroup getIdGroup() {
        return this.idGroup;
    }

    public boolean isSymmetric() {
        int i = 0;
        while (i < this.distance.length) {
            if (this.distance[i][i] != 0.0) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.distance.length - 1) {
            int j = i2 + 1;
            while (j < this.distance.length) {
                if (this.distance[i2][j] != this.distance[j][i2]) {
                    return false;
                }
                ++j;
            }
            ++i2;
        }
        return true;
    }

    public int getClosestIndex(String fromID, String[] exclusion) {
        int[] exclusionIndexes;
        int index = this.whichIdNumber(fromID);
        if (index < 0) {
            return -1;
        }
        if (exclusion == null) {
            exclusionIndexes = null;
        } else {
            exclusionIndexes = new int[exclusion.length];
            int i = 0;
            while (i < exclusion.length) {
                exclusionIndexes[i] = this.whichIdNumber(exclusion[i]);
                ++i;
            }
        }
        return this.getClosestIndex(index, exclusionIndexes);
    }

    private final boolean isIn(int value, int[] set) {
        if (set == null) {
            return false;
        }
        int i = 0;
        while (i < set.length) {
            if (set[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getClosestIndex(int fromIndex, int[] exclusion) {
        double min = Double.POSITIVE_INFINITY;
        int index = -1;
        int i = 0;
        while (i < this.distance.length) {
            double d;
            if (i != fromIndex && !this.isIn(i, exclusion) && (d = this.distance[fromIndex][i]) < min) {
                min = d;
                index = i;
            }
            ++i;
        }
        return index;
    }

    protected final void setIdGroup(IdGroup base) {
        this.idGroup = new SimpleIdGroup(base);
    }

    protected final void setDistances(double[][] matrix) {
        this.distance = matrix;
    }
}

