/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.AminoAcids;
import pal.datatype.CodonTable;
import pal.datatype.CodonTableFactory;
import pal.datatype.Codons;
import pal.datatype.IUPACNucleotides;
import pal.datatype.MolecularDataType;
import pal.misc.Utils;

public class SpecificAminoAcids
extends AminoAcids
implements MolecularDataType {
    private final CodonTable translationTable_;

    public SpecificAminoAcids() {
        this(CodonTableFactory.createUniversalTranslator());
    }

    public SpecificAminoAcids(CodonTable translationTable) {
        this.translationTable_ = translationTable;
    }

    public SpecificAminoAcids(int organismTypeID) {
        this(CodonTableFactory.createTranslator(organismTypeID));
    }

    public int getOrganismTypeID() {
        return this.translationTable_.getOrganismTypeID();
    }

    public int[] getNucleotideStates(int[] residueStates) {
        int[] nucleotideStates = new int[residueStates.length * 3];
        int base = 0;
        int i = 0;
        while (i < residueStates.length) {
            int[] codon = this.translationTable_.getStatesFromAminoAcidState(residueStates[i]);
            System.arraycopy(codon, 0, nucleotideStates, base, 3);
            base += 3;
            ++i;
        }
        return nucleotideStates;
    }

    public final int[] getMolecularStatesFromIUPACNucleotides(int[] nucleotideStates, int startingIndex) {
        return this.getMolecularStatesFromSimpleNucleotides(IUPACNucleotides.getSimpleStates(nucleotideStates), startingIndex);
    }

    public final int[] getMolecularStatesFromSimpleNucleotides(int[] nucleotideStates, int startingIndex) {
        System.out.println("NS:" + Utils.toString(nucleotideStates));
        int[] residueStates = new int[(nucleotideStates.length - startingIndex) / 3];
        int base = startingIndex;
        int i = 0;
        while (i < residueStates.length) {
            int codonState = Codons.getCodonIndexFromNucleotideStates(nucleotideStates, base);
            residueStates[i] = codonState < 0 || codonState > 63 ? -1 : this.translationTable_.getAminoAcidStateFromCodonIndex(codonState);
            base += 3;
            ++i;
        }
        return residueStates;
    }

    public boolean isCreatesIUPACNuecleotides() {
        return false;
    }

    public final int getNucleotideLength() {
        return 3;
    }
}

