/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.Serializable;
import pal.datatype.AmbiguousDataType;
import pal.datatype.AminoAcids;
import pal.datatype.Codons;
import pal.datatype.GapBalanced;
import pal.datatype.IUPACNucleotides;
import pal.datatype.Nucleotides;
import pal.datatype.NumericDataType;
import pal.datatype.TwoStates;

public interface DataType
extends Serializable {
    public static final char UNKNOWN_CHARACTER = '?';
    public static final String UNKNOWN_TLA = "???";
    public static final char PRIMARY_SUGGESTED_GAP_CHARACTER = '-';
    public static final char[] SUGGESTED_GAP_CHARACTERS = new char[]{'-', '_', '.'};
    public static final int SUGGESTED_GAP_STATE = -2;
    public static final int SUGGESTED_UNKNOWN_STATE = -1;
    public static final int NUCLEOTIDES = 0;
    public static final int AMINOACIDS = 1;
    public static final int TWOSTATES = 2;
    public static final int IUPACNUCLEOTIDES = 3;
    public static final int CODONS = 4;
    public static final int GAP_BALANCED = 5;
    public static final int NUMERIC = 6;
    public static final int UNKNOWN = 100;
    public static final String NUCLEOTIDE_DESCRIPTION = "nucleotide";
    public static final String AMINO_ACID_DESCRIPTION = "amino acid";
    public static final String TWO_STATE_DESCRIPTION = "binary";
    public static final String IUPAC_NUCELOTIDES_DESCRIPTION = "nucleotide";
    public static final String CODON_DESCRIPTION = "codon";
    public static final String GAP_BALANCED_DESCRIPTION = "gap balanced";

    public int getNumStates();

    public int getState(char var1);

    public char getChar(int var1);

    public char getPreferredChar(char var1);

    public String getDescription();

    public int getTypeID();

    public boolean isUnknownState(int var1);

    public boolean isUnknownChar(char var1);

    public int getRecommendedUnknownState();

    public boolean hasGap();

    public boolean isGapChar(char var1);

    public boolean isGapState(int var1);

    public int getRecommendedGapState();

    public boolean isAmbiguous();

    public AmbiguousDataType getAmbiguousVersion();

    public static final class Utils {
        public static final boolean isSuggestedGap(char c) {
            int i = 0;
            while (i < SUGGESTED_GAP_CHARACTERS.length) {
                if (c == SUGGESTED_GAP_CHARACTERS[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public static DataType getInstance(int typeID) {
            switch (typeID) {
                case 0: {
                    return Nucleotides.DEFAULT_INSTANCE;
                }
                case 1: {
                    return AminoAcids.DEFAULT_INSTANCE;
                }
                case 2: {
                    return TwoStates.DEFAULT_INSTANCE;
                }
                case 3: {
                    return IUPACNucleotides.DEFAULT_INSTANCE;
                }
                case 4: {
                    return Codons.DEFAULT_INSTANCE;
                }
                case 5: {
                    return GapBalanced.DEFAULT_INSTANCE;
                }
                case 6: {
                    return NumericDataType.DEFAULT_INSTANCE;
                }
            }
            throw new IllegalArgumentException("typeID " + typeID + " is not recognised.");
        }

        public static final boolean isGap(DataType d, char c) {
            return d.isGapChar(c);
        }

        public static final char[] getPreferredChars(char[] sequence, DataType dt) {
            return Utils.getPreferredChars(sequence, dt, false);
        }

        public static final char[] getPreferredChars(char[] sequence, DataType dt, boolean specialDots) {
            char[] result = new char[sequence.length];
            int i = 0;
            while (i < result.length) {
                result[i] = specialDots && sequence[i] == '.' ? 46 : dt.getPreferredChar(sequence[i]);
                ++i;
            }
            return result;
        }

        public static final String getPreferredChars(String sequence, DataType dt) {
            return new String(Utils.getPreferredChars(sequence.toCharArray(), dt));
        }

        public static final String getPreferredChars(String sequence, DataType dt, boolean specialDots) {
            return new String(Utils.getPreferredChars(sequence.toCharArray(), dt, specialDots));
        }

        public static final byte[] getByteStates(String sequence, DataType dt) {
            return Utils.getByteStates(sequence.toCharArray(), dt);
        }

        public static final byte[] getByteStates(char[] sequence, DataType dt) {
            byte[] bs = new byte[sequence.length];
            int i = 0;
            while (i < bs.length) {
                bs[i] = (byte)dt.getState(sequence[i]);
                ++i;
            }
            return bs;
        }

        public static final int[][] getStates(char[][] sequences, int unknownState, int gapState, DataType dt) {
            int[][] statesSeqs = new int[sequences.length][];
            int i = 0;
            while (i < statesSeqs.length) {
                statesSeqs[i] = Utils.getStates(sequences[i], unknownState, gapState, dt);
                ++i;
            }
            return statesSeqs;
        }

        public static final int[] getStates(char[] sequence, int unknownState, int gapState, DataType dt) {
            int[] states = new int[sequence.length];
            int i = 0;
            while (i < states.length) {
                int state = dt.getState(sequence[i]);
                states[i] = dt.isGapState(state) ? gapState : (dt.isUnknownState(state) ? unknownState : state);
                ++i;
            }
            return states;
        }

        public static final int[][] getStates(char[][] sequences, DataType dt) {
            int[][] statesSeqs = new int[sequences.length][];
            int i = 0;
            while (i < statesSeqs.length) {
                statesSeqs[i] = Utils.getStates(sequences[i], dt);
                ++i;
            }
            return statesSeqs;
        }

        public static final int[] getStates(char[] sequence, DataType dt) {
            int[] states = new int[sequence.length];
            int i = 0;
            while (i < states.length) {
                states[i] = dt.getState(sequence[i]);
                ++i;
            }
            return states;
        }

        public static final char[][] getChars(int[][] sequences, char unknownChar, char gapChar, DataType dt) {
            char[][] charSeqs = new char[sequences.length][];
            int i = 0;
            while (i < charSeqs.length) {
                charSeqs[i] = Utils.getChars(sequences[i], unknownChar, gapChar, dt);
                ++i;
            }
            return charSeqs;
        }

        public static final char[] getChars(int[] sequence, char unknownChar, char gapChar, DataType dt) {
            char[] chars = new char[sequence.length];
            int i = 0;
            while (i < chars.length) {
                int state = sequence[i];
                chars[i] = dt.isGapState(state) ? gapChar : (dt.isUnknownState(state) ? unknownChar : dt.getChar(state));
                ++i;
            }
            return chars;
        }

        public static final char[] getChars(int[] sequence, DataType dt) {
            char[] chars = new char[sequence.length];
            int i = 0;
            while (i < chars.length) {
                chars[i] = dt.getChar(sequence[i]);
                ++i;
            }
            return chars;
        }

        public static final String toString(DataType dt, int[] states) {
            char[] chars = new char[states.length];
            int i = 0;
            while (i < states.length) {
                chars[i] = dt.getChar(states[i]);
                ++i;
            }
            return new String(chars);
        }

        public static final void reverseSequence(int[] sequence) {
            int midPoint = sequence.length / 2;
            int i = 0;
            while (i < midPoint) {
                int j = sequence.length - i - 1;
                int temp = sequence[i];
                sequence[i] = sequence[j];
                sequence[j] = temp;
                ++i;
            }
        }

        public static final void leftAlignSequence(int[] sequence, DataType dt) {
            int startingIndex = -1;
            int i = 0;
            while (i < sequence.length) {
                int state = sequence[i];
                if (!dt.isUnknownState(state) && !dt.isGapState(state)) {
                    startingIndex = i;
                    break;
                }
                ++i;
            }
            int length = sequence.length - startingIndex;
            if (startingIndex > 0) {
                System.arraycopy(sequence, startingIndex, sequence, 0, length);
            }
            int gapState = dt.getRecommendedGapState();
            int i2 = length;
            while (i2 < sequence.length) {
                sequence[i2] = gapState;
                ++i2;
            }
        }
    }
}

