/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.CodonTable;

public class CodonTableUtils {
    public static final String convertNucleotideToAminoAcid(String nucleotideSequence, int startingPosition, int length, boolean reverse, CodonTable translator) {
        return CodonTableUtils.convertNucleotideToAminoAcid(nucleotideSequence.toCharArray(), startingPosition, length, reverse, translator).toString();
    }

    public static final char[] convertNucleotideToAminoAcid(char[] nucleotideSequence, int startingPosition, int length, boolean reverse, CodonTable translator) {
        char[] work = new char[3];
        int numberOfAminoAcids = length / 3;
        char[] aas = new char[numberOfAminoAcids];
        if (reverse) {
            int i = 0;
            while (i < numberOfAminoAcids) {
                int index = i * 3 + startingPosition;
                int j = 0;
                while (j < 3) {
                    work[j] = nucleotideSequence[(index + 2 - j) % nucleotideSequence.length];
                    ++j;
                }
                aas[numberOfAminoAcids - i - 1] = translator.getAminoAcidChar(work);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numberOfAminoAcids) {
                int index = i * 3 + startingPosition;
                int j = 0;
                while (j < 3) {
                    work[j] = nucleotideSequence[(index + j) % nucleotideSequence.length];
                    ++j;
                }
                aas[i] = translator.getAminoAcidChar(work);
                ++i;
            }
        }
        return aas;
    }
}

