/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import java.io.Serializable;

public interface CodonTable
extends Serializable {
    public static final int UNIVERSAL = 0;
    public static final int VERTEBRATE_MITOCHONDRIAL = 1;
    public static final int YEAST = 2;
    public static final int MOLD_PROTOZOAN_MITOCHONDRIAL = 3;
    public static final int MYCOPLASMA = 4;
    public static final int INVERTEBRATE_MITOCHONDRIAL = 5;
    public static final int CILATE = 6;
    public static final int ECHINODERM_MITOCHONDRIAL = 7;
    public static final int EUPLOTID_NUCLEAR = 8;
    public static final int ASCIDIAN_MITOCHONDRIAL = 9;
    public static final int FLATWORM_MITOCHONDRIAL = 10;
    public static final int BLEPHARISMA_NUCLEAR = 11;
    public static final int BACTERIAL = 12;
    public static final int ALTERNATIVE_YEAST = 13;
    public static final String[] ORGANISM_TYPE_NAMES = new String[]{"Universal", "Vertebrate Mitochondrial", "Yeast", "Mold Protozoan Mitochondrial", "Mycoplasma", "Invertebrate Mitochondrial", "Cilate", "Echinoderm Mitochondrial", "Euplotid Nuclear", "Ascidian Mitochondrial", "Flatworm Mitochondrial", "Blepharisma Nuclear", "Bacterial", "Alternative Yeast"};

    public char getAminoAcidChar(char[] var1);

    public int getAminoAcidState(char[] var1);

    public char[][] getCodonsFromAminoAcidState(int var1);

    public char[][] getCodonsFromAminoAcidChar(char var1);

    public char getAminoAcidCharFromCodonIndex(int var1);

    public int getAminoAcidStateFromCodonIndex(int var1);

    public int[] getIUPACStatesFromAminoAcidState(int var1);

    public int[] getStatesFromAminoAcidState(int var1);

    public int getAminoAcidStateFromStates(int[] var1);

    public int[] getTerminatorIndexes();

    public int getNumberOfTerminatorIndexes();

    public int getOrganismTypeID();

    public boolean isSynonymous(int var1, int var2);
}

