/*
 * Decompiled with CFR 0.152.
 */
package pal.datatype;

import pal.datatype.SimpleDataType;

public class AminoAcids
extends SimpleDataType {
    private static final long serialVersionUID = -466623855742195043L;
    public static final AminoAcids DEFAULT_INSTANCE = new AminoAcids();
    public static final char TERMINATE_CHARACTER = '*';
    public static final int TERMINATE_STATE = 21;
    static final char[] CONVERSION_TABLE = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', '?', '*'};
    private static final String TERMINATE_TLA = "***";
    private static final String[] TLA_NAMES_BY_STATE = new String[]{"ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "???", "***"};

    public int getNumStates() {
        return 20;
    }

    protected int getStateImpl(char c) {
        switch (c) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 4;
            }
            case 'D': {
                return 3;
            }
            case 'E': {
                return 6;
            }
            case 'F': {
                return 13;
            }
            case 'G': {
                return 7;
            }
            case 'H': {
                return 8;
            }
            case 'I': {
                return 9;
            }
            case 'K': {
                return 11;
            }
            case 'L': {
                return 10;
            }
            case 'M': {
                return 12;
            }
            case 'N': {
                return 2;
            }
            case 'P': {
                return 14;
            }
            case 'Q': {
                return 5;
            }
            case 'R': {
                return 1;
            }
            case 'S': {
                return 15;
            }
            case 'T': {
                return 16;
            }
            case 'V': {
                return 19;
            }
            case 'W': {
                return 17;
            }
            case 'Y': {
                return 18;
            }
            case '?': {
                return 20;
            }
            case '*': {
                return 21;
            }
            case 'a': {
                return 0;
            }
            case 'c': {
                return 4;
            }
            case 'd': {
                return 3;
            }
            case 'e': {
                return 6;
            }
            case 'f': {
                return 13;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'i': {
                return 9;
            }
            case 'k': {
                return 11;
            }
            case 'l': {
                return 10;
            }
            case 'm': {
                return 12;
            }
            case 'n': {
                return 2;
            }
            case 'p': {
                return 14;
            }
            case 'q': {
                return 5;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 15;
            }
            case 't': {
                return 16;
            }
            case 'v': {
                return 19;
            }
            case 'w': {
                return 17;
            }
            case 'y': {
                return 18;
            }
        }
        return 20;
    }

    protected char getCharImpl(int state) {
        if (state < CONVERSION_TABLE.length && state >= 0) {
            return CONVERSION_TABLE[state];
        }
        return '?';
    }

    protected boolean isUnknownStateImpl(int state) {
        return state >= 20 || state < 0;
    }

    public String getDescription() {
        return "amino acid";
    }

    public int getTypeID() {
        return 1;
    }

    public static final String getTLA(int state) {
        if (state < 0 || state >= TLA_NAMES_BY_STATE.length) {
            return "???";
        }
        return TLA_NAMES_BY_STATE[state];
    }
}

