/*
 * Decompiled with CFR 0.152.
 */
package pal.coalescent;

import pal.coalescent.CoalescentIntervals;
import pal.coalescent.DemographicModel;
import pal.coalescent.DemographicTree;
import pal.coalescent.IntervalsExtractor;
import pal.tree.ClockTree;
import pal.tree.NodeUtils;
import pal.tree.Tree;

public class DemographicClockTree
extends ClockTree
implements DemographicTree {
    DemographicModel model;

    public DemographicClockTree(Tree t, DemographicModel model) {
        this.setBaseTree(t);
        this.model = model;
        if (t.getRoot().getChildCount() < 2) {
            throw new IllegalArgumentException("The root node must have at least two childs!");
        }
        NodeUtils.heights2Lengths(this.getRoot());
        this.parameter = new double[this.getInternalNodeCount() + model.getNumParameters()];
        this.heights2parameters();
    }

    public double computeDemoLogLikelihood() {
        CoalescentIntervals ci = IntervalsExtractor.extractFromTree(this);
        double value = ci.computeLogLikelihood(this.model);
        return value;
    }

    public int getNumParameters() {
        return this.getInternalNodeCount() + this.model.getNumParameters();
    }

    protected void parameters2Heights() {
        super.parameters2Heights();
        int i = 0;
        while (i < this.model.getNumParameters()) {
            this.model.setParameter(this.parameter[this.getInternalNodeCount() + i], i);
            ++i;
        }
    }

    protected void heights2parameters() {
        super.heights2parameters();
        if (this.model != null) {
            int i = 0;
            while (i < this.model.getNumParameters()) {
                this.parameter[this.getInternalNodeCount() + i] = this.model.getParameter(i);
                ++i;
            }
        }
    }

    public DemographicModel getDemographicModel() {
        return this.model;
    }
}

