/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pal.alignment.AbstractAlignment;
import pal.alignment.Alignment;
import pal.datatype.DataType;
import pal.misc.IdGroup;
import pal.misc.Identifier;
import pal.misc.LabelMapping;
import pal.misc.SimpleIdGroup;

public class SimpleAlignment
extends AbstractAlignment {
    String[] sequences;
    private static final long serialVersionUID = 4303224913340358191L;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.sequences);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            default: 
        }
        this.sequences = (String[])in.readObject();
    }

    public SimpleAlignment() {
    }

    public SimpleAlignment(Alignment a) {
        this(a, null);
    }

    public SimpleAlignment(Alignment a, LabelMapping lm) {
        String[] sequences = new String[a.getIdCount()];
        this.setDataType(a.getDataType());
        int i = 0;
        while (i < sequences.length) {
            sequences[i] = a.getAlignedSequenceString(i);
            ++i;
        }
        if (lm == null) {
            this.init(new SimpleIdGroup(a), sequences, "_-?.");
        } else {
            this.init(lm.getMapped(a), sequences, "_-?.");
        }
    }

    public SimpleAlignment(Alignment a, int sequenceToIgnore) {
        int numberOfOriginalSequences = a.getIdCount();
        this.setDataType(a.getDataType());
        String[] sequences = sequenceToIgnore < 0 || sequenceToIgnore >= numberOfOriginalSequences ? new String[numberOfOriginalSequences] : new String[numberOfOriginalSequences - 1];
        int index = 0;
        int i = 0;
        while (i < numberOfOriginalSequences) {
            if (i != sequenceToIgnore) {
                sequences[index++] = a.getAlignedSequenceString(i);
            }
            ++i;
        }
        this.init(new SimpleIdGroup((IdGroup)a, sequenceToIgnore), sequences, "_-?.");
    }

    public SimpleAlignment(Identifier[] ids, String[] sequences, String gaps, DataType dt) {
        this.setDataType(dt);
        this.init(new SimpleIdGroup(ids), sequences, gaps);
    }

    public SimpleAlignment(IdGroup ids, String[] sequences, DataType dt) {
        this(ids, sequences, null, dt);
    }

    public SimpleAlignment(IdGroup ids, String[] sequences, String gaps, DataType dt) {
        this.setDataType(dt);
        this.init(new SimpleIdGroup(ids), sequences, gaps);
    }

    public SimpleAlignment(Identifier[] ids, String[] sequences, DataType dt) {
        this(ids, sequences, null, dt);
    }

    public SimpleAlignment(IdGroup group, char[][] cSequences, DataType dt) {
        this(group, cSequences, "_-?.", dt);
    }

    public SimpleAlignment(IdGroup group, DataType dt, int[][] sSequences) {
        this(group, DataType.Utils.getChars(sSequences, '?', '-', dt), "-", dt);
    }

    public SimpleAlignment(IdGroup group, char[][] cSequences, String gaps, DataType dt) {
        this.setDataType(dt);
        String[] sequences = new String[cSequences.length];
        int i = 0;
        while (i < sequences.length) {
            sequences[i] = new String(cSequences[i]);
            ++i;
        }
        this.init(group, sequences, gaps);
    }

    private void init(IdGroup group, String[] sequences, String gaps) {
        sequences = SimpleAlignment.getPadded(sequences);
        this.numSeqs = sequences.length;
        this.numSites = sequences[0].length();
        this.sequences = sequences;
        this.idGroup = group;
        if (gaps != null) {
            this.convertGaps(gaps);
        }
    }

    public SimpleAlignment(Identifier id, String sequence, DataType dataType) {
        this.setDataType(dataType);
        this.numSeqs = 1;
        this.numSites = sequence.length();
        this.sequences = new String[1];
        this.sequences[0] = sequence;
        Identifier[] ids = new Identifier[]{id};
        this.idGroup = new SimpleIdGroup(ids);
    }

    public SimpleAlignment(Alignment a, Alignment b, String guide1, String guide2, char gap) {
        this.sequences = new String[a.getSequenceCount() + b.getSequenceCount()];
        this.numSeqs = this.sequences.length;
        int i = 0;
        while (i < a.getSequenceCount()) {
            this.sequences[i] = this.getAlignedString(a.getAlignedSequenceString(i), guide1, gap, '-');
            ++i;
        }
        int i2 = 0;
        while (i2 < b.getSequenceCount()) {
            this.sequences[i2 + a.getSequenceCount()] = this.getAlignedString(b.getAlignedSequenceString(i2), guide2, gap, '-');
            ++i2;
        }
        this.numSites = this.sequences[0].length();
        this.idGroup = new SimpleIdGroup((IdGroup)a, b);
    }

    public char getData(int seq, int site) {
        return this.sequences[seq].charAt(site);
    }

    public String getAlignedSequenceString(int seq) {
        return this.sequences[seq];
    }

    private String getAlignedString(String original, String guide, char guideChar, char gapChar) {
        StringBuffer buf = new StringBuffer(guide.length());
        int seqcounter = 0;
        int j = 0;
        while (j < guide.length()) {
            if (guide.charAt(j) != guideChar) {
                buf.append(original.charAt(seqcounter));
                ++seqcounter;
            } else {
                buf.append(gapChar);
            }
            ++j;
        }
        return new String(buf);
    }

    private static final String getPadded(String s, int length) {
        StringBuffer sb = new StringBuffer();
        sb.append(s);
        int i = s.length();
        while (i < length) {
            sb.append('-');
            ++i;
        }
        return sb.toString();
    }

    private static final String[] getPadded(String[] sequences) {
        String[] padded = new String[sequences.length];
        int maxLength = 0;
        int i = 0;
        while (i < sequences.length) {
            maxLength = Math.max(maxLength, sequences[i].length());
            ++i;
        }
        int i2 = 0;
        while (i2 < sequences.length) {
            padded[i2] = SimpleAlignment.getPadded(sequences[i2], maxLength);
            ++i2;
        }
        return padded;
    }

    private void convertGaps(String gaps) {
        int i = 0;
        while (i < this.sequences.length) {
            int j = 0;
            while (j < gaps.length()) {
                this.sequences[i] = this.sequences[i].replace(gaps.charAt(j), '-');
                ++j;
            }
            ++i;
        }
    }
}

