/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.Vector;
import pal.alignment.AbstractAlignment;
import pal.alignment.AlignmentParseException;
import pal.io.FormattedInput;
import pal.io.InputSource;
import pal.misc.Identifier;
import pal.misc.SimpleIdGroup;

public class ReadAlignmentOld
extends AbstractAlignment {
    private int lineLength;
    private Vector names;
    private Vector seqs;
    private Vector sites;
    private FormattedInput fi = FormattedInput.getInstance();
    private char[][] data = null;

    public ReadAlignmentOld(PushbackReader input) throws AlignmentParseException, IOException {
        this.readFile(input);
    }

    public ReadAlignmentOld(String file) throws AlignmentParseException, IOException {
        InputSource input = InputSource.openFile(file);
        this.readFile(input);
        input.close();
    }

    public char getData(int seq, int site) {
        return this.data[seq][site];
    }

    private final boolean isType(PushbackReader in, String id) throws IOException {
        int i = 0;
        while (i < id.length()) {
            int c = this.fi.readNextChar(in);
            if (c != id.charAt(i)) {
                in.unread(c);
                return false;
            }
            ++i;
        }
        return true;
    }

    private void readFile(PushbackReader in) throws AlignmentParseException, IOException {
        if (this.isType(in, "CLUSTAL")) {
            this.fi.nextLine(in);
            this.readCLUSTALW(in);
        } else if (this.isType(in, "#NEXUS") || this.isType(in, "#nexus")) {
            this.readNEXUS(in);
        } else {
            this.readPHYLIP(in);
        }
        int i = 0;
        while (i < this.numSeqs) {
            int j = 0;
            while (j < this.numSites) {
                this.data[i][j] = Character.toUpperCase(this.data[i][j]);
                ++j;
            }
            ++i;
        }
        this.guessDataType();
    }

    private void readNEXUS(PushbackReader in) throws AlignmentParseException {
        int EOF = -1;
        int seq = 0;
        int pos = 0;
        try {
            this.names = new Vector();
            this.seqs = new Vector();
            boolean seqsOK = false;
            boolean sitesOK = false;
            String tempWord = null;
            tempWord = this.fi.readWord(in);
            while (!seqsOK || !sitesOK) {
                if (tempWord.length() >= 5) {
                    int stringSize;
                    if (tempWord.substring(0, 5).equals("nchar") || tempWord.substring(0, 5).equals("NCHAR")) {
                        stringSize = tempWord.length();
                        if (tempWord.substring(stringSize - 1).equals(";")) {
                            --stringSize;
                        }
                        this.numSites = new Integer(tempWord.substring(6, stringSize));
                        sitesOK = true;
                    } else if (tempWord.substring(0, 4).equals("ntax") || tempWord.substring(0, 4).equals("NTAX")) {
                        stringSize = tempWord.length();
                        if (tempWord.substring(stringSize - 1).equals(";")) {
                            --stringSize;
                        }
                        this.numSeqs = new Integer(tempWord.substring(5, stringSize));
                        seqsOK = true;
                    }
                }
                tempWord = this.fi.readWord(in);
            }
            while (!(tempWord.equals("Format") || tempWord.equals("format") || tempWord.equals("FORMAT"))) {
                this.fi.nextLine(in);
                tempWord = this.fi.readWord(in);
            }
            tempWord = this.fi.readWord(in);
            while (!(tempWord.equals("Matrix") || tempWord.equals("matrix") || tempWord.equals("MATRIX"))) {
                this.fi.nextLine(in);
                tempWord = this.fi.readWord(in);
            }
            this.idGroup = new SimpleIdGroup(this.numSeqs);
            this.data = new char[this.numSeqs][this.numSites];
            seq = 0;
            while (seq < this.numSeqs) {
                int c = this.fi.readNextChar(in);
                in.unread(c);
                this.idGroup.setIdentifier(seq, new Identifier(this.fi.readLabel(in, 30)));
                pos = 0;
                while (pos < this.numSites) {
                    this.data[seq][pos] = (char)this.fi.readNextChar(in);
                    if (this.data[0][pos] == '.') {
                        if (seq == 0) {
                            throw new AlignmentParseException("Copy character (.) in first sequence not allowed (pos. " + (pos + 1) + ")");
                        }
                        this.data[seq][pos] = this.data[0][pos];
                    }
                    ++pos;
                }
                ++seq;
            }
        }
        catch (IOException e) {
            throw new AlignmentParseException("IO error after pos. " + (pos + 1) + ", seq. " + (seq + 1));
        }
    }

    private void readCLUSTALW(PushbackReader in) throws AlignmentParseException {
        int EOF = -1;
        int seq = 0;
        int pos = 0;
        try {
            int c = this.fi.readNextChar(in);
            in.unread(c);
            this.names = new Vector();
            this.seqs = new Vector();
            c = in.read();
            while (!Character.isWhitespace((char)c)) {
                in.unread(c);
                this.names.addElement(this.fi.readLabel(in, 10));
                this.readSeqLineC(in, seq, pos);
                ++seq;
                c = in.read();
            }
            in.unread(c);
            this.fi.nextLine(in);
            pos += this.lineLength;
            this.numSeqs = seq;
            c = this.fi.readNextChar(in);
            in.unread(c);
            while (c != EOF) {
                seq = 0;
                while (seq < this.numSeqs) {
                    do {
                        if ((c = in.read()) >= 0) continue;
                        throw new AlignmentParseException("Unexpected end of file exception!");
                    } while (Character.isWhitespace((char)c));
                    this.readSeqLineC(in, seq, pos);
                    ++seq;
                }
                this.fi.nextLine(in);
                pos += this.lineLength;
                c = this.fi.readNextChar(in);
                in.unread(c);
            }
            this.numSites = pos;
            this.idGroup = new SimpleIdGroup(this.numSeqs);
            this.data = new char[this.numSeqs][this.numSites];
            int i = 0;
            while (i < this.numSeqs) {
                this.idGroup.setIdentifier(i, new Identifier((String)this.names.elementAt(i)));
                ++i;
            }
            int i2 = 0;
            while (i2 < this.numSeqs) {
                int j = 0;
                while (j < this.numSites) {
                    this.data[i2][j] = ((Character)((Vector)this.seqs.elementAt(i2)).elementAt(j)).charValue();
                    ++j;
                }
                ++i2;
            }
            this.names = null;
            int i3 = 0;
            while (i3 < this.numSeqs) {
                ((Vector)this.seqs.elementAt(i3)).removeAllElements();
                ++i3;
            }
            this.seqs = null;
        }
        catch (IOException e) {
            throw new AlignmentParseException("IO error after pos. " + (pos + 1) + ", seq. " + (seq + 1));
        }
    }

    private void readSeqLineC(PushbackReader in, int s, int pos) throws IOException, AlignmentParseException {
        if (pos == 0) {
            this.sites = new Vector();
            this.seqs.addElement(this.sites);
        } else {
            this.sites = (Vector)this.seqs.elementAt(s);
        }
        if (s == 0) {
            String thisLine = this.fi.readLine(in, false);
            this.lineLength = thisLine.length();
            int i = 0;
            while (i < this.lineLength) {
                char c = thisLine.charAt(i);
                if (c == '.') {
                    throw new AlignmentParseException("Copy character (.) in first sequence not allowed (pos. " + (i + pos + 1) + ")");
                }
                this.sites.addElement(new Character(c));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.lineLength) {
                int c = this.fi.readNextChar(in);
                if (c == 46) {
                    c = ((Character)((Vector)this.seqs.elementAt(0)).elementAt(pos + i)).charValue();
                }
                this.sites.addElement(new Character((char)c));
                ++i;
            }
            this.fi.nextLine(in);
        }
    }

    private void readPHYLIP(PushbackReader in) throws AlignmentParseException {
        int pos = 0;
        int seq = 0;
        try {
            this.numSeqs = this.fi.readInt(in);
            this.numSites = this.fi.readInt(in);
            this.idGroup = new SimpleIdGroup(this.numSeqs);
            this.data = new char[this.numSeqs][this.numSites];
            String header = this.fi.readLine(in, false);
            boolean interleaved = true;
            if (header.length() > 0 && header.charAt(0) == 'S') {
                interleaved = false;
            }
            if (interleaved) {
                while (pos < this.numSites) {
                    int c = this.fi.readNextChar(in);
                    in.unread(c);
                    seq = 0;
                    while (seq < this.numSeqs) {
                        this.readSeqLineP(in, seq, pos, this.numSites);
                        ++seq;
                    }
                    pos += this.lineLength;
                }
            } else {
                seq = 0;
                while (seq < this.numSeqs) {
                    int c = this.fi.readNextChar(in);
                    in.unread(c);
                    this.idGroup.setIdentifier(seq, new Identifier(this.fi.readLabel(in, 10)));
                    pos = 0;
                    while (pos < this.numSites) {
                        this.data[seq][pos] = (char)this.fi.readNextChar(in);
                        if (this.data[0][pos] == '.') {
                            if (seq == 0) {
                                throw new AlignmentParseException("Copy character (.) in first sequence not allowed (pos. " + (pos + 1) + ")");
                            }
                            this.data[seq][pos] = this.data[0][pos];
                        }
                        ++pos;
                    }
                    ++seq;
                }
            }
        }
        catch (IOException e) {
            throw new AlignmentParseException("IO error after pos. " + (pos + 1) + ", seq. " + (seq + 1));
        }
    }

    private void readSeqLineP(PushbackReader in, int s, int pos, int maxPos) throws IOException, AlignmentParseException {
        if (pos == 0) {
            this.idGroup.setIdentifier(s, new Identifier(this.fi.readLabel(in, 10)));
        }
        if (s == 0) {
            String thisLine = this.fi.readLine(in, false);
            this.lineLength = thisLine.length() > maxPos - pos ? maxPos - pos : thisLine.length();
            int i = 0;
            while (i < this.lineLength) {
                this.data[0][pos + i] = thisLine.charAt(i);
                if (this.data[0][pos + i] == '.') {
                    throw new AlignmentParseException("Copy character (.) in first sequence not allowed (pos. " + (i + pos + 1) + ")");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.lineLength) {
                this.data[s][pos + i] = (char)this.fi.readNextChar(in);
                if (this.data[s][pos + i] == '.') {
                    this.data[s][pos + i] = this.data[0][pos + i];
                }
                ++i;
            }
            this.fi.nextLine(in);
        }
    }
}

