/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import pal.alignment.Alignment;
import pal.alignment.AlignmentParseException;
import pal.alignment.AlignmentReaders;
import pal.alignment.BootstrappedAlignment;
import pal.alignment.DataTranslator;
import pal.alignment.GapBalancedAlignment;
import pal.datatype.DataType;
import pal.datatype.SpecificAminoAcids;

public final class AlignmentTool {
    public static final Alignment createBootstrapReplicate(Alignment base) {
        return new BootstrappedAlignment(base);
    }

    public static final Alignment createGapBalanced(Alignment base, int startingIndex) {
        return new GapBalancedAlignment(base, startingIndex, true);
    }

    public static final Alignment convertToUniversalAminoAcids(Alignment base, int startingIndex) {
        DataTranslator dt = new DataTranslator(base);
        return dt.toAlignment(new SpecificAminoAcids(0), startingIndex);
    }

    public static final Alignment readAlignment(Reader r, DataType dt) throws IOException {
        BufferedReader br = new BufferedReader(r);
        try {
            return AlignmentReaders.readPhylipClustalAlignment(br, dt);
        }
        catch (AlignmentParseException e) {
            br.reset();
            return AlignmentReaders.readFastaSequences(br, dt);
        }
    }
}

