/*
 * Decompiled with CFR 0.152.
 */
package pal.alignment;

import pal.alignment.Alignment;
import pal.alignment.BootstrappedAlignment;
import pal.util.AlgorithmCallback;

public interface AlignmentGenerator {
    public Alignment getNextAlignment(AlgorithmCallback var1);

    public static final class Utils {
        public static final AlignmentGenerator createBootstrapGenerator(Alignment baseAlignment) {
            return new BootstrapGenerator(baseAlignment);
        }

        private static final class BootstrapGenerator
        implements AlignmentGenerator {
            private final Alignment baseAlignment_;

            public BootstrapGenerator(Alignment baseAlignment) {
                this.baseAlignment_ = baseAlignment;
            }

            public Alignment getNextAlignment(AlgorithmCallback callback) {
                return new BootstrappedAlignment(this.baseAlignment_);
            }
        }
    }
}

