/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.maxent.Regularizer;
import java.util.Arrays;

public class WeightEliminationRegularizer
implements Regularizer {
    public double SIGMA1 = 1.0;
    public double SIGMA2 = 2.0;

    WeightEliminationRegularizer() {
        System.out.println("Weight-elimination regularizer: sigma_1 = " + this.SIGMA1 + ", sigma_2 = " + this.SIGMA2);
    }

    WeightEliminationRegularizer(double d, double d2) {
        this.SIGMA1 = d;
        this.SIGMA2 = d2;
        System.out.println("Weight-elimination regularizer: sigma_1 = " + this.SIGMA1 + ", sigma_2 = " + this.SIGMA2);
    }

    @Override
    public double logValue(double[] dArray) {
        double d = 0.0;
        double d2 = Math.pow(this.SIGMA2, 2.0) / Math.pow(this.SIGMA1, 2.0);
        for (int i = dArray.length - 1; i >= 0; --i) {
            d += -d2 * (Math.pow(dArray[i], 2.0) / (Math.pow(this.SIGMA2, 2.0) + Math.pow(dArray[i], 2.0)));
        }
        return d;
    }

    @Override
    public double[] grad(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double d = Math.pow(this.SIGMA2, 2.0) / Math.pow(this.SIGMA1, 2.0);
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = -d * (dArray[i] / Math.pow(Math.pow(this.SIGMA2, 2.0) + Math.pow(dArray[i], 2.0), 2.0));
        }
        return dArray2;
    }

    @Override
    public double[] grad(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = Math.pow(this.SIGMA2, 2.0) / Math.pow(this.SIGMA1, 2.0);
        for (int i = n - 1; i >= 0; --i) {
            dArray2[i] = -d * (dArray[i] / Math.pow(Math.pow(this.SIGMA2, 2.0) + Math.pow(dArray[i], 2.0), 2.0));
        }
        return dArray2;
    }

    public static void main(String[] stringArray) throws Exception {
        double[] dArray = new double[]{0.5, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        WeightEliminationRegularizer weightEliminationRegularizer = new WeightEliminationRegularizer(1.0, 2.0);
        System.out.println(weightEliminationRegularizer.logValue(dArray));
        System.out.println(Arrays.toString(weightEliminationRegularizer.grad(dArray)));
    }
}

