/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Alphabet;
import edu.ucla.fsm.Corpus;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.ConstraintEvaluator;
import edu.ucla.maxent.Maxent;

public class ObservedOverExpectedConstraintEvaluator
extends ConstraintEvaluator {
    Alphabet alphabet = null;
    Corpus data = null;
    Corpus sample = null;
    double FLOOR = 0.33;
    double SMOOTH = 1.0;

    @Override
    public void setData(Corpus corpus) {
        this.data = corpus;
    }

    @Override
    public void setSample(Corpus corpus) {
        this.sample = corpus;
    }

    @Override
    public double floor() {
        return this.FLOOR;
    }

    @Override
    public double apply(Constraint constraint) {
        double d = (double)constraint.evaluateCorpus() * Maxent.scale;
        double d2 = (double)constraint.evaluateSample() * Maxent.scale;
        d2 = d2 / (double)Maxent.sample.size * (double)Maxent.corpus.size;
        return (d + this.SMOOTH) / (d2 + this.SMOOTH);
    }

    @Override
    public double apply(Constraint constraint, double d, double d2) {
        double d3 = d * (double)Maxent.corpus.size * Maxent.scale;
        double d4 = d2 * (double)Maxent.corpus.size * Maxent.scale;
        return (d3 + this.SMOOTH) / (d4 + this.SMOOTH);
    }

    @Override
    public double compare(double d, double d2) {
        if (d < d2) {
            return -1.0;
        }
        if (d > d2) {
            return 1.0;
        }
        return 0.0;
    }
}

