/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.maxent.MaxentModel;
import java.util.Arrays;
import pal.math.ConjugateDirectionSearch;
import pal.math.ConjugateGradientSearch;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;

public class MaxentTrainer {
    MultivariateMinimum optimizer = null;
    double MIN = Double.MIN_VALUE;
    boolean useGradient = true;

    public MaxentTrainer() {
        if (this.useGradient) {
            this.optimizer = new ConjugateGradientSearch(2);
            ((ConjugateGradientSearch)this.optimizer).defaultStep = 0.25;
            this.optimizer.maxFun = 500;
            this.optimizer.numFuncStops = 500;
            ((ConjugateGradientSearch)this.optimizer).prin = 0;
        } else {
            this.optimizer = new ConjugateDirectionSearch();
            ((ConjugateDirectionSearch)this.optimizer).step = 0.25;
            this.optimizer.maxFun = 500;
            this.optimizer.numFuncStops = 500;
            ((ConjugateDirectionSearch)this.optimizer).prin = 0;
        }
    }

    public MaxentTrainer(double d, int n, int n2, int n3) {
        if (this.useGradient) {
            this.optimizer = new ConjugateGradientSearch(2);
            ((ConjugateGradientSearch)this.optimizer).defaultStep = d;
            this.optimizer.maxFun = n;
            this.optimizer.numFuncStops = n2;
            ((ConjugateGradientSearch)this.optimizer).prin = n3;
        } else {
            this.optimizer = new ConjugateDirectionSearch();
            ((ConjugateDirectionSearch)this.optimizer).step = 0.25;
            this.optimizer.maxFun = 500;
            this.optimizer.numFuncStops = 500;
            ((ConjugateDirectionSearch)this.optimizer).prin = 0;
        }
    }

    public void apply(MaxentModel maxentModel) {
        this.apply(maxentModel, null);
    }

    public void apply(MaxentModel maxentModel, double[] dArray) {
        double[] dArray2 = new double[maxentModel.getNumArguments()];
        if (dArray == null) {
            Arrays.fill(dArray2, 1.0);
        } else {
            System.arraycopy(dArray, 0, dArray2, 0, dArray2.length);
        }
        maxentModel.setWeights(dArray2);
        this.optimizer.optimize((MultivariateFunction)maxentModel, dArray2, this.MIN, this.MIN, null);
        maxentModel.setWeights(dArray2);
    }
}

