/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.maxent;

import edu.ucla.fsm.Alphabet;
import edu.ucla.fsm.ConstraintCompiler;
import edu.ucla.fsm.Corpus;
import edu.ucla.fsm.ExpectationSemiring;
import edu.ucla.fsm.ExpectationSemiringWeight;
import edu.ucla.fsm.FSM;
import edu.ucla.fsm.FSMQuick;
import edu.ucla.fsm.IntegerWeight;
import edu.ucla.fsm.Intersect;
import edu.ucla.fsm.LexicographicSemiring;
import edu.ucla.fsm.LexicographicWeight;
import edu.ucla.fsm.LogSemiring;
import edu.ucla.fsm.RealSemiring;
import edu.ucla.fsm.RealWeight;
import edu.ucla.fsm.Semiring;
import edu.ucla.fsm.SparseLexicographicWeight;
import edu.ucla.fsm.StateIterator;
import edu.ucla.fsm.SubsetDeterminization;
import edu.ucla.fsm.SymbolTable;
import edu.ucla.fsm.Transition;
import edu.ucla.fsm.TransitionFactory;
import edu.ucla.fsm.TransitionIterator;
import edu.ucla.fsm.TropicalSemiring;
import edu.ucla.fsm.WeightFactory;
import edu.ucla.fsm.WeightFactory_MIntersect;
import edu.ucla.maxent.AcyclicBestPathMaxent2;
import edu.ucla.maxent.Constraint;
import edu.ucla.maxent.GraphSampler;
import edu.ucla.maxent.Maxent;
import edu.ucla.maxent.MaxentTrainer;
import edu.ucla.maxent.Regularizer;
import edu.ucla.maxent.TrellisBestPathMaxent;
import edu.ucla.util.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import pal.math.MFWithGradient;
import pal.math.OrthogonalHints;

public class MaxentModel
implements MFWithGradient {
    static StateIterator stateiter = new StateIterator();
    static TransitionIterator transiter = new TransitionIterator();
    Alphabet alphabet = null;
    Corpus corpus = null;
    Regularizer regularizer = null;
    MaxentTrainer trainer = null;
    RealSemiring RealSR = null;
    TropicalSemiring TropicalSR = null;
    LogSemiring LogSR = null;
    ExpectationSemiring ExpectationSR = null;
    double[] observed = null;
    double[] expected = null;
    double[] regularizerGrad = null;
    double[] grad = null;
    public HashSet<Constraint> constraintSet = new HashSet();
    public LinkedList<Constraint> constraintList = new LinkedList();
    double[] lambda = null;
    double D = 0.0;
    double[] dataPlog = null;
    double[] objective = null;
    double Z = 0.0;
    double logZ = 0.0;
    double[] partitionFunction = null;
    boolean buildEval = true;
    boolean cyclicEval = false;
    boolean addStarSegment = true;
    FSM eval = null;
    FSMQuick G = null;
    TransitionFactory F = new TransitionFactory().match(1).inputFrom(2).outputFrom(2).weightFactory((WeightFactory)new WeightFactory_MIntersect());
    Corpus sample = null;
    public static double INITIAL_WEIGHT = 1.0;
    public static double ALPHA = 0.999;
    public static double WEIGHT_LOWER_BOUND = 0.0;
    public static double WEIGHT_UPPER_BOUND = 25.0;
    public static int verbosity = 0;

    public MaxentModel() {
    }

    public MaxentModel(Alphabet alphabet, Corpus corpus, Regularizer regularizer, Constraint[] constraintArray, double[] dArray, boolean bl, boolean bl2, boolean bl3) {
        this.alphabet = alphabet;
        this.corpus = corpus;
        this.regularizer = regularizer;
        this.buildEval = bl;
        this.cyclicEval = bl2;
        this.addStarSegment = bl3;
        this.trainer = new MaxentTrainer(0.25, 100, 100, 0);
        if (bl) {
            this.eval = bl2 ? FSM.boundedSigmaStarAcceptor((SymbolTable)alphabet.symbolTable) : FSM.boundedTrellisAcceptor((SymbolTable)alphabet.symbolTable, (int)Maxent.minWordLength, (int)Maxent.maxWordLength);
        }
        if (bl3) {
            this.addStarSegment();
        }
        if (constraintArray != null) {
            for (Constraint constraint : constraintArray) {
                this.addSoftConstraint(constraint, true);
            }
        }
    }

    public void setWeights(double[] dArray) {
        System.arraycopy(dArray, 0, this.lambda, 0, this.lambda.length);
    }

    public void addFilter(FSM fSM) {
        if (!this.buildEval) {
            return;
        }
        this.eval = Intersect.apply((FSM)fSM, (FSM)this.eval, (TransitionFactory)new TransitionFactory().match(12).inputFrom(2).outputFrom(2).weightFrom(2));
        this.eval.prune().renameStates();
    }

    public void addHardConstraint(Constraint constraint) {
        if (!this.buildEval) {
            return;
        }
        FSM fSM = this.compileConstraint(constraint, true);
        this.eval = Intersect.apply((FSM)fSM, (FSM)this.eval, (TransitionFactory)new TransitionFactory().match(12).inputFrom(2).outputFrom(2).weightFrom(2));
        this.eval.prune().renameStates();
    }

    public void addStarSegment() {
        boolean[] blArray = new boolean[this.alphabet.number_of_segments];
        Arrays.fill(blArray, true);
        blArray[0] = false;
        int n = 0;
        for (int i = 0; i < this.alphabet.naturalClassDenotations.length; ++i) {
            if (!Arrays.equals(this.alphabet.naturalClassDenotations[i], blArray)) continue;
            n = i;
        }
        int[] nArray = new int[]{n};
        this.addSoftConstraint(new Constraint(Maxent.projection[0], nArray), true);
    }

    public void addSoftConstraint(Constraint[] constraintArray, double[] dArray) {
        if (!this.buildEval) {
            for (int i = 0; i < constraintArray.length; ++i) {
                this.addSoftConstraint(constraintArray[i], dArray == null ? INITIAL_WEIGHT : dArray[i], false);
            }
        } else {
            FSM fSM = FSM.boundedSigmaStarAcceptor((SymbolTable)this.alphabet.symbolTable);
            FSM fSM2 = fSM.copy();
            TransitionFactory transitionFactory = new TransitionFactory().match(1).inputFrom(2).outputFrom(2).weightFrom(2);
            for (int i = 0; i < constraintArray.length; ++i) {
                System.out.println("Adding constraint " + (i + 1) + "/" + constraintArray.length);
                Constraint constraint = constraintArray[i];
                if (this.constraintList.contains(constraint)) continue;
                this.constraintList.add(constraint);
                this.constraintSet.add(constraint);
                this.lambda = this.lambda == null ? new double[1] : Arrays.copyOf(this.lambda, this.lambda.length + 1);
                this.lambda[this.lambda.length - 1] = dArray == null ? INITIAL_WEIGHT : dArray[i];
                this.observed = this.observed == null ? new double[1] : Arrays.copyOf(this.observed, this.observed.length + 1);
                this.observed[this.observed.length - 1] = this.getObserved(constraint);
                FSM fSM3 = this.compileConstraint(constraint, false);
                fSM3 = Intersect.apply((FSM)fSM, (FSM)fSM3, (TransitionFactory)transitionFactory);
                fSM3 = SubsetDeterminization.apply((FSM)fSM3);
                fSM2 = Intersect.apply((FSM)fSM3, (FSM)fSM2, (TransitionFactory)this.F);
                fSM2.prune().renameStates();
            }
            this.grad = new double[this.lambda.length];
            this.regularizerGrad = new double[this.lambda.length];
            this.dataPlog = new double[this.lambda.length];
            this.objective = new double[this.lambda.length];
            this.partitionFunction = new double[this.lambda.length];
            this.RealSR = new RealSemiring();
            this.TropicalSR = new TropicalSemiring();
            this.LogSR = new LogSemiring();
            this.ExpectationSR = new ExpectationSemiring(this.lambda.length);
            this.updateEval(fSM2);
        }
    }

    public void addSoftConstraint(Constraint constraint, boolean bl) {
        this.addSoftConstraint(constraint, INITIAL_WEIGHT, bl);
    }

    public void addSoftConstraint(Constraint constraint, double d, boolean bl) {
        if (this.constraintList.contains(constraint)) {
            this.lambda[this.constraintList.indexOf((Object)constraint)] = d;
            return;
        }
        ++Maxent.numberOfConstraints;
        boolean bl2 = false;
        this.constraintSet.add(constraint);
        this.constraintList.add(constraint);
        this.lambda = this.lambda == null ? new double[1] : Arrays.copyOf(this.lambda, this.lambda.length + 1);
        this.lambda[this.lambda.length - 1] = d;
        this.observed = this.observed == null ? new double[1] : Arrays.copyOf(this.observed, this.observed.length + 1);
        this.observed[this.observed.length - 1] = this.getObserved(constraint);
        this.grad = new double[this.lambda.length];
        this.regularizerGrad = new double[this.lambda.length];
        this.RealSR = new RealSemiring();
        this.TropicalSR = new TropicalSemiring();
        this.LogSR = new LogSemiring();
        this.ExpectationSR = new ExpectationSemiring(this.lambda.length);
        if (this.buildEval) {
            FSM fSM = this.compileConstraint(constraint, false);
            this.updateEval(fSM);
        }
        if (this.corpus != null) {
            if (bl) {
                System.out.println("Retraining weights ...");
                this.trainer.apply(this, this.lambda);
                System.out.println("done");
            }
            this.dataPlog = this.dataPlog == null ? new double[1] : Arrays.copyOf(this.dataPlog, this.dataPlog.length + 1);
            this.dataPlog[this.dataPlog.length - 1] = this.getDataPlog();
            Maxent.dataPlog = this.dataPlog[this.dataPlog.length - 1];
            this.objective = this.objective == null ? new double[1] : Arrays.copyOf(this.objective, this.objective.length + 1);
            this.objective[this.objective.length - 1] = this.getObjectiveValue();
            Maxent.objectiveValue = this.objective[this.objective.length - 1];
            this.partitionFunction = this.partitionFunction == null ? new double[1] : Arrays.copyOf(this.partitionFunction, this.partitionFunction.length + 1);
            this.partitionFunction[this.partitionFunction.length - 1] = this.Z;
        }
    }

    public FSM compileConstraint(Constraint constraint, boolean bl) {
        FSM fSM = null;
        fSM = bl ? ConstraintCompiler.markednessHard((String)constraint.toRegExp(), (SymbolTable)this.alphabet.symbolTable) : ConstraintCompiler.markednessSoft((String)constraint.toRegExp(), (SymbolTable)this.alphabet.symbolTable);
        fSM = Intersect.apply((FSM)FSM.boundedSigmaStarAcceptor((SymbolTable)Maxent.projection[0].alphabet.symbolTable), (FSM)fSM, (TransitionFactory)new TransitionFactory().match(1).inputFrom(2).outputFrom(2).weightFrom(2));
        fSM.prune();
        fSM = SubsetDeterminization.apply((FSM)fSM);
        for (int n : fSM.initials) {
            ArrayList arrayList = (ArrayList)fSM.transitions.get(n);
            if (arrayList == null) continue;
            Collections.sort(arrayList, new Comparator<Transition>(){

                @Override
                public int compare(Transition transition, Transition transition2) {
                    if (transition.dest != transition2.dest) {
                        return transition.dest < transition2.dest ? -1 : 1;
                    }
                    if (transition.input != transition2.input) {
                        return transition.input < transition2.input ? -1 : 1;
                    }
                    if (transition.output != transition2.output) {
                        return transition.output < transition2.output ? -1 : 1;
                    }
                    if (!transition.weight.equals((Object)transition2.weight)) {
                        return ((IntegerWeight)transition.weight).intValue() < ((IntegerWeight)transition2.weight).intValue() ? -1 : 1;
                    }
                    return 0;
                }
            });
            Transition transition = null;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Transition transition2 = (Transition)iterator.next();
                if (transition != null && transition2.dest == transition.dest) {
                    iterator.remove();
                    continue;
                }
                transition = transition2;
            }
        }
        return fSM;
    }

    public void updateEval(FSM fSM) {
        this.eval = Intersect.apply((FSM)fSM, (FSM)this.eval, (TransitionFactory)this.F);
        this.eval.prune().renameStates();
        this.eval = SubsetDeterminization.apply((FSM)this.eval);
        this.G = new FSMQuick(this.eval, (Semiring)new LexicographicSemiring(this.lambda.length));
        for (int n : this.G.topologicalOrder) {
            if (this.G.transitions[n] == null) continue;
            for (Transition transition : this.G.transitions[n]) {
                transition.weight = new SparseLexicographicWeight((LexicographicWeight)transition.weight);
            }
        }
        if (this.cyclicEval) {
            TrellisBestPathMaxent.init(this.G, this.lambda.length);
        } else {
            AcyclicBestPathMaxent2.init(this.G, this.lambda.length);
        }
    }

    public FSM getEval() {
        return this.eval;
    }

    public int getNumConstraints() {
        return this.lambda.length;
    }

    public double[] getObserved() {
        return this.observed;
    }

    public double getObserved(Constraint constraint) {
        if (this.corpus == null) {
            return 0.0;
        }
        return Maxent.scale * (double)constraint.evaluateCorpus();
    }

    public double[] getExpected() {
        ExpectationSemiringWeight expectationSemiringWeight = null;
        expectationSemiringWeight = this.cyclicEval ? (ExpectationSemiringWeight)TrellisBestPathMaxent.applyExpectationSemiring(this.G, this.lambda, Maxent.maxWordLength + 2) : (ExpectationSemiringWeight)AcyclicBestPathMaxent2.applyExpectationSemiring(this.G, this.lambda);
        this.expected = expectationSemiringWeight.pv;
        for (int i = this.lambda.length - 1; i >= 0; --i) {
            int n = i;
            this.expected[n] = this.expected[n] / expectationSemiringWeight.p;
            if (!Double.isNaN(this.expected[i]) && !Double.isInfinite(this.expected[i])) continue;
            this.expected[i] = Double.MAX_VALUE;
        }
        System.out.print(". ");
        return this.expected;
    }

    public double violations(int[] nArray, Constraint constraint) {
        double d = constraint.evaluate(nArray);
        return d;
    }

    public double[] violations(int[] nArray) {
        double[] dArray = new double[this.lambda.length];
        for (int i = this.lambda.length - 1; i >= 0; --i) {
            dArray[i] = this.violations(nArray, this.constraintList.get(i));
        }
        return dArray;
    }

    public double h(int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = this.lambda.length - 1; i >= 0; --i) {
            d2 = this.lambda[i] * this.violations(nArray, this.constraintList.get(i));
            d -= d2;
        }
        return d;
    }

    public double pstar(int[] nArray) {
        double d = Math.exp(this.h(nArray));
        return d;
    }

    public double getDataPlog() {
        if (this.corpus == null || this.corpus.data == null) {
            return Double.MAX_VALUE;
        }
        RealWeight realWeight = null;
        realWeight = this.cyclicEval ? (RealWeight)TrellisBestPathMaxent.applyLogSemiring(this.G, this.lambda, Maxent.maxWordLength + 2) : (RealWeight)AcyclicBestPathMaxent2.applyLogSemiring(this.G, this.lambda);
        this.Z = Math.exp(-realWeight.doubleValue());
        if (Double.isNaN(this.Z) || Double.isInfinite(this.Z)) {
            this.Z = Double.MIN_VALUE;
        }
        this.logZ = -realWeight.doubleValue();
        if (Double.isNaN(this.logZ) || Double.isInfinite(this.logZ)) {
            this.logZ = -1.7976931348623157E308;
        }
        this.D = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        for (int[] nArray : this.corpus.data.keySet()) {
            d2 = ((Counter)this.corpus.data.get((Object)nArray)).value;
            this.D += d2 * this.h(nArray);
            d += d2;
        }
        this.D -= d * this.logZ;
        this.D = -Maxent.scale * this.D;
        return this.D;
    }

    public double getObjectiveValue() {
        if (this.corpus == null || this.corpus.data == null) {
            return Double.MAX_VALUE;
        }
        double d = 0.0;
        for (int i = this.lambda.length - 1; i >= 0; --i) {
            d += this.lambda[i] * this.observed[i];
        }
        double d2 = this.getDataPlog() - Maxent.gamma * d;
        return d2;
    }

    public Corpus getSample() {
        GraphSampler graphSampler = new GraphSampler();
        FSM fSM = null;
        if (this.cyclicEval) {
            fSM = FSM.boundedTrellisAcceptor((SymbolTable)this.alphabet.symbolTable, (int)Maxent.minWordLength, (int)Maxent.maxWordLength);
            fSM = Intersect.apply((FSM)fSM, (FSM)this.eval, (TransitionFactory)new TransitionFactory().match(1).inputFrom(2).outputFrom(2).weightFrom(2));
        } else {
            fSM = this.eval;
        }
        graphSampler.init(fSM, this.lambda, Maxent.epsilon);
        this.sample = new Corpus(this.alphabet.number_of_segments, true);
        int n = this.corpus.size >= Maxent.minimumSampleSize ? this.corpus.size : Maxent.minimumSampleSize;
        n = n <= Maxent.maximumSampleSize ? n : Maxent.maximumSampleSize;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            graphSampler.sample();
            this.sample.updateCounts(GraphSampler.sample, n2, GraphSampler.sampleLength);
        }
        this.sample.compile();
        System.out.println("sample size: " + this.sample.size + " (number of distinct strings: " + this.sample.data_size + ")");
        Maxent.sample = this.sample;
        return this.sample;
    }

    public int getNumArguments() {
        return this.lambda.length;
    }

    public double getLowerBound(int n) {
        return WEIGHT_LOWER_BOUND;
    }

    public double getUpperBound(int n) {
        return WEIGHT_UPPER_BOUND;
    }

    public OrthogonalHints getOrthogonalHints() {
        return null;
    }

    public double evaluate(double[] dArray) {
        double d = 0.0;
        return d;
    }

    public double evaluate(double[] dArray, double[] dArray2) {
        this.computeGradient(dArray, dArray2);
        return 0.0;
    }

    public void computeGradient(double[] dArray, double[] dArray2) {
        int n;
        this.setWeights(dArray);
        this.observed = this.getObserved();
        this.expected = this.getExpected();
        if (this.regularizer != null) {
            this.regularizerGrad = this.regularizer.grad(this.lambda, this.regularizerGrad);
        }
        int n2 = this.lambda.length;
        double d = 0.0;
        double d2 = 0.0;
        for (n = n2 - 1; n >= 0; --n) {
            int n3 = n;
            this.expected[n3] = this.expected[n3] * (Maxent.scale * (double)this.corpus.size);
            d2 = (1.0 + Maxent.gamma) * (this.observed[n] + d) - this.expected[n];
            if (this.regularizer != null) {
                d2 += this.regularizerGrad[n];
            }
            dArray2[n] = d2;
        }
        if (verbosity > 5) {
            System.out.println("lambda = " + Arrays.toString(this.lambda));
            System.out.println("observed = " + Arrays.toString(this.observed));
            System.out.println("expected = " + Arrays.toString(this.expected));
            System.out.println("regularizerGrad = " + Arrays.toString(this.regularizerGrad));
        }
        if (verbosity > 5) {
            System.out.print("(O-E) = ");
            for (n = 0; n < this.observed.length; ++n) {
                System.out.print(this.observed[n] - this.expected[n] + " ");
            }
            System.out.println();
            System.out.println("energy term = " + Maxent.gamma);
            System.out.println("grad = " + Arrays.toString(dArray2));
        }
    }

    public String toString() {
        this.expected = this.getExpected();
        StringBuffer stringBuffer = new StringBuffer();
        Constraint constraint = null;
        stringBuffer.append("projection\tconstraint\tweight\tobserved\texpected\tplog\tobjective\tZ\n");
        for (int i = 0; i < this.constraintList.size(); ++i) {
            constraint = this.constraintList.get(i);
            stringBuffer.append(constraint.projection.name);
            stringBuffer.append("\t");
            stringBuffer.append(constraint);
            stringBuffer.append("\t");
            stringBuffer.append(this.lambda[i]);
            stringBuffer.append("\t");
            stringBuffer.append(this.observed == null ? Double.NaN : this.observed[i]);
            stringBuffer.append("\t");
            stringBuffer.append(Maxent.scale * (double)this.corpus.size * this.expected[i]);
            stringBuffer.append("\t");
            stringBuffer.append(this.dataPlog == null ? null : Double.valueOf(this.dataPlog[i]));
            stringBuffer.append("\t");
            stringBuffer.append(this.objective == null ? null : Double.valueOf(this.objective[i]));
            stringBuffer.append("\t");
            stringBuffer.append(this.partitionFunction == null ? null : Double.valueOf(this.partitionFunction[i]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

